/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeAllocationOrdering;
import org.elasticsearch.common.collect.Iterators;

public class OrderedShardsIterator
implements Iterator<ShardRouting> {
    private final ArrayDeque<NodeAndShardIterator> queue;

    public static OrderedShardsIterator createForNecessaryMoves(RoutingAllocation allocation, NodeAllocationOrdering ordering) {
        return OrderedShardsIterator.create(allocation.routingNodes(), OrderedShardsIterator.createShardsComparator(allocation), ordering);
    }

    public static OrderedShardsIterator createForBalancing(RoutingAllocation allocation, NodeAllocationOrdering ordering) {
        return OrderedShardsIterator.create(allocation.routingNodes(), OrderedShardsIterator.createShardsComparator(allocation).reversed(), ordering);
    }

    private static OrderedShardsIterator create(RoutingNodes routingNodes, Comparator<ShardRouting> shardOrder, NodeAllocationOrdering nodeOrder) {
        ArrayDeque<NodeAndShardIterator> queue = new ArrayDeque<NodeAndShardIterator>(routingNodes.size());
        for (String nodeId : nodeOrder.sort(routingNodes.getAllNodeIds())) {
            RoutingNode node = routingNodes.node(nodeId);
            if (node.size() <= 0) continue;
            queue.add(new NodeAndShardIterator(nodeId, OrderedShardsIterator.sort(shardOrder, node.copyShards())));
        }
        return new OrderedShardsIterator(queue);
    }

    private static Iterator<ShardRouting> sort(Comparator<ShardRouting> comparator, ShardRouting[] shards) {
        Arrays.sort(shards, comparator);
        return Iterators.forArray(shards);
    }

    private static Comparator<ShardRouting> createShardsComparator(RoutingAllocation allocation) {
        return Comparator.comparing(shard -> {
            ProjectMetadata project = allocation.metadata().projectFor(shard.index());
            IndexAbstraction index = (IndexAbstraction)project.getIndicesLookup().get(shard.getIndexName());
            if (index != null && index.getParentDataStream() != null) {
                return Objects.equals(index.getParentDataStream().getWriteIndex(), shard.index()) ? 0 : 2;
            }
            return 1;
        });
    }

    private OrderedShardsIterator(ArrayDeque<NodeAndShardIterator> queue) {
        this.queue = queue;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public ShardRouting next() {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        NodeAndShardIterator entry = this.queue.peek();
        assert (entry.iterator.hasNext());
        ShardRouting nextShard = entry.iterator.next();
        if (!entry.iterator.hasNext()) {
            this.queue.poll();
        }
        return nextShard;
    }

    public void dePrioritizeNode(String nodeId) {
        NodeAndShardIterator entry = this.queue.peek();
        if (entry != null && Objects.equals(nodeId, entry.nodeId)) {
            this.queue.offer(this.queue.poll());
        }
    }

    private record NodeAndShardIterator(String nodeId, Iterator<ShardRouting> iterator) {
    }
}

