/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.Index;

public class ResizeSourceIndexSettingsUpdater
implements RoutingChangesObserver {
    private final Set<Index> changes = new HashSet<Index>();

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        if (startedShard.primary() && initializingShard.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
            assert (startedShard.recoverySource() == null) : "recovery source should have been removed once shard is started";
            this.changes.add(startedShard.shardId().getIndex());
        }
    }

    public Metadata applyChanges(Metadata metadata, GlobalRoutingTable routingTable) {
        if (!this.changes.isEmpty()) {
            Map<ProjectMetadata, Map> updatesByProject = Maps.newHashMapWithExpectedSize(routingTable.size());
            for (Index index : this.changes) {
                ProjectMetadata project = metadata.projectFor(index);
                IndexMetadata indexMetadata = project.getIndexSafe(index);
                if (!routingTable.routingTable(project.id()).index(index).allPrimaryShardsActive()) continue;
                assert (indexMetadata.getResizeSourceIndex() != null) : "no resize source index for " + String.valueOf(index);
                Settings.Builder builder = Settings.builder().put(indexMetadata.getSettings());
                builder.remove(IndexMetadata.INDEX_SHRINK_INITIAL_RECOVERY_KEY);
                builder.remove("index.resize.source.uuid");
                if (Strings.isNullOrEmpty(indexMetadata.getLifecyclePolicyName())) {
                    builder.remove("index.resize.source.name");
                }
                Map updates = updatesByProject.computeIfAbsent(project, ignore -> Maps.newMapWithExpectedSize(this.changes.size()));
                updates.put(index, builder.build());
            }
            Metadata.Builder builder = null;
            for (Map.Entry entry : updatesByProject.entrySet()) {
                Map updates;
                ProjectMetadata origProject = (ProjectMetadata)entry.getKey();
                ProjectMetadata updatedProject = origProject.withIndexSettingsUpdates(updates = (Map)entry.getValue());
                if (updatedProject == origProject) continue;
                if (builder == null) {
                    builder = Metadata.builder(metadata);
                }
                builder.put(updatedProject);
            }
            if (builder == null) {
                return metadata;
            }
            return builder.build();
        }
        return metadata;
    }

    int numberOfChanges() {
        return this.changes.size();
    }
}

