/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasInfo;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComponentTemplateMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ProjectSecrets;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class ProjectMetadata
implements Iterable<IndexMetadata>,
Diffable<ProjectMetadata>,
ChunkedToXContent {
    private static final NamedDiffableValueSerializer<Metadata.ProjectCustom> PROJECT_CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Metadata.ProjectCustom>(Metadata.ProjectCustom.class);
    private static final TransportVersion CLUSTER_STATE_PROJECTS_SETTINGS = TransportVersion.fromName("cluster_state_projects_settings");
    private final ProjectId id;
    private final ImmutableOpenMap<String, IndexMetadata> indices;
    private final ImmutableOpenMap<String, Set<Index>> aliasedIndices;
    private final ImmutableOpenMap<String, IndexTemplateMetadata> templates;
    private final ImmutableOpenMap<String, Metadata.ProjectCustom> customs;
    private final ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadata;
    private final int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final String[] allIndices;
    private final String[] visibleIndices;
    private final String[] allOpenIndices;
    private final String[] visibleOpenIndices;
    private final String[] allClosedIndices;
    private final String[] visibleClosedIndices;
    private volatile SortedMap<String, IndexAbstraction> indicesLookup;
    private final Map<String, MappingMetadata> mappingsByHash;
    private final IndexVersion oldestIndexVersion;
    public static final ClusterBlock PROJECT_UNDER_DELETION_BLOCK = new ClusterBlock(15, "project is under deletion", false, false, false, RestStatus.NOT_FOUND, EnumSet.of(ClusterBlockLevel.READ, ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_READ, ClusterBlockLevel.METADATA_WRITE));

    private ProjectMetadata(ProjectId id, ImmutableOpenMap<String, IndexMetadata> indices, ImmutableOpenMap<String, Set<Index>> aliasedIndices, ImmutableOpenMap<String, IndexTemplateMetadata> templates, ImmutableOpenMap<String, Metadata.ProjectCustom> customs, ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadata, int totalNumberOfShards, int totalOpenIndexShards, String[] allIndices, String[] visibleIndices, String[] allOpenIndices, String[] visibleOpenIndices, String[] allClosedIndices, String[] visibleClosedIndices, SortedMap<String, IndexAbstraction> indicesLookup, Map<String, MappingMetadata> mappingsByHash, IndexVersion oldestIndexVersion) {
        this.id = id;
        this.indices = indices;
        this.aliasedIndices = aliasedIndices;
        this.templates = templates;
        this.customs = customs;
        this.reservedStateMetadata = reservedStateMetadata;
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.allIndices = allIndices;
        this.visibleIndices = visibleIndices;
        this.allOpenIndices = allOpenIndices;
        this.visibleOpenIndices = visibleOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.visibleClosedIndices = visibleClosedIndices;
        this.indicesLookup = indicesLookup;
        this.mappingsByHash = mappingsByHash;
        this.oldestIndexVersion = oldestIndexVersion;
        assert (this.assertConsistent());
    }

    private boolean assertConsistent() {
        DataStreamMetadata dsMetadata;
        block10: {
            SortedMap<String, IndexAbstraction> lookup = this.indicesLookup;
            dsMetadata = this.custom("data_stream", DataStreamMetadata.EMPTY);
            assert (lookup == null || lookup.equals(Builder.buildIndicesLookup(dsMetadata, this.indices)));
            try {
                Builder.ensureNoNameCollisions(this.aliasedIndices.keySet(), this.indices, dsMetadata);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e);
            }
        }
        assert (Builder.assertDataStreams(this.indices, dsMetadata));
        assert (Set.of(this.allIndices).equals(this.indices.keySet()));
        Function<Predicate, Set> indicesByPredicate = predicate -> this.indices.entrySet().stream().filter(entry -> predicate.test((IndexMetadata)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
        assert (Set.of(this.allOpenIndices).equals(indicesByPredicate.apply(idx -> idx.getState() == IndexMetadata.State.OPEN)));
        assert (Set.of(this.allClosedIndices).equals(indicesByPredicate.apply(idx -> idx.getState() == IndexMetadata.State.CLOSE)));
        assert (Set.of(this.visibleIndices).equals(indicesByPredicate.apply(idx -> !idx.isHidden())));
        assert (Set.of(this.visibleOpenIndices).equals(indicesByPredicate.apply(idx -> !idx.isHidden() && idx.getState() == IndexMetadata.State.OPEN)));
        assert (Set.of(this.visibleClosedIndices).equals(indicesByPredicate.apply(idx -> !idx.isHidden() && idx.getState() == IndexMetadata.State.CLOSE)));
        return true;
    }

    public ProjectMetadata withLifecycleState(Index index, LifecycleExecutionState lifecycleState) {
        Objects.requireNonNull(index, "index must not be null");
        Objects.requireNonNull(lifecycleState, "lifecycleState must not be null");
        IndexMetadata indexMetadata = this.getIndexSafe(index);
        if (lifecycleState.equals(indexMetadata.getLifecycleExecutionState())) {
            return this;
        }
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
        indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
        indexMetadataBuilder.putCustom("ilm", lifecycleState.asMap());
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder(this.indices);
        builder.put(index.getName(), indexMetadataBuilder.build());
        return new ProjectMetadata(this.id, builder.build(), this.aliasedIndices, this.templates, this.customs, this.reservedStateMetadata, this.totalNumberOfShards, this.totalOpenIndexShards, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion);
    }

    public ProjectMetadata withIndexSettingsUpdates(Map<Index, Settings> updates) {
        Objects.requireNonNull(updates, "no indices to update settings for");
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder(this.indices);
        updates.forEach((? super K index, ? super V settings) -> {
            IndexMetadata previous = (IndexMetadata)builder.remove(index.getName());
            assert (previous != null) : index;
            builder.put(index.getName(), IndexMetadata.builder(previous).settingsVersion(previous.getSettingsVersion() + 1L).settings((Settings)settings).build());
        });
        return new ProjectMetadata(this.id, builder.build(), this.aliasedIndices, this.templates, this.customs, this.reservedStateMetadata, this.totalNumberOfShards, this.totalOpenIndexShards, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion);
    }

    public ProjectMetadata withAllocationAndTermUpdatesOnly(Map<String, IndexMetadata> updates) {
        if (updates.isEmpty()) {
            return this;
        }
        ImmutableOpenMap.Builder<String, IndexMetadata> updatedIndicesBuilder = ImmutableOpenMap.builder(this.indices);
        updatedIndicesBuilder.putAllFromMap(updates);
        return new ProjectMetadata(this.id, updatedIndicesBuilder.build(), this.aliasedIndices, this.templates, this.customs, this.reservedStateMetadata, this.totalNumberOfShards, this.totalOpenIndexShards, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion);
    }

    public ProjectMetadata withAddedIndex(IndexMetadata index) {
        Map<String, MappingMetadata> updatedMappingsByHash;
        String[] updatedClosedIndices;
        String[] updatedVisibleClosedIndices;
        String[] updatedVisibleOpenIndices;
        String[] updatedOpenIndices;
        String indexName = index.getIndex().getName();
        this.ensureNoNameCollision(indexName);
        Map<String, AliasMetadata> aliases = index.getAliases();
        ImmutableOpenMap<String, Set<Index>> updatedAliases = this.aliasesAfterAddingIndex(index, aliases);
        String[] updatedVisibleIndices = index.isHidden() ? this.visibleIndices : ArrayUtils.append(this.visibleIndices, indexName);
        String[] updatedAllIndices = ArrayUtils.append(this.allIndices, indexName);
        switch (index.getState()) {
            case OPEN: {
                updatedOpenIndices = ArrayUtils.append(this.allOpenIndices, indexName);
                updatedVisibleOpenIndices = !index.isHidden() ? ArrayUtils.append(this.visibleOpenIndices, indexName) : this.visibleOpenIndices;
                updatedVisibleClosedIndices = this.visibleClosedIndices;
                updatedClosedIndices = this.allClosedIndices;
                break;
            }
            case CLOSE: {
                updatedOpenIndices = this.allOpenIndices;
                updatedClosedIndices = ArrayUtils.append(this.allClosedIndices, indexName);
                updatedVisibleOpenIndices = this.visibleOpenIndices;
                if (!index.isHidden()) {
                    updatedVisibleClosedIndices = ArrayUtils.append(this.visibleClosedIndices, indexName);
                    break;
                }
                updatedVisibleClosedIndices = this.visibleClosedIndices;
                break;
            }
            default: {
                throw new AssertionError((Object)"impossible, index is either open or closed");
            }
        }
        MappingMetadata mappingMetadata = index.mapping();
        if (mappingMetadata == null) {
            updatedMappingsByHash = this.mappingsByHash;
        } else {
            MappingMetadata existingMapping = this.mappingsByHash.get(mappingMetadata.getSha256());
            if (existingMapping != null) {
                index = index.withMappingMetadata(existingMapping);
                updatedMappingsByHash = this.mappingsByHash;
            } else {
                updatedMappingsByHash = Maps.copyMapWithAddedEntry(this.mappingsByHash, mappingMetadata.getSha256(), mappingMetadata);
            }
        }
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder(this.indices);
        builder.put(indexName, index);
        ImmutableOpenMap<String, IndexMetadata> indicesMap = builder.build();
        for (Map.Entry<String, Set<Index>> entry : updatedAliases.entrySet()) {
            List<IndexMetadata> aliasIndices = entry.getValue().stream().map(idx -> (IndexMetadata)indicesMap.get(idx.getName())).toList();
            Builder.validateAlias(entry.getKey(), aliasIndices);
        }
        return new ProjectMetadata(this.id, indicesMap, updatedAliases, this.templates, this.customs, this.reservedStateMetadata, this.totalNumberOfShards + index.getTotalNumberOfShards(), this.totalOpenIndexShards + (index.getState() == IndexMetadata.State.OPEN ? index.getTotalNumberOfShards() : 0), updatedAllIndices, updatedVisibleIndices, updatedOpenIndices, updatedVisibleOpenIndices, updatedClosedIndices, updatedVisibleClosedIndices, null, updatedMappingsByHash, IndexVersion.min(index.getCompatibilityVersion(), this.oldestIndexVersion));
    }

    private ImmutableOpenMap<String, Set<Index>> aliasesAfterAddingIndex(IndexMetadata index, Map<String, AliasMetadata> aliases) {
        if (aliases.isEmpty()) {
            return this.aliasedIndices;
        }
        String indexName = index.getIndex().getName();
        ImmutableOpenMap.Builder<String, Set<Index>> aliasesBuilder = ImmutableOpenMap.builder(this.aliasedIndices);
        for (String alias : aliases.keySet()) {
            Set<Index> updated;
            this.ensureNoNameCollision(alias);
            if (this.aliasedIndices.containsKey(indexName)) {
                throw new IllegalArgumentException("alias with name [" + indexName + "] already exists");
            }
            Set<Index> found = aliasesBuilder.get(alias);
            if (found == null) {
                updated = Set.of(index.getIndex());
            } else {
                HashSet<Index> tmp = new HashSet<Index>(found);
                tmp.add(index.getIndex());
                updated = Set.copyOf(tmp);
            }
            aliasesBuilder.put(alias, updated);
        }
        return aliasesBuilder.build();
    }

    private void ensureNoNameCollision(String indexName) {
        if (this.indices.containsKey(indexName)) {
            throw new IllegalArgumentException("index with name [" + indexName + "] already exists");
        }
        if (this.dataStreams().containsKey(indexName)) {
            throw new IllegalArgumentException("data stream with name [" + indexName + "] already exists");
        }
        if (this.dataStreamAliases().containsKey(indexName)) {
            throw new IllegalStateException("data stream alias and indices alias have the same name (" + indexName + ")");
        }
    }

    public ProjectId id() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.id.id() + "}";
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        return metadata != null && metadata.getIndexUUID().equals(index.getUUID());
    }

    public boolean hasIndexMetadata(IndexMetadata indexMetadata) {
        return this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata;
    }

    public boolean hasIndexAbstraction(String index) {
        return this.getIndicesLookup().containsKey(index);
    }

    public IndexMetadata index(String index) {
        return this.indices.get(index);
    }

    public IndexMetadata index(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null && metadata.getIndexUUID().equals(index.getUUID())) {
            return metadata;
        }
        return null;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public IndexMetadata getIndexSafe(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null) {
            if (metadata.getIndexUUID().equals(index.getUUID())) {
                return metadata;
            }
            throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + metadata.getIndexUUID() + "]"));
        }
        throw new IndexNotFoundException(index, this.id);
    }

    public SortedMap<String, IndexAbstraction> getIndicesLookup() {
        SortedMap<String, IndexAbstraction> lookup = this.indicesLookup;
        if (lookup == null) {
            lookup = this.buildIndicesLookup();
        }
        return lookup;
    }

    private synchronized SortedMap<String, IndexAbstraction> buildIndicesLookup() {
        SortedMap<String, IndexAbstraction> i = this.indicesLookup;
        if (i != null) {
            return i;
        }
        this.indicesLookup = i = Builder.buildIndicesLookup(this.custom("data_stream", DataStreamMetadata.EMPTY), this.indices);
        return i;
    }

    public boolean sameIndicesLookup(ProjectMetadata other) {
        return this.indicesLookup == other.indicesLookup;
    }

    public boolean hasAlias(String aliasName) {
        return this.aliasedIndices.containsKey(aliasName) || this.dataStreamAliases().containsKey(aliasName);
    }

    public Map<String, List<AliasMetadata>> findAllAliases(String[] concreteIndices) {
        return this.findAliases(Strings.EMPTY_ARRAY, concreteIndices);
    }

    public Map<String, List<AliasMetadata>> findAliases(String[] aliases, String[] concreteIndices) {
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Function getter = index -> List.copyOf(this.indices.get(index).getAliases().values());
        this.findAliasInfo(aliases, concreteIndices, getter, mapBuilder::put);
        return mapBuilder.build();
    }

    public Set<Index> aliasedIndices(String aliasName) {
        Objects.requireNonNull(aliasName);
        return this.aliasedIndices.getOrDefault((Object)aliasName, Set.of());
    }

    public Set<String> aliasedIndices() {
        return this.aliasedIndices.keySet();
    }

    public boolean equalsAliases(ProjectMetadata other) {
        for (IndexMetadata otherIndex : other.indices().values()) {
            IndexMetadata thisIndex = this.index(otherIndex.getIndex());
            if (thisIndex != null && otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        Map<String, DataStreamAlias> thisAliases = this.dataStreamAliases();
        Map<String, DataStreamAlias> otherAliases = other.dataStreamAliases();
        if (otherAliases.size() != thisAliases.size()) {
            return false;
        }
        for (DataStreamAlias otherAlias : otherAliases.values()) {
            DataStreamAlias thisAlias = thisAliases.get(otherAlias.getName());
            if (thisAlias != null && thisAlias.equals(otherAlias)) continue;
            return false;
        }
        return true;
    }

    public Map<String, MappingMetadata> findMappings(String[] concreteIndices, Function<String, ? extends Predicate<String>> fieldFilter, Runnable onNextIndex) {
        assert (Transports.assertNotTransportThread("decompressing mappings is too expensive for a transport thread"));
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        Stream.of(concreteIndices).filter(this.indices::containsKey).forEach(index -> {
            onNextIndex.run();
            IndexMetadata indexMetadata = this.indices.get(index);
            Predicate fieldPredicate = (Predicate)fieldFilter.apply((String)index);
            indexMapBuilder.put(index, ProjectMetadata.filterFields(indexMetadata.mapping(), fieldPredicate));
        });
        return indexMapBuilder.build();
    }

    public Map<String, MappingMetadata> getMappingsByHash() {
        return this.mappingsByHash;
    }

    private static MappingMetadata filterFields(MappingMetadata mappingMetadata, Predicate<String> fieldPredicate) {
        if (mappingMetadata == null) {
            return MappingMetadata.EMPTY_MAPPINGS;
        }
        if (fieldPredicate == FieldPredicate.ACCEPT_ALL) {
            return mappingMetadata;
        }
        Map sourceAsMap = (Map)XContentHelper.convertToMap(mappingMetadata.source().compressedReference(), true).v2();
        Map mapping = sourceAsMap.size() == 1 && sourceAsMap.containsKey(mappingMetadata.type()) ? (Map)sourceAsMap.get(mappingMetadata.type()) : sourceAsMap;
        Map properties = (Map)mapping.get("properties");
        if (properties == null || properties.isEmpty()) {
            return mappingMetadata;
        }
        ProjectMetadata.filterFields("", properties, fieldPredicate);
        return new MappingMetadata(mappingMetadata.type(), sourceAsMap);
    }

    private static boolean filterFields(String currentPath, Map<String, Object> fields, Predicate<String> fieldPredicate) {
        assert (fieldPredicate != FieldPredicate.ACCEPT_ALL);
        Iterator<Map.Entry<String, Object>> entryIterator = fields.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map map;
            Map.Entry<String, Object> entry = entryIterator.next();
            String newPath = ProjectMetadata.mergePaths(currentPath, entry.getKey());
            Object value = entry.getValue();
            boolean mayRemove = true;
            boolean isMultiField = false;
            if (value instanceof Map) {
                map = (Map)value;
                Map properties = (Map)map.get("properties");
                if (properties != null) {
                    mayRemove = ProjectMetadata.filterFields(newPath, properties, fieldPredicate);
                } else {
                    Map subFields = (Map)map.get("fields");
                    if (subFields != null) {
                        isMultiField = true;
                        mayRemove = ProjectMetadata.filterFields(newPath, subFields, fieldPredicate);
                        if (mayRemove) {
                            map.remove("fields");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("cannot filter mappings, found unknown element of type [" + String.valueOf(value.getClass()) + "]");
            }
            if (fieldPredicate.test(newPath)) continue;
            if (mayRemove) {
                entryIterator.remove();
                continue;
            }
            if (!isMultiField) continue;
            map = (Map)value;
            Map subFields = (Map)map.get("fields");
            assert (!subFields.isEmpty());
            map.put("properties", subFields);
            map.remove("fields");
            map.remove("type");
        }
        return fields.isEmpty();
    }

    private static String mergePaths(String path, String field) {
        return path.isEmpty() ? field : path + "." + field;
    }

    public Map<String, IndexMetadata> indices() {
        return this.indices;
    }

    public Map<String, IndexTemplateMetadata> templates() {
        return this.templates;
    }

    public boolean indexIsADataStream(String indexName) {
        SortedMap<String, IndexAbstraction> lookup = this.getIndicesLookup();
        IndexAbstraction abstraction = (IndexAbstraction)lookup.get(indexName);
        return abstraction != null && abstraction.getType() == IndexAbstraction.Type.DATA_STREAM;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteVisibleIndices() {
        return this.visibleIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteVisibleOpenIndices() {
        return this.visibleOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteVisibleClosedIndices() {
        return this.visibleClosedIndices;
    }

    public boolean indicesLookupInitialized() {
        return this.indicesLookup != null;
    }

    public IndexVersion oldestIndexVersion() {
        return this.oldestIndexVersion;
    }

    public String resolveWriteIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        Index writeIndexName = result.getWriteIndex();
        if (writeIndexName == null) {
            throw new IllegalArgumentException("alias [" + aliasOrIndex + "] does not have a write index");
        }
        AliasMetadata writeIndexAliasMetadata = this.index(writeIndexName).getAliases().get(result.getName());
        if (writeIndexAliasMetadata != null) {
            return ProjectMetadata.resolveRouting(routing, aliasOrIndex, writeIndexAliasMetadata);
        }
        return routing;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        if (result.getIndices().size() > 1) {
            ProjectMetadata.rejectSingleIndexOperation(aliasOrIndex, result);
        }
        return ProjectMetadata.resolveRouting(routing, aliasOrIndex, AliasMetadata.getFirstAliasMetadata(this, result));
    }

    private static String resolveRouting(@Nullable String routing, String aliasOrIndex, AliasMetadata aliasMd) {
        if (aliasMd.indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    private static void rejectSingleIndexOperation(String aliasOrIndex, IndexAbstraction result) {
        Object[] indexNames = new String[result.getIndices().size()];
        int i = 0;
        for (Index indexName : result.getIndices()) {
            indexNames[i++] = indexName.getName();
        }
        throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indices.values().iterator();
    }

    public Stream<IndexMetadata> stream() {
        return this.indices.values().stream();
    }

    public int size() {
        return this.indices.size();
    }

    public <T extends Metadata.ProjectCustom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Metadata.ProjectCustom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault((Object)type, defaultValue);
    }

    public ImmutableOpenMap<String, Metadata.ProjectCustom> customs() {
        return this.customs;
    }

    public Map<String, ReservedStateMetadata> reservedStateMetadata() {
        return this.reservedStateMetadata;
    }

    public Map<String, DataStream> dataStreams() {
        return this.custom("data_stream", DataStreamMetadata.EMPTY).dataStreams();
    }

    public Map<String, DataStreamAlias> dataStreamAliases() {
        return this.custom("data_stream", DataStreamMetadata.EMPTY).getDataStreamAliases();
    }

    public Map<String, List<DataStreamAlias>> dataStreamAliasesByDataStream() {
        return this.dataStreamAliases().values().stream().flatMap(dsa -> dsa.getDataStreams().stream().map(ds -> Map.entry(ds, dsa))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public Map<String, DataStream> findDataStreams(String ... concreteIndices) {
        assert (concreteIndices != null);
        ImmutableOpenMap.Builder<String, DataStream> builder = ImmutableOpenMap.builder();
        SortedMap<String, IndexAbstraction> lookup = this.getIndicesLookup();
        for (String indexName : concreteIndices) {
            IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
            assert (index != null);
            assert (index.getType() == IndexAbstraction.Type.CONCRETE_INDEX);
            if (index.getParentDataStream() == null) continue;
            builder.put(indexName, index.getParentDataStream());
        }
        return builder.build();
    }

    public Map<String, List<DataStreamAlias>> findDataStreamAliases(String[] aliases, String[] dataStreams) {
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Map<String, List<DataStreamAlias>> dataStreamAliases = this.dataStreamAliasesByDataStream();
        this.findAliasInfo(aliases, dataStreams, dataStream -> dataStreamAliases.getOrDefault(dataStream, List.of()), mapBuilder::put);
        return mapBuilder.build();
    }

    private <T extends AliasInfo> void findAliasInfo(String[] aliases, String[] possibleMatches, Function<String, List<T>> getter, BiConsumer<String, List<T>> setter) {
        assert (aliases != null);
        assert (possibleMatches != null);
        if (possibleMatches.length == 0) {
            return;
        }
        String[] patterns = new String[aliases.length];
        boolean[] include = new boolean[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias.charAt(0) == '-') {
                patterns[i] = alias.substring(1);
                include[i] = false;
                continue;
            }
            patterns[i] = alias;
            include[i] = true;
        }
        boolean matchAllAliases = patterns.length == 0;
        for (String index : possibleMatches) {
            ArrayList<AliasInfo> filteredValues = new ArrayList<AliasInfo>();
            List<T> entities = getter.apply(index);
            for (AliasInfo aliasInfo : entities) {
                boolean matched = matchAllAliases;
                String alias = aliasInfo.getAlias();
                for (int i = 0; i < patterns.length; ++i) {
                    if (include[i]) {
                        if (matched) continue;
                        String pattern = patterns[i];
                        matched = "_all".equals(pattern) || Regex.simpleMatch(pattern, alias);
                        continue;
                    }
                    if (!matched) continue;
                    matched = !Regex.simpleMatch(patterns[i], alias);
                }
                if (!matched) continue;
                filteredValues.add(aliasInfo);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, Comparator.comparing(AliasInfo::getAlias));
            setter.accept(index, Collections.unmodifiableList(filteredValues));
        }
    }

    public Map<String, ComponentTemplate> componentTemplates() {
        return Optional.ofNullable((ComponentTemplateMetadata)this.custom("component_template")).map(ComponentTemplateMetadata::componentTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, ComposableIndexTemplate> templatesV2() {
        return Optional.ofNullable((ComposableIndexTemplateMetadata)this.custom("index_template")).map(ComposableIndexTemplateMetadata::indexTemplates).orElse(Collections.emptyMap());
    }

    public IndexMode retrieveIndexModeFromTemplate(ComposableIndexTemplate indexTemplate) {
        if (indexTemplate.getDataStreamTemplate() == null) {
            return null;
        }
        Settings settings = MetadataIndexTemplateService.resolveSettings(indexTemplate, this.componentTemplates());
        String rawIndexMode = settings.get(IndexSettings.MODE.getKey());
        return rawIndexMode != null ? Enum.valueOf(IndexMode.class, rawIndexMode.toUpperCase(Locale.ROOT)) : null;
    }

    public boolean isIndexManagedByILM(IndexMetadata indexMetadata) {
        if (!Strings.hasText(indexMetadata.getLifecyclePolicyName())) {
            return false;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.getIndicesLookup().get(indexMetadata.getIndex().getName());
        if (indexAbstraction == null) {
            return false;
        }
        DataStream parentDataStream = indexAbstraction.getParentDataStream();
        if (parentDataStream == null) {
            return true;
        }
        DataStreamLifecycle lifecycle = parentDataStream.getDataLifecycleForIndex(indexMetadata.getIndex());
        if (lifecycle != null && lifecycle.enabled()) {
            return IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings());
        }
        return true;
    }

    static boolean isStateEquals(ProjectMetadata project1, ProjectMetadata project2) {
        if (!project1.templates().equals(project2.templates())) {
            return false;
        }
        return Metadata.customsEqual(project1.customs(), project2.customs());
    }

    public Optional<SecureString> getSecret(String key) {
        return Optional.ofNullable((ProjectSecrets)this.custom("project_state_secrets")).map(secrets -> secrets.getSettings().getString(key));
    }

    public static Builder builder(ProjectId id) {
        return new Builder().id(id);
    }

    public static Builder builder(ProjectMetadata projectMetadata) {
        return new Builder(projectMetadata);
    }

    public ProjectMetadata copyAndUpdate(Consumer<Builder> updater) {
        Builder builder = ProjectMetadata.builder(this);
        updater.accept(builder);
        return builder.build();
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params p) {
        Metadata.XContentContext context = Metadata.XContentContext.from(p);
        Iterator indices = context == Metadata.XContentContext.API ? ChunkedToXContentHelper.object("indices", this.indices().values().iterator()) : Collections.emptyIterator();
        boolean multiProject = p.paramAsBoolean("multi-project", false);
        Iterator customs = Iterators.flatMap(this.customs().entrySet().iterator(), entry -> {
            if (((Metadata.ProjectCustom)entry.getValue()).context().contains((Object)context) && (multiProject || !"persistent_tasks".equals(entry.getKey()))) {
                return ChunkedToXContentHelper.object((String)entry.getKey(), ((Metadata.ProjectCustom)entry.getValue()).toXContentChunked(p));
            }
            return Collections.emptyIterator();
        });
        return Iterators.concat(ChunkedToXContentHelper.object("templates", Iterators.map(this.templates().values().iterator(), template -> (builder, params) -> IndexTemplateMetadata.Builder.toXContentWithTypes(template, builder, params))), indices, customs, multiProject ? ChunkedToXContentHelper.object("reserved_state", this.reservedStateMetadata().values().iterator()) : Collections.emptyIterator());
    }

    public static ProjectMetadata readFrom(StreamInput in) throws IOException {
        int i;
        ProjectId id = ProjectId.readFrom(in);
        Builder builder = ProjectMetadata.builder(id);
        Map<String, MappingMetadata> mappingMetadataMap = in.readMapValues(MappingMetadata::new, MappingMetadata::getSha256);
        Function<String, MappingMetadata> mappingLookup = !mappingMetadataMap.isEmpty() ? mappingMetadataMap::get : null;
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetadata.readFrom(in, mappingLookup), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetadata.readFrom(in));
        }
        ProjectMetadata.readProjectCustoms(in, builder);
        int reservedStateSize = in.readVInt();
        for (int i2 = 0; i2 < reservedStateSize; ++i2) {
            builder.put(ReservedStateMetadata.readFrom(in));
        }
        if (in.getTransportVersion().supports(TransportVersions.PROJECT_METADATA_SETTINGS) && !in.getTransportVersion().supports(CLUSTER_STATE_PROJECTS_SETTINGS)) {
            Settings.readSettingsFromStream(in);
        }
        return builder.build();
    }

    private static void readProjectCustoms(StreamInput in, Builder builder) throws IOException {
        Set<String> clusterScopedNames = in.namedWriteableRegistry().getReaders(Metadata.ProjectCustom.class).keySet();
        int count = in.readVInt();
        for (int i = 0; i < count; ++i) {
            String name = in.readString();
            if (!clusterScopedNames.contains(name)) {
                throw new IllegalArgumentException("Unknown project custom name [" + name + "]");
            }
            Metadata.ProjectCustom custom = in.readNamedWriteable(Metadata.ProjectCustom.class, name);
            builder.putCustom(custom.getWriteableName(), custom);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.id.writeTo(out);
        out.writeMapValues(this.mappingsByHash);
        out.writeVInt(this.indices.size());
        for (IndexMetadata indexMetadata : this) {
            indexMetadata.writeTo(out, true);
        }
        out.writeCollection(this.templates.values());
        VersionedNamedWriteable.writeVersionedWriteables(out, this.customs.values());
        out.writeCollection(this.reservedStateMetadata.values());
        if (out.getTransportVersion().supports(TransportVersions.PROJECT_METADATA_SETTINGS) && !out.getTransportVersion().supports(CLUSTER_STATE_PROJECTS_SETTINGS)) {
            Settings.EMPTY.writeTo(out);
        }
    }

    public ProjectMetadataDiff diff(ProjectMetadata previousState) {
        return new ProjectMetadataDiff(previousState, this);
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<String, IndexMetadata> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetadata> templates;
        private final ImmutableOpenMap.Builder<String, Metadata.ProjectCustom> customs;
        private final ImmutableOpenMap.Builder<String, ReservedStateMetadata> reservedStateMetadata;
        private SortedMap<String, IndexAbstraction> previousIndicesLookup;
        private final Map<String, MappingMetadata> mappingsByHash;
        private boolean checkForUnusedMappings = true;
        private ProjectId id;

        Builder(ProjectMetadata projectMetadata) {
            this.id = projectMetadata.id;
            this.indices = ImmutableOpenMap.builder(projectMetadata.indices);
            this.templates = ImmutableOpenMap.builder(projectMetadata.templates);
            this.customs = ImmutableOpenMap.builder(projectMetadata.customs);
            this.reservedStateMetadata = ImmutableOpenMap.builder(projectMetadata.reservedStateMetadata);
            this.previousIndicesLookup = projectMetadata.indicesLookup;
            this.mappingsByHash = new HashMap<String, MappingMetadata>(projectMetadata.mappingsByHash);
            this.checkForUnusedMappings = false;
        }

        Builder() {
            this(Map.of(), 0);
        }

        Builder(Map<String, MappingMetadata> mappingsByHash, int indexCountHint) {
            this.indices = ImmutableOpenMap.builder(indexCountHint);
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.reservedStateMetadata = ImmutableOpenMap.builder();
            this.previousIndicesLookup = null;
            this.mappingsByHash = new HashMap<String, MappingMetadata>(mappingsByHash);
            this.indexGraveyard(IndexGraveyard.builder().build());
        }

        public Builder id(ProjectId id) {
            assert (this.id == null) : "a project's ID cannot be changed";
            this.id = id;
            return this;
        }

        public ProjectId getId() {
            return this.id;
        }

        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
            this.dedupeMapping(indexMetadataBuilder);
            IndexMetadata indexMetadata = indexMetadataBuilder.build();
            IndexMetadata previous = this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            if (Builder.unsetPreviousIndicesLookup(previous, indexMetadata)) {
                this.previousIndicesLookup = null;
            }
            this.maybeSetMappingPurgeFlag(previous, indexMetadata);
            return this;
        }

        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            IndexMetadata previous;
            String name = indexMetadata.getIndex().getName();
            indexMetadata = this.dedupeMapping(indexMetadata);
            if (incrementVersion) {
                if (this.indices.get(name) == indexMetadata) {
                    return this;
                }
                indexMetadata = indexMetadata.withIncrementedVersion();
                previous = this.indices.put(name, indexMetadata);
            } else {
                previous = this.indices.put(name, indexMetadata);
                if (previous == indexMetadata) {
                    return this;
                }
            }
            if (Builder.unsetPreviousIndicesLookup(previous, indexMetadata)) {
                this.previousIndicesLookup = null;
            }
            this.maybeSetMappingPurgeFlag(previous, indexMetadata);
            return this;
        }

        public Builder indices(Map<String, IndexMetadata> indices) {
            for (IndexMetadata value : indices.values()) {
                this.put(value, false);
            }
            return this;
        }

        private IndexMetadata dedupeMapping(IndexMetadata indexMetadata) {
            if (indexMetadata.mapping() == null) {
                return indexMetadata;
            }
            String digest = indexMetadata.mapping().getSha256();
            MappingMetadata entry = this.mappingsByHash.get(digest);
            if (entry != null) {
                return indexMetadata.withMappingMetadata(entry);
            }
            this.mappingsByHash.put(digest, indexMetadata.mapping());
            return indexMetadata;
        }

        private void dedupeMapping(IndexMetadata.Builder indexMetadataBuilder) {
            if (indexMetadataBuilder.mapping() == null) {
                return;
            }
            String digest = indexMetadataBuilder.mapping().getSha256();
            MappingMetadata entry = this.mappingsByHash.get(digest);
            if (entry != null) {
                indexMetadataBuilder.putMapping(entry);
            } else {
                this.mappingsByHash.put(digest, indexMetadataBuilder.mapping());
            }
        }

        private void maybeSetMappingPurgeFlag(@Nullable IndexMetadata previous, IndexMetadata updated) {
            if (this.checkForUnusedMappings) {
                return;
            }
            if (previous == null) {
                return;
            }
            MappingMetadata mapping = previous.mapping();
            if (mapping == null) {
                return;
            }
            MappingMetadata updatedMapping = updated.mapping();
            if (updatedMapping == null) {
                return;
            }
            if (!mapping.getSha256().equals(updatedMapping.getSha256())) {
                this.checkForUnusedMappings = true;
            }
        }

        private static boolean unsetPreviousIndicesLookup(IndexMetadata previous, IndexMetadata current) {
            if (previous == null) {
                return true;
            }
            if (!previous.getAliases().equals(current.getAliases())) {
                return true;
            }
            if (previous.isHidden() != current.isHidden()) {
                return true;
            }
            if (previous.isSystem() != current.isSystem()) {
                return true;
            }
            return previous.getState() != current.getState();
        }

        public IndexMetadata get(String index) {
            return this.indices.get(index);
        }

        public IndexMetadata getSafe(Index index) {
            IndexMetadata indexMetadata = this.get(index.getName());
            if (indexMetadata != null) {
                if (indexMetadata.getIndexUUID().equals(index.getUUID())) {
                    return indexMetadata;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetadata.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.previousIndicesLookup = null;
            this.checkForUnusedMappings = true;
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.previousIndicesLookup = null;
            this.checkForUnusedMappings = true;
            this.indices.clear();
            this.mappingsByHash.clear();
            return this;
        }

        public Builder put(IndexTemplateMetadata.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(Map<String, IndexTemplateMetadata> templates) {
            this.templates.putAllFromMap(templates);
            return this;
        }

        public Builder put(String name, ComponentTemplate componentTemplate) {
            Objects.requireNonNull(componentTemplate, "it is invalid to add a null component template: " + name);
            ComponentTemplateMetadata ctm = (ComponentTemplateMetadata)this.customs.get("component_template");
            HashMap<String, ComponentTemplate> existingTemplates = ctm != null ? new HashMap<String, ComponentTemplate>(ctm.componentTemplates()) : new HashMap();
            existingTemplates.put(name, componentTemplate);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeComponentTemplate(String name) {
            HashMap<String, ComponentTemplate> existingTemplates;
            ComponentTemplateMetadata ctm = (ComponentTemplateMetadata)this.customs.get("component_template");
            if (ctm != null && (existingTemplates = new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).remove(name) != null) {
                this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            }
            return this;
        }

        public Builder componentTemplates(Map<String, ComponentTemplate> componentTemplates) {
            this.customs.put("component_template", new ComponentTemplateMetadata(componentTemplates));
            return this;
        }

        public Builder indexTemplates(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(indexTemplates));
            return this;
        }

        public Builder put(String name, ComposableIndexTemplate indexTemplate) {
            Objects.requireNonNull(indexTemplate, "it is invalid to add a null index template: " + name);
            ComposableIndexTemplateMetadata itmd = (ComposableIndexTemplateMetadata)this.customs.get("index_template");
            HashMap<String, ComposableIndexTemplate> existingTemplates = itmd != null ? new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates()) : new HashMap();
            existingTemplates.put(name, indexTemplate);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeIndexTemplate(String name) {
            HashMap<String, ComposableIndexTemplate> existingTemplates;
            ComposableIndexTemplateMetadata itmd = (ComposableIndexTemplateMetadata)this.customs.get("index_template");
            if (itmd != null && (existingTemplates = new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).remove(name) != null) {
                this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            }
            return this;
        }

        public DataStream dataStream(String dataStreamName) {
            return this.dataStreamMetadata().dataStreams().get(dataStreamName);
        }

        public Builder dataStreams(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
            this.previousIndicesLookup = null;
            for (DataStream dataStream : dataStreams.values()) {
                dataStream.validate(this.indices::get);
            }
            this.customs.put("data_stream", new DataStreamMetadata(ImmutableOpenMap.builder().putAllFromMap(dataStreams).build(), ImmutableOpenMap.builder().putAllFromMap(dataStreamAliases).build()));
            return this;
        }

        public Builder put(DataStream dataStream) {
            Objects.requireNonNull(dataStream, "it is invalid to add a null data stream");
            this.previousIndicesLookup = null;
            dataStream.validate(this.indices::get);
            this.customs.put("data_stream", this.dataStreamMetadata().withAddedDatastream(dataStream));
            return this;
        }

        public DataStreamMetadata dataStreamMetadata() {
            return (DataStreamMetadata)this.customs.getOrDefault("data_stream", DataStreamMetadata.EMPTY);
        }

        public boolean put(String aliasName, String dataStream, Boolean isWriteDataStream, String filter) {
            DataStreamMetadata updated;
            this.previousIndicesLookup = null;
            DataStreamMetadata existing = this.dataStreamMetadata();
            if (existing == (updated = existing.withAlias(aliasName, dataStream, isWriteDataStream, filter))) {
                return false;
            }
            this.customs.put("data_stream", updated);
            return true;
        }

        public Builder removeDataStream(String name) {
            this.previousIndicesLookup = null;
            this.customs.put("data_stream", this.dataStreamMetadata().withRemovedDataStream(name));
            return this;
        }

        public boolean removeDataStreamAlias(String aliasName, String dataStreamName, boolean mustExist) {
            DataStreamMetadata updated;
            this.previousIndicesLookup = null;
            DataStreamMetadata existing = this.dataStreamMetadata();
            if (existing == (updated = existing.withRemovedAlias(aliasName, dataStreamName, mustExist))) {
                return false;
            }
            this.customs.put("data_stream", updated);
            return true;
        }

        public <T extends Metadata.ProjectCustom> T getCustom(String type) {
            return (T)this.customs.get(type);
        }

        public Builder putCustom(String type, Metadata.ProjectCustom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder removeCustomIf(BiPredicate<String, ? super Metadata.ProjectCustom> p) {
            this.customs.removeAll(p);
            return this;
        }

        public Builder customs(Map<String, Metadata.ProjectCustom> customs) {
            customs.forEach((key, value) -> Objects.requireNonNull(value, key));
            this.customs.putAllFromMap(customs);
            return this;
        }

        public Builder put(Map<String, ReservedStateMetadata> reservedStateMetadata) {
            this.reservedStateMetadata.putAllFromMap(reservedStateMetadata);
            return this;
        }

        public Builder put(ReservedStateMetadata metadata) {
            this.reservedStateMetadata.put(metadata.namespace(), metadata);
            return this;
        }

        public Builder removeReservedState(ReservedStateMetadata metadata) {
            this.reservedStateMetadata.remove(metadata.namespace());
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            return this.putCustom("index-graveyard", indexGraveyard);
        }

        public IndexGraveyard indexGraveyard() {
            return (IndexGraveyard)this.getCustom("index-graveyard");
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = (String[])this.indices.keys().toArray(String[]::new);
            }
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                long newVersion = indexMetadata.getSettingsVersion() + 1L;
                this.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put(settings)).settingsVersion(newVersion));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public ProjectMetadata build() {
            return this.build(false);
        }

        public ProjectMetadata build(boolean skipNameCollisionChecks) {
            ArrayList<String> visibleIndices = new ArrayList<String>();
            ArrayList<String> allOpenIndices = new ArrayList<String>();
            ArrayList<String> visibleOpenIndices = new ArrayList<String>();
            ArrayList<String> allClosedIndices = new ArrayList<String>();
            ArrayList<String> visibleClosedIndices = new ArrayList<String>();
            ImmutableOpenMap<String, IndexMetadata> indicesMap = this.indices.build();
            int oldestIndexVersionId = IndexVersion.current().id();
            int totalNumberOfShards = 0;
            int totalOpenIndexShards = 0;
            ImmutableOpenMap.Builder<Object, Set<Object>> aliasedIndicesBuilder = ImmutableOpenMap.builder();
            String[] allIndicesArray = new String[indicesMap.size()];
            int i = 0;
            HashSet<String> sha256HashesInUse = this.checkForUnusedMappings ? Sets.newHashSetWithExpectedSize(this.mappingsByHash.size()) : null;
            for (Map.Entry<String, IndexMetadata> entry : indicesMap.entrySet()) {
                Object mapping;
                boolean visible;
                allIndicesArray[i++] = entry.getKey();
                IndexMetadata indexMetadata = entry.getValue();
                totalNumberOfShards += indexMetadata.getTotalNumberOfShards();
                String name = indexMetadata.getIndex().getName();
                boolean bl = visible = !indexMetadata.isHidden();
                if (visible) {
                    visibleIndices.add(name);
                }
                if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                    totalOpenIndexShards += indexMetadata.getTotalNumberOfShards();
                    allOpenIndices.add(name);
                    if (visible) {
                        visibleOpenIndices.add(name);
                    }
                } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    allClosedIndices.add(name);
                    if (visible) {
                        visibleClosedIndices.add(name);
                    }
                }
                oldestIndexVersionId = Math.min(oldestIndexVersionId, indexMetadata.getCompatibilityVersion().id());
                if (sha256HashesInUse != null && (mapping = indexMetadata.mapping()) != null) {
                    sha256HashesInUse.add(((MappingMetadata)mapping).getSha256());
                }
                mapping = indexMetadata.getAliases().keySet().iterator();
                while (mapping.hasNext()) {
                    String alias = (String)mapping.next();
                    HashSet<Index> indices = (HashSet<Index>)aliasedIndicesBuilder.get(alias);
                    if (indices == null) {
                        indices = new HashSet<Index>();
                        aliasedIndicesBuilder.put(alias, indices);
                    }
                    indices.add(indexMetadata.getIndex());
                }
            }
            for (Object alias : aliasedIndicesBuilder.keys()) {
                aliasedIndicesBuilder.put(alias, Collections.unmodifiableSet((Set)aliasedIndicesBuilder.get(alias)));
            }
            ImmutableOpenMap<String, Set<Index>> aliasedIndices = aliasedIndicesBuilder.build();
            for (Map.Entry entry : aliasedIndices.entrySet()) {
                List<IndexMetadata> aliasIndices = ((Set)entry.getValue()).stream().map(idx -> (IndexMetadata)indicesMap.get(idx.getName())).toList();
                Builder.validateAlias((String)entry.getKey(), aliasIndices);
            }
            SortedMap<String, IndexAbstraction> indicesLookup = null;
            if (this.previousIndicesLookup != null) {
                assert (this.previousIndicesLookup.equals(Builder.buildIndicesLookup(this.dataStreamMetadata(), indicesMap)));
                indicesLookup = this.previousIndicesLookup;
            } else if (!skipNameCollisionChecks) {
                Builder.ensureNoNameCollisions(aliasedIndices.keySet(), indicesMap, this.dataStreamMetadata());
            }
            assert (Builder.assertDataStreams(indicesMap, this.dataStreamMetadata()));
            if (sha256HashesInUse != null) {
                this.mappingsByHash.keySet().retainAll(sha256HashesInUse);
            }
            String[] stringArray = (String[])visibleIndices.toArray(String[]::new);
            String[] allOpenIndicesArray = (String[])allOpenIndices.toArray(String[]::new);
            String[] visibleOpenIndicesArray = (String[])visibleOpenIndices.toArray(String[]::new);
            String[] allClosedIndicesArray = (String[])allClosedIndices.toArray(String[]::new);
            String[] visibleClosedIndicesArray = (String[])visibleClosedIndices.toArray(String[]::new);
            return new ProjectMetadata(this.id, indicesMap, aliasedIndices, this.templates.build(), this.customs.build(), this.reservedStateMetadata.build(), totalNumberOfShards, totalOpenIndexShards, allIndicesArray, stringArray, allOpenIndicesArray, visibleOpenIndicesArray, allClosedIndicesArray, visibleClosedIndicesArray, indicesLookup, Collections.unmodifiableMap(this.mappingsByHash), IndexVersion.fromId(oldestIndexVersionId));
        }

        static void ensureNoNameCollisions(Set<String> indexAliases, ImmutableOpenMap<String, IndexMetadata> indicesMap, DataStreamMetadata dataStreamMetadata) {
            ArrayList<String> duplicates = new ArrayList<String>();
            HashSet<String> aliasDuplicatesWithIndices = new HashSet<String>();
            HashSet<String> aliasDuplicatesWithDataStreams = new HashSet<String>();
            Map<String, DataStream> allDataStreams = dataStreamMetadata.dataStreams();
            for (String dataStreamAlias : dataStreamMetadata.getDataStreamAliases().keySet()) {
                if (indexAliases.contains(dataStreamAlias)) {
                    duplicates.add("data stream alias and indices alias have the same name (" + dataStreamAlias + ")");
                }
                if (indicesMap.containsKey(dataStreamAlias)) {
                    aliasDuplicatesWithIndices.add(dataStreamAlias);
                }
                if (!allDataStreams.containsKey(dataStreamAlias)) continue;
                aliasDuplicatesWithDataStreams.add(dataStreamAlias);
            }
            for (String alias : indexAliases) {
                if (allDataStreams.containsKey(alias)) {
                    aliasDuplicatesWithDataStreams.add(alias);
                }
                if (!indicesMap.containsKey(alias)) continue;
                aliasDuplicatesWithIndices.add(alias);
            }
            allDataStreams.forEach((key, value) -> {
                if (indicesMap.containsKey(key)) {
                    duplicates.add("data stream [" + key + "] conflicts with index");
                }
            });
            if (!aliasDuplicatesWithIndices.isEmpty()) {
                Builder.collectAliasDuplicates(indicesMap, aliasDuplicatesWithIndices, duplicates);
            }
            if (!aliasDuplicatesWithDataStreams.isEmpty()) {
                Builder.collectAliasDuplicates(indicesMap, dataStreamMetadata, aliasDuplicatesWithDataStreams, duplicates);
            }
            if (!duplicates.isEmpty()) {
                throw new IllegalStateException("index, alias, and data stream names need to be unique, but the following duplicates were found [" + Strings.collectionToCommaDelimitedString(duplicates) + "]");
            }
        }

        private static void collectAliasDuplicates(ImmutableOpenMap<String, IndexMetadata> indicesMap, DataStreamMetadata dataStreamMetadata, Set<String> aliasDuplicatesWithDataStreams, List<String> duplicates) {
            for (String alias : aliasDuplicatesWithDataStreams) {
                boolean reported = false;
                for (IndexMetadata cursor : indicesMap.values()) {
                    if (!cursor.getAliases().containsKey(alias)) continue;
                    duplicates.add(alias + " (alias of " + String.valueOf(cursor.getIndex()) + ") conflicts with data stream");
                    reported = true;
                }
                if (reported || dataStreamMetadata == null || !dataStreamMetadata.dataStreams().containsKey(alias)) continue;
                duplicates.add("data stream alias and data stream have the same name (" + alias + ")");
            }
        }

        private static void collectAliasDuplicates(ImmutableOpenMap<String, IndexMetadata> indicesMap, Set<String> aliasDuplicatesWithIndices, List<String> duplicates) {
            for (IndexMetadata cursor : indicesMap.values()) {
                for (String alias : aliasDuplicatesWithIndices) {
                    if (!cursor.getAliases().containsKey(alias)) continue;
                    duplicates.add(alias + " (alias of " + String.valueOf(cursor.getIndex()) + ") conflicts with index");
                }
            }
        }

        static SortedMap<String, IndexAbstraction> buildIndicesLookup(DataStreamMetadata dataStreamMetadata, ImmutableOpenMap<String, IndexMetadata> indices) {
            if (indices.isEmpty()) {
                return Collections.emptySortedMap();
            }
            final HashMap<String, IndexAbstraction> indicesLookup = new HashMap<String, IndexAbstraction>();
            HashMap<String, DataStream> indexToDataStreamLookup = new HashMap<String, DataStream>();
            Builder.collectDataStreams(dataStreamMetadata, indicesLookup, indexToDataStreamLookup);
            HashMap<String, List<IndexMetadata>> aliasToIndices = new HashMap<String, List<IndexMetadata>>();
            Builder.collectIndices(indices, indexToDataStreamLookup, indicesLookup, aliasToIndices);
            Builder.collectAliases(aliasToIndices, indicesLookup);
            return new SortedMap<String, IndexAbstraction>(){
                private final SortedMap<String, IndexAbstraction> sortedMap;
                {
                    this.sortedMap = Collections.unmodifiableSortedMap(new TreeMap(indicesLookup));
                }

                @Override
                public Comparator<? super String> comparator() {
                    return this.sortedMap.comparator();
                }

                @Override
                public SortedMap<String, IndexAbstraction> subMap(String fromKey, String toKey) {
                    return this.sortedMap.subMap(fromKey, toKey);
                }

                @Override
                public SortedMap<String, IndexAbstraction> headMap(String toKey) {
                    return this.sortedMap.headMap(toKey);
                }

                @Override
                public SortedMap<String, IndexAbstraction> tailMap(String fromKey) {
                    return this.sortedMap.tailMap(fromKey);
                }

                @Override
                public String firstKey() {
                    return this.sortedMap.firstKey();
                }

                @Override
                public String lastKey() {
                    return this.sortedMap.lastKey();
                }

                @Override
                public Set<String> keySet() {
                    return this.sortedMap.keySet();
                }

                @Override
                public Collection<IndexAbstraction> values() {
                    return this.sortedMap.values();
                }

                @Override
                public Set<Map.Entry<String, IndexAbstraction>> entrySet() {
                    return this.sortedMap.entrySet();
                }

                @Override
                public int size() {
                    return indicesLookup.size();
                }

                @Override
                public boolean isEmpty() {
                    return indicesLookup.isEmpty();
                }

                @Override
                public boolean containsKey(Object key) {
                    return indicesLookup.containsKey(key);
                }

                @Override
                public boolean containsValue(Object value) {
                    return indicesLookup.containsValue(value);
                }

                @Override
                public IndexAbstraction get(Object key) {
                    return (IndexAbstraction)indicesLookup.get(key);
                }

                @Override
                public IndexAbstraction put(String key, IndexAbstraction value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public IndexAbstraction remove(Object key) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void putAll(Map<? extends String, ? extends IndexAbstraction> m) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    return indicesLookup.equals(obj);
                }

                @Override
                public int hashCode() {
                    return indicesLookup.hashCode();
                }
            };
        }

        private static void collectAliases(Map<String, List<IndexMetadata>> aliasToIndices, Map<String, IndexAbstraction> indicesLookup) {
            for (Map.Entry<String, List<IndexMetadata>> entry : aliasToIndices.entrySet()) {
                AliasMetadata alias = entry.getValue().get(0).getAliases().get(entry.getKey());
                IndexAbstraction existing = indicesLookup.put(entry.getKey(), new IndexAbstraction.Alias(alias, entry.getValue()));
                assert (existing == null) : "duplicate for " + entry.getKey();
            }
        }

        private static void collectIndices(Map<String, IndexMetadata> indices, Map<String, DataStream> indexToDataStreamLookup, Map<String, IndexAbstraction> indicesLookup, Map<String, List<IndexMetadata>> aliasToIndices) {
            for (Map.Entry<String, IndexMetadata> entry : indices.entrySet()) {
                String name = entry.getKey();
                IndexMetadata indexMetadata = entry.getValue();
                DataStream parent = indexToDataStreamLookup.get(name);
                assert (Builder.assertContainsIndexIfDataStream(parent, indexMetadata));
                IndexAbstraction existing = indicesLookup.put(name, new IndexAbstraction.ConcreteIndex(indexMetadata, parent));
                assert (existing == null) : "duplicate for " + String.valueOf(indexMetadata.getIndex());
                for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                    List aliasIndices = aliasToIndices.computeIfAbsent(aliasMetadata.getAlias(), k -> new ArrayList());
                    aliasIndices.add(indexMetadata);
                }
            }
        }

        private static boolean assertContainsIndexIfDataStream(DataStream parent, IndexMetadata indexMetadata) {
            assert (parent == null || parent.getIndices().stream().anyMatch(index -> indexMetadata.getIndex().getName().equals(index.getName())) || parent.getFailureComponent().getIndices().stream().anyMatch(index -> indexMetadata.getIndex().getName().equals(index.getName()))) : "Expected data stream [" + parent.getName() + "] to contain index " + String.valueOf(indexMetadata.getIndex());
            return true;
        }

        private static void collectDataStreams(DataStreamMetadata dataStreamMetadata, Map<String, IndexAbstraction> indicesLookup, Map<String, DataStream> indexToDataStreamLookup) {
            IndexAbstraction existing;
            Map<String, DataStream> dataStreams = dataStreamMetadata.dataStreams();
            for (DataStreamAlias alias : dataStreamMetadata.getDataStreamAliases().values()) {
                existing = indicesLookup.put(alias.getName(), Builder.makeDsAliasAbstraction(dataStreams, alias));
                assert (existing == null) : "duplicate data stream alias for " + alias.getName();
            }
            for (DataStream dataStream : dataStreams.values()) {
                existing = indicesLookup.put(dataStream.getName(), dataStream);
                assert (existing == null) : "duplicate data stream for " + dataStream.getName();
                for (Index i : dataStream.getIndices()) {
                    indexToDataStreamLookup.put(i.getName(), dataStream);
                }
                for (Index i : dataStream.getFailureIndices()) {
                    indexToDataStreamLookup.put(i.getName(), dataStream);
                }
            }
        }

        private static IndexAbstraction.Alias makeDsAliasAbstraction(Map<String, DataStream> dataStreams, DataStreamAlias alias) {
            Index writeIndexOfWriteDataStream = null;
            if (alias.getWriteDataStream() != null) {
                DataStream writeDataStream = dataStreams.get(alias.getWriteDataStream());
                writeIndexOfWriteDataStream = writeDataStream.getWriteIndex();
            }
            return new IndexAbstraction.Alias(alias, alias.getDataStreams().stream().flatMap(name -> ((DataStream)dataStreams.get(name)).getIndices().stream()).toList(), writeIndexOfWriteDataStream, alias.getDataStreams());
        }

        private static boolean isNonEmpty(List<IndexMetadata> idxMetas) {
            return !(Objects.isNull(idxMetas) || idxMetas.isEmpty());
        }

        static void validateAlias(String aliasName, List<IndexMetadata> indexMetadatas) {
            List<String> newVersionSystemIndices;
            List<String> writeIndices = indexMetadatas.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(aliasName).writeIndex())).map(im -> im.getIndex().getName()).toList();
            if (writeIndices.size() > 1) {
                throw new IllegalStateException("alias [" + aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndices) + "]");
            }
            Map<Boolean, List<IndexMetadata>> groupedByHiddenStatus = indexMetadatas.stream().collect(Collectors.groupingBy(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(aliasName).isHidden())));
            if (Builder.isNonEmpty(groupedByHiddenStatus.get(true)) && Builder.isNonEmpty(groupedByHiddenStatus.get(false))) {
                List<String> hiddenOn = groupedByHiddenStatus.get(true).stream().map(idx -> idx.getIndex().getName()).toList();
                List<String> nonHiddenOn = groupedByHiddenStatus.get(false).stream().map(idx -> idx.getIndex().getName()).toList();
                throw new IllegalStateException("alias [" + aliasName + "] has is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(hiddenOn) + "] but does not have is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(nonHiddenOn) + "]; alias must have the same is_hidden setting on all indices");
            }
            Map<Boolean, List<IndexMetadata>> groupedBySystemStatus = indexMetadatas.stream().collect(Collectors.groupingBy(IndexMetadata::isSystem));
            if (Builder.isNonEmpty(groupedBySystemStatus.get(false)) && Builder.isNonEmpty(groupedBySystemStatus.get(true)) && !(newVersionSystemIndices = groupedBySystemStatus.get(true).stream().filter(i -> i.getCreationVersion().onOrAfter(IndexNameExpressionResolver.SYSTEM_INDEX_ENFORCEMENT_INDEX_VERSION)).map(i -> i.getIndex().getName()).sorted().toList()).isEmpty()) {
                List<String> nonSystemIndices = groupedBySystemStatus.get(false).stream().map(i -> i.getIndex().getName()).sorted().toList();
                throw new IllegalStateException("alias [" + aliasName + "] refers to both system indices " + String.valueOf(newVersionSystemIndices) + " and non-system indices: " + String.valueOf(nonSystemIndices) + ", but aliases must refer to either system or non-system indices, not both");
            }
        }

        static boolean assertDataStreams(Map<String, IndexMetadata> indices, DataStreamMetadata dsMetadata) {
            List<String> conflictingAliases = dsMetadata.dataStreams().values().stream().flatMap(ds -> ds.getIndices().stream()).map(index -> (IndexMetadata)indices.get(index.getName())).filter(Objects::nonNull).flatMap(im -> im.getAliases().values().stream()).map(AliasMetadata::alias).toList();
            if (!conflictingAliases.isEmpty()) {
                throw new AssertionError((Object)("aliases " + String.valueOf(conflictingAliases) + " cannot refer to backing indices of data streams"));
            }
            return true;
        }

        public static ProjectMetadata fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = null;
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            Builder projectBuilder = new Builder();
            block18: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    switch (currentFieldName) {
                        case "id": {
                            projectBuilder.id(ProjectId.fromXContent(parser));
                            continue block18;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (currentFieldName) {
                        case "reserved_state": {
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                projectBuilder.put(ReservedStateMetadata.fromXContent(parser));
                            }
                            continue block18;
                        }
                        case "indices": {
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                projectBuilder.put(IndexMetadata.Builder.fromXContent(parser), false);
                            }
                            continue block18;
                        }
                        case "templates": {
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                projectBuilder.put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                            }
                            continue block18;
                        }
                        case "settings": {
                            Settings.fromXContent(parser);
                            continue block18;
                        }
                    }
                    Metadata.Builder.parseCustomObject(parser, currentFieldName, Metadata.ProjectCustom.class, projectBuilder::putCustom);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected token " + String.valueOf(token));
            }
            return projectBuilder.build();
        }
    }

    static class ProjectMetadataDiff
    implements Diff<ProjectMetadata> {
        private static final DiffableUtils.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, ReservedStateMetadata> RESERVED_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(ReservedStateMetadata::readFrom, ReservedStateMetadata::readDiffFrom);
        private final DiffableUtils.MapDiff<String, IndexMetadata, ImmutableOpenMap<String, IndexMetadata>> indices;
        private final DiffableUtils.MapDiff<String, IndexTemplateMetadata, ImmutableOpenMap<String, IndexTemplateMetadata>> templates;
        private final DiffableUtils.MapDiff<String, Metadata.ProjectCustom, ImmutableOpenMap<String, Metadata.ProjectCustom>> customs;
        private final DiffableUtils.MapDiff<String, ReservedStateMetadata, ImmutableOpenMap<String, ReservedStateMetadata>> reservedStateMetadata;

        private ProjectMetadataDiff(ProjectMetadata before, ProjectMetadata after) {
            if (before == after) {
                this.indices = DiffableUtils.emptyDiff();
                this.templates = DiffableUtils.emptyDiff();
                this.customs = DiffableUtils.emptyDiff();
                this.reservedStateMetadata = DiffableUtils.emptyDiff();
            } else {
                this.indices = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer());
                this.templates = DiffableUtils.diff(before.templates, after.templates, DiffableUtils.getStringKeySerializer());
                this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), PROJECT_CUSTOM_VALUE_SERIALIZER);
                this.reservedStateMetadata = DiffableUtils.diff(before.reservedStateMetadata, after.reservedStateMetadata, DiffableUtils.getStringKeySerializer());
            }
        }

        ProjectMetadataDiff(DiffableUtils.MapDiff<String, IndexMetadata, ImmutableOpenMap<String, IndexMetadata>> indices, DiffableUtils.MapDiff<String, IndexTemplateMetadata, ImmutableOpenMap<String, IndexTemplateMetadata>> templates, DiffableUtils.MapDiff<String, Metadata.ProjectCustom, ImmutableOpenMap<String, Metadata.ProjectCustom>> customs, DiffableUtils.MapDiff<String, ReservedStateMetadata, ImmutableOpenMap<String, ReservedStateMetadata>> reservedStateMetadata) {
            this.indices = indices;
            this.templates = templates;
            this.customs = customs;
            this.reservedStateMetadata = reservedStateMetadata;
        }

        ProjectMetadataDiff(StreamInput in) throws IOException {
            this.indices = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
            this.templates = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), PROJECT_CUSTOM_VALUE_SERIALIZER);
            this.reservedStateMetadata = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), RESERVED_DIFF_VALUE_READER);
            if (in.getTransportVersion().supports(TransportVersions.PROJECT_METADATA_SETTINGS) && !in.getTransportVersion().supports(CLUSTER_STATE_PROJECTS_SETTINGS)) {
                Settings.readSettingsDiffFromStream(in);
            }
        }

        Diff<ImmutableOpenMap<String, IndexMetadata>> indices() {
            return this.indices;
        }

        Diff<ImmutableOpenMap<String, IndexTemplateMetadata>> templates() {
            return this.templates;
        }

        DiffableUtils.MapDiff<String, Metadata.ProjectCustom, ImmutableOpenMap<String, Metadata.ProjectCustom>> customs() {
            return this.customs;
        }

        DiffableUtils.MapDiff<String, ReservedStateMetadata, ImmutableOpenMap<String, ReservedStateMetadata>> reservedStateMetadata() {
            return this.reservedStateMetadata;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
            this.reservedStateMetadata.writeTo(out);
            if (out.getTransportVersion().supports(TransportVersions.PROJECT_METADATA_SETTINGS) && !out.getTransportVersion().supports(CLUSTER_STATE_PROJECTS_SETTINGS)) {
                Settings.EMPTY_DIFF.writeTo(out);
            }
        }

        @Override
        public ProjectMetadata apply(ProjectMetadata part) {
            if (this.indices.isEmpty() && this.templates.isEmpty() && this.customs.isEmpty() && this.reservedStateMetadata.isEmpty()) {
                return part;
            }
            ImmutableOpenMap<String, IndexMetadata> updatedIndices = this.indices.apply(part.indices);
            Builder builder = new Builder(part.mappingsByHash, updatedIndices.size());
            builder.id(part.id);
            builder.indices(updatedIndices);
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            builder.put(this.reservedStateMetadata.apply(part.reservedStateMetadata));
            if (part.indices == updatedIndices && builder.dataStreamMetadata() == part.custom("data_stream", DataStreamMetadata.EMPTY)) {
                builder.previousIndicesLookup = part.indicesLookup;
            }
            return builder.build(true);
        }
    }
}

