/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class OpenPointInTimeResponse
extends ActionResponse
implements ToXContentObject {
    private final BytesReference pointInTimeId;
    private final int totalShards;
    private final int successfulShards;
    private final int failedShards;
    private final int skippedShards;

    public OpenPointInTimeResponse(BytesReference pointInTimeId, int totalShards, int successfulShards, int failedShards, int skippedShards) {
        this.pointInTimeId = Objects.requireNonNull(pointInTimeId, "Point in time parameter must be not null");
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.skippedShards = skippedShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.pointInTimeId);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeVInt(this.totalShards);
            out.writeVInt(this.successfulShards);
            out.writeVInt(this.failedShards);
            out.writeVInt(this.skippedShards);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", Base64.getUrlEncoder().encodeToString(BytesReference.toBytes(this.pointInTimeId)));
        RestActions.buildBroadcastShardsHeader(builder, params, this.totalShards, this.successfulShards, this.skippedShards, this.failedShards, null);
        builder.endObject();
        return builder;
    }

    public BytesReference getPointInTimeId() {
        return this.pointInTimeId;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }
}

