/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;

public class RolloverRequestBuilder
extends MasterNodeOperationRequestBuilder<RolloverRequest, RolloverResponse, RolloverRequestBuilder> {
    public RolloverRequestBuilder(ElasticsearchClient client) {
        super(client, RolloverAction.INSTANCE, new RolloverRequest());
    }

    public RolloverRequestBuilder setRolloverTarget(String rolloverTarget) {
        ((RolloverRequest)this.request).setRolloverTarget(rolloverTarget);
        return this;
    }

    public RolloverRequestBuilder setNewIndexName(String newIndexName) {
        ((RolloverRequest)this.request).setNewIndexName(newIndexName);
        return this;
    }

    public RolloverRequestBuilder setConditions(RolloverConditions rolloverConditions) {
        ((RolloverRequest)this.request).setConditions(rolloverConditions);
        return this;
    }

    public RolloverRequestBuilder setConditions(RolloverConditions.Builder rolloverConditions) {
        ((RolloverRequest)this.request).setConditions(rolloverConditions.build());
        return this;
    }

    public RolloverRequestBuilder dryRun(boolean dryRun) {
        ((RolloverRequest)this.request).dryRun(dryRun);
        return this;
    }

    public RolloverRequestBuilder lazy(boolean lazy) {
        ((RolloverRequest)this.request).lazy(lazy);
        return this;
    }

    public RolloverRequestBuilder settings(Settings settings) {
        ((RolloverRequest)this.request).getCreateIndexRequest().settings(settings);
        return this;
    }

    public RolloverRequestBuilder alias(Alias alias) {
        ((RolloverRequest)this.request).getCreateIndexRequest().alias(alias);
        return this;
    }

    public RolloverRequestBuilder simpleMapping(String ... source) {
        ((RolloverRequest)this.request).getCreateIndexRequest().simpleMapping(source);
        return this;
    }

    public RolloverRequestBuilder mapping(String source) {
        ((RolloverRequest)this.request).getCreateIndexRequest().mapping(source);
        return this;
    }

    public RolloverRequestBuilder waitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((RolloverRequest)this.request).getCreateIndexRequest().waitForActiveShards(waitForActiveShards);
        return this;
    }

    public RolloverRequestBuilder waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }
}

