/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.support.QueryableBuiltInRoles;

public final class QueryableBuiltInRolesUtils {
    public static String calculateHash(RoleDescriptor roleDescriptor) {
        MessageDigest hash = MessageDigests.sha256();
        try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();){
            roleDescriptor.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
            Map flattenMap = Maps.flatten((Map)((Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)jsonBuilder), (boolean)true, (XContentType)XContentType.JSON).v2()), (boolean)false, (boolean)true);
            hash.update(flattenMap.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to compute digest for [" + roleDescriptor.getName() + "] role", e);
        }
        return Base64.getEncoder().encodeToString(hash.digest());
    }

    public static Set<String> determineRolesToDelete(QueryableBuiltInRoles roles, Map<String, String> indexedRolesDigests) {
        assert (roles != null);
        if (indexedRolesDigests == null) {
            return Set.of();
        }
        Set rolesToDelete = Sets.difference(indexedRolesDigests.keySet(), roles.rolesDigest().keySet());
        return Collections.unmodifiableSet(rolesToDelete);
    }

    public static Set<RoleDescriptor> determineRolesToUpsert(QueryableBuiltInRoles roles, Map<String, String> indexedRolesDigests) {
        assert (roles != null);
        HashSet<RoleDescriptor> rolesToUpsert = new HashSet<RoleDescriptor>();
        for (RoleDescriptor role : roles.roleDescriptors()) {
            String roleDigest = roles.rolesDigest().get(role.getName());
            if (indexedRolesDigests == null || !indexedRolesDigests.containsKey(role.getName())) {
                rolesToUpsert.add(role);
                continue;
            }
            if (indexedRolesDigests.get(role.getName()).equals(roleDigest)) continue;
            rolesToUpsert.add(role);
        }
        return Collections.unmodifiableSet(rolesToUpsert);
    }

    private QueryableBuiltInRolesUtils() {
        throw new IllegalAccessError("not allowed");
    }
}

