/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchRoleRestrictionException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.TransportClosePointInTimeAction;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.async.TransportDeleteAsyncResultAction;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.IndicesAndAliasesResolverField;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteIndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.permission.SimpleRole;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.NamedClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.StringMatcher;
import org.elasticsearch.xpack.security.action.user.TransportChangePasswordAction;
import org.elasticsearch.xpack.security.authz.LoadAuthorizedIndicesTimeChecker;
import org.elasticsearch.xpack.security.authz.PreAuthorizationUtils;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class RBACEngine
implements AuthorizationEngine {
    private static final Predicate<String> SAME_USER_PRIVILEGE = StringMatcher.of((String[])new String[]{TransportChangePasswordAction.TYPE.name(), "cluster:admin/xpack/security/user/authenticate", "cluster:admin/xpack/security/user/has_privileges", "cluster:admin/xpack/security/user/list_privileges", "cluster:admin/xpack/security/api_key/get"});
    private static final String INDEX_SUB_REQUEST_PRIMARY = "indices:data/write/index[p]";
    private static final String INDEX_SUB_REQUEST_REPLICA = "indices:data/write/index[r]";
    private static final String DELETE_SUB_REQUEST_PRIMARY = "indices:data/write/delete[p]";
    private static final String DELETE_SUB_REQUEST_REPLICA = "indices:data/write/delete[r]";
    private static final Logger logger = LogManager.getLogger(RBACEngine.class);
    private static final Set<String> SCROLL_RELATED_ACTIONS = Set.of(TransportSearchScrollAction.TYPE.name(), "indices:data/read/search[phase/fetch/id/scroll]", "indices:data/read/search[phase/query+fetch/scroll]", "indices:data/read/search[phase/query/scroll]", "indices:data/read/search[free_context]", "indices:data/read/search[free_context/scroll]", "indices:data/read/scroll/clear", "indices:data/read/sql/close_cursor", "indices:data/read/search[clear_scroll_contexts]");
    private final Settings settings;
    private final CompositeRolesStore rolesStore;
    private final FieldPermissionsCache fieldPermissionsCache;
    private final LoadAuthorizedIndicesTimeChecker.Factory authzIndicesTimerFactory;

    public RBACEngine(Settings settings, CompositeRolesStore rolesStore, FieldPermissionsCache fieldPermissionsCache, LoadAuthorizedIndicesTimeChecker.Factory authzIndicesTimerFactory) {
        this.settings = settings;
        this.rolesStore = rolesStore;
        this.fieldPermissionsCache = fieldPermissionsCache;
        this.authzIndicesTimerFactory = authzIndicesTimerFactory;
    }

    public void resolveAuthorizationInfo(AuthorizationEngine.RequestInfo requestInfo, ActionListener<AuthorizationEngine.AuthorizationInfo> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        this.rolesStore.getRoles(authentication, (ActionListener<Tuple<Role, Role>>)listener.delegateFailureAndWrap((l, roleTuple) -> {
            if (roleTuple.v1() == Role.EMPTY_RESTRICTED_BY_WORKFLOW || roleTuple.v2() == Role.EMPTY_RESTRICTED_BY_WORKFLOW) {
                l.onFailure((Exception)new ElasticsearchRoleRestrictionException("access restricted by workflow", new Object[0]));
            } else {
                l.onResponse((Object)new RBACAuthorizationInfo((Role)roleTuple.v1(), (Role)roleTuple.v2()));
            }
        }));
    }

    public void resolveAuthorizationInfo(Subject subject, ActionListener<AuthorizationEngine.AuthorizationInfo> listener) {
        this.rolesStore.getRole(subject, (ActionListener<Role>)listener.map(role -> new RBACAuthorizationInfo((Role)role, (Role)role)));
    }

    public void authorizeRunAs(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getAuthenticatedUserAuthorizationInfo().getRole();
            listener.onResponse((Object)new AuthorizationEngine.AuthorizationResult(role.checkRunAs(requestInfo.getAuthentication().getEffectiveSubject().getUser().principal())));
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    public void authorizeClusterAction(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            if (role.checkClusterAction(requestInfo.getAction(), requestInfo.getRequest(), requestInfo.getAuthentication())) {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
            } else if (RBACEngine.checkSameUserPermissions(requestInfo.getAction(), requestInfo.getRequest(), requestInfo.getAuthentication())) {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
            } else if ("cluster:monitor/async_search/status".equals(requestInfo.getAction()) && role.checkIndicesAction("indices:data/read/async_search/submit")) {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
            } else {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.deny());
            }
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    static boolean checkSameUserPermissions(String action, TransportRequest request, Authentication authentication) {
        boolean actionAllowed = SAME_USER_PRIVILEGE.test(action);
        if (actionAllowed) {
            if (request instanceof AuthenticateRequest) {
                return true;
            }
            if (request instanceof UserRequest) {
                UserRequest userRequest = (UserRequest)request;
                String[] usernames = userRequest.usernames();
                if (usernames == null || usernames.length != 1 || usernames[0] == null) {
                    assert (false) : "this role should only be used for actions to apply to a single user";
                    return false;
                }
                String username = usernames[0];
                if (authentication.isCrossClusterAccess() && "cluster:admin/xpack/security/user/has_privileges".equals(action)) {
                    assert (request instanceof HasPrivilegesRequest);
                    return Authentication.getAuthenticationFromCrossClusterAccessMetadata((Authentication)authentication).getEffectiveSubject().getUser().principal().equals(username);
                }
                boolean sameUsername = authentication.getEffectiveSubject().getUser().principal().equals(username);
                if (sameUsername && TransportChangePasswordAction.TYPE.name().equals(action)) {
                    return RBACEngine.checkChangePasswordAction(authentication);
                }
                assert ("cluster:admin/xpack/security/user/authenticate".equals(action) || "cluster:admin/xpack/security/user/has_privileges".equals(action) || "cluster:admin/xpack/security/user/list_privileges".equals(action) || !sameUsername) : "Action '" + action + "' should not be possible when sameUsername=" + sameUsername;
                return sameUsername;
            }
            if (request instanceof GetApiKeyRequest) {
                GetApiKeyRequest getApiKeyRequest = (GetApiKeyRequest)request;
                if (authentication.isApiKey()) {
                    String authenticatedApiKeyId = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
                    if (org.elasticsearch.common.Strings.hasText((String)getApiKeyRequest.getApiKeyId())) {
                        return getApiKeyRequest.getApiKeyId().equals(authenticatedApiKeyId) && false == getApiKeyRequest.withLimitedBy();
                    }
                    return false;
                }
            } else {
                assert (false) : "right now only a user request or get api key request should be allowed";
                return false;
            }
        }
        return false;
    }

    private static boolean shouldAuthorizeIndexActionNameOnly(String action, TransportRequest request) {
        switch (action) {
            case "indices:data/write/bulk": 
            case "indices:data/write/simulate/bulk": 
            case "indices:data/write/index": 
            case "indices:data/write/delete": 
            case "indices:data/write/index[p]": 
            case "indices:data/write/index[r]": 
            case "indices:data/write/delete[p]": 
            case "indices:data/write/delete[r]": 
            case "indices:data/read/mget": 
            case "indices:data/read/mtv": 
            case "indices:data/read/msearch": 
            case "indices:data/read/mpercolate": 
            case "indices:data/read/msearch/template": 
            case "indices:data/read/search/template": 
            case "indices:data/write/reindex": 
            case "indices:data/read/sql": 
            case "indices:data/read/sql/translate": 
            case "indices:data/read/esql": 
            case "indices:data/read/esql/compute": {
                if (request instanceof BulkShardRequest) {
                    return false;
                }
                if (!(request instanceof CompositeIndicesRequest)) {
                    throw new IllegalStateException("Composite and bulk actions must implement " + CompositeIndicesRequest.class.getSimpleName() + ", " + request.getClass().getSimpleName() + " doesn't. Action " + action);
                }
                return true;
            }
        }
        return false;
    }

    public SubscribableListener<AuthorizationEngine.IndexAuthorizationResult> authorizeIndexAction(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, AuthorizationEngine.AsyncSupplier<ResolvedIndices> indicesAsyncSupplier, ProjectMetadata metadata) {
        Role role;
        String action = requestInfo.getAction();
        TransportRequest request = requestInfo.getRequest();
        try {
            role = RBACEngine.ensureRBAC(authorizationInfo).getRole();
        }
        catch (Exception e) {
            return SubscribableListener.newFailed((Exception)e);
        }
        if (TransportActionProxy.isProxyAction((String)action) || RBACEngine.shouldAuthorizeIndexActionNameOnly(action, request)) {
            return SubscribableListener.newSucceeded((Object)(role.checkIndicesAction(action) ? AuthorizationEngine.IndexAuthorizationResult.EMPTY : AuthorizationEngine.IndexAuthorizationResult.DENIED));
        }
        if (!(request instanceof IndicesRequest)) {
            if (SCROLL_RELATED_ACTIONS.contains(action)) {
                if (TransportSearchScrollAction.TYPE.name().equals(action)) {
                    SubscribableListener listener = new SubscribableListener();
                    ActionRunnable.supply((ActionListener)listener.delegateFailureAndWrap((l, parsedScrollId) -> {
                        if (parsedScrollId.hasLocalIndices()) {
                            l.onResponse((Object)(role.checkIndicesAction(action) ? AuthorizationEngine.IndexAuthorizationResult.EMPTY : AuthorizationEngine.IndexAuthorizationResult.DENIED));
                        } else {
                            l.onResponse((Object)AuthorizationEngine.IndexAuthorizationResult.EMPTY);
                        }
                    }), () -> ((SearchScrollRequest)((SearchScrollRequest)request)).parseScrollId()).run();
                    return listener;
                }
                return SubscribableListener.newSucceeded((Object)AuthorizationEngine.IndexAuthorizationResult.EMPTY);
            }
            if (RBACEngine.isAsyncRelatedAction(action)) {
                if ("indices:data/read/async_search/submit".equals(action)) {
                    return SubscribableListener.newSucceeded((Object)AuthorizationEngine.IndexAuthorizationResult.EMPTY);
                }
                return SubscribableListener.newSucceeded((Object)AuthorizationEngine.IndexAuthorizationResult.ALLOW_NO_INDICES);
            }
            if (action.equals(TransportClosePointInTimeAction.TYPE.name())) {
                return SubscribableListener.newSucceeded((Object)AuthorizationEngine.IndexAuthorizationResult.ALLOW_NO_INDICES);
            }
            assert (false) : "only scroll and async-search related requests are known indices api that don't support retrieving the indices they relate to";
            return SubscribableListener.newFailed((Exception)new IllegalStateException("only scroll and async-search related requests are known indices api that don't support retrieving the indices they relate to"));
        }
        if (RBACEngine.isChildActionAuthorizedByParentOnLocalNode(requestInfo, authorizationInfo)) {
            return SubscribableListener.newSucceeded((Object)new AuthorizationEngine.IndexAuthorizationResult(requestInfo.getOriginatingAuthorizationContext().getIndicesAccessControl()));
        }
        if (PreAuthorizationUtils.shouldPreAuthorizeChildByParentAction(requestInfo, authorizationInfo)) {
            return SubscribableListener.newSucceeded((Object)new AuthorizationEngine.IndexAuthorizationResult(IndicesAccessControl.allowAll()));
        }
        if (RBACEngine.allowsRemoteIndices(request) || role.checkIndicesAction(action)) {
            SubscribableListener listener = new SubscribableListener();
            indicesAsyncSupplier.getAsync().addListener(listener.delegateFailureAndWrap((delegateListener, resolvedIndices) -> {
                assert (!resolvedIndices.isEmpty()) : "every indices request needs to have its indices set thus the resolved indices must not be empty";
                if (resolvedIndices.isNoIndicesPlaceholder()) {
                    if (RBACEngine.allowsRemoteIndices(request) && !role.checkIndicesAction(action)) {
                        delegateListener.onResponse((Object)AuthorizationEngine.IndexAuthorizationResult.DENIED);
                    } else {
                        delegateListener.onResponse((Object)AuthorizationEngine.IndexAuthorizationResult.ALLOW_NO_INDICES);
                    }
                } else {
                    IndicesRequest.RemoteClusterShardRequest shardsRequest;
                    IndicesAliasesRequest indicesAliasesRequest;
                    AliasesRequest aliasesRequest;
                    assert (resolvedIndices.getLocal().stream().noneMatch(Regex::isSimpleMatchPattern) || !((IndicesRequest)request).indicesOptions().expandWildcardExpressions() || request instanceof AliasesRequest && !(aliasesRequest = (AliasesRequest)request).expandAliasesWildcards() || request instanceof IndicesAliasesRequest && false == (indicesAliasesRequest = (IndicesAliasesRequest)request).getAliasActions().stream().allMatch(IndicesAliasesRequest.AliasActions::expandAliasesWildcards)) : "expanded wildcards for local indices OR the request should not expand wildcards at all";
                    AuthorizationEngine.IndexAuthorizationResult result = this.buildIndicesAccessControl(action, role, (ResolvedIndices)resolvedIndices, metadata);
                    if (requestInfo.getAuthentication().isCrossClusterAccess() && request instanceof IndicesRequest.RemoteClusterShardRequest && (shardsRequest = (IndicesRequest.RemoteClusterShardRequest)request).shards() != null) {
                        for (ShardId shardId : shardsRequest.shards()) {
                            if (shardId == null || RBACEngine.shardIdAuthorized((IndicesRequest)shardsRequest, shardId, result.getIndicesAccessControl())) continue;
                            listener.onResponse((Object)AuthorizationEngine.IndexAuthorizationResult.DENIED);
                            return;
                        }
                    }
                    delegateListener.onResponse((Object)result);
                }
            }));
            return listener;
        }
        return SubscribableListener.newSucceeded((Object)AuthorizationEngine.IndexAuthorizationResult.DENIED);
    }

    private static boolean shardIdAuthorized(IndicesRequest request, ShardId shardId, IndicesAccessControl accessControl) {
        IndicesAccessControl.IndexAccessControl shardIdAccessPermissions = accessControl.getIndexPermissions(shardId.getIndexName());
        if (shardIdAccessPermissions != null) {
            return true;
        }
        logger.warn(org.elasticsearch.common.Strings.format((String)"bad request of type [%s], request's stated indices %s are authorized but specified internal shard ID %s is not authorized", (Object[])new Object[]{request.getClass().getCanonicalName(), request.indices(), shardId}));
        return false;
    }

    private static boolean allowsRemoteIndices(TransportRequest transportRequest) {
        IndicesRequest.Replaceable replaceable;
        if (transportRequest instanceof IndicesRequest.SingleIndexNoWildcards) {
            IndicesRequest.SingleIndexNoWildcards single = (IndicesRequest.SingleIndexNoWildcards)transportRequest;
            return single.allowsRemoteIndices();
        }
        return transportRequest instanceof IndicesRequest.Replaceable && (replaceable = (IndicesRequest.Replaceable)transportRequest).allowsRemoteIndices();
    }

    private static boolean isChildActionAuthorizedByParentOnLocalNode(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        IndicesAliasesRequest indicesAliasesRequest;
        AliasesRequest aliasesRequest;
        AuthorizationEngine.AuthorizationContext parent = requestInfo.getOriginatingAuthorizationContext();
        if (parent == null) {
            return false;
        }
        IndicesAccessControl indicesAccessControl = parent.getIndicesAccessControl();
        if (indicesAccessControl == null) {
            return false;
        }
        if (!requestInfo.getAction().startsWith(parent.getAction())) {
            return false;
        }
        if (!authorizationInfo.equals((Object)parent.getAuthorizationInfo())) {
            return false;
        }
        if (!(requestInfo.getRequest() instanceof IndicesRequest)) {
            return false;
        }
        IndicesRequest indicesRequest = (IndicesRequest)requestInfo.getRequest();
        Object[] indices = indicesRequest.indices();
        if (indices == null || indices.length == 0) {
            return false;
        }
        if (Arrays.equals(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY, indices)) {
            return false;
        }
        assert (Arrays.stream(indices).noneMatch(Regex::isSimpleMatchPattern) || !indicesRequest.indicesOptions().expandWildcardExpressions() || indicesRequest instanceof AliasesRequest && !(aliasesRequest = (AliasesRequest)indicesRequest).expandAliasesWildcards() || indicesRequest instanceof IndicesAliasesRequest && false == (indicesAliasesRequest = (IndicesAliasesRequest)indicesRequest).getAliasActions().stream().allMatch(IndicesAliasesRequest.AliasActions::expandAliasesWildcards)) : "child request with action [" + requestInfo.getAction() + "] contains unexpanded wildcards " + String.valueOf(Arrays.stream(indices).filter(Regex::isSimpleMatchPattern).toList());
        for (Object index : indices) {
            if (indicesAccessControl.hasIndexPermissions((String)index)) continue;
            return false;
        }
        return true;
    }

    public void loadAuthorizedIndices(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, Map<String, IndexAbstraction> indicesLookup, ActionListener<AuthorizationEngine.AuthorizedIndices> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            listener.onResponse((Object)RBACEngine.resolveAuthorizedIndicesFromRole(role, requestInfo, indicesLookup, () -> this.authzIndicesTimerFactory.newTimer(requestInfo)));
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    public void validateIndexPermissionsAreSubset(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, Map<String, List<String>> indexNameToNewNames, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            HashMap<String, Automaton> permissionMap = new HashMap<String, Automaton>();
            for (Map.Entry<String, List<String>> entry : indexNameToNewNames.entrySet()) {
                Automaton existingPermissions = permissionMap.computeIfAbsent(entry.getKey(), arg_0 -> ((Role)role).allowedActionsMatcher(arg_0));
                for (String alias : entry.getValue()) {
                    Automaton newNamePermissions = permissionMap.computeIfAbsent(alias, arg_0 -> ((Role)role).allowedActionsMatcher(arg_0));
                    if (Automatons.subsetOf((Automaton)newNamePermissions, (Automaton)existingPermissions)) continue;
                    listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.deny());
                    return;
                }
            }
            listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    public void checkPrivileges(AuthorizationEngine.AuthorizationInfo authorizationInfo, AuthorizationEngine.PrivilegesToCheck privilegesToCheck, Collection<ApplicationPrivilegeDescriptor> applicationPrivileges, ActionListener<AuthorizationEngine.PrivilegesCheckResult> originalListener) {
        ActionListener listener;
        if (!(authorizationInfo instanceof RBACAuthorizationInfo)) {
            originalListener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
            return;
        }
        Role userRole = ((RBACAuthorizationInfo)authorizationInfo).getRole();
        logger.trace(() -> Strings.format((String)"Check whether role [%s] has privileges [%s]", (Object[])new Object[]{org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])userRole.names()), privilegesToCheck}));
        if (userRole instanceof SimpleRole) {
            SimpleRole simpleRole = (SimpleRole)userRole;
            AuthorizationEngine.PrivilegesCheckResult result = simpleRole.checkPrivilegesWithCache(privilegesToCheck);
            if (result != null) {
                logger.debug(() -> Strings.format((String)"role [%s] has privileges check result in cache for check: [%s]", (Object[])new Object[]{org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])userRole.names()), privilegesToCheck}));
                originalListener.onResponse((Object)result);
                return;
            }
            listener = originalListener.delegateFailure((delegateListener, privilegesCheckResult) -> {
                try {
                    simpleRole.cacheHasPrivileges(this.settings, privilegesToCheck, privilegesCheckResult);
                }
                catch (Exception e) {
                    logger.error("Failed to cache check result for [{}]", (Object)privilegesToCheck);
                    delegateListener.onFailure(e);
                    return;
                }
                delegateListener.onResponse(privilegesCheckResult);
            });
        } else {
            listener = originalListener;
        }
        boolean allMatch = true;
        HashMap<String, Boolean> clusterPrivilegesCheckResults = new HashMap<String, Boolean>();
        for (String checkAction : privilegesToCheck.cluster()) {
            boolean privilegeGranted = userRole.grants((ClusterPrivilege)ClusterPrivilegeResolver.resolve((String)checkAction));
            boolean bl = allMatch = allMatch && privilegeGranted;
            if (privilegesToCheck.runDetailedCheck()) {
                clusterPrivilegesCheckResults.put(checkAction, privilegeGranted);
                continue;
            }
            if (allMatch) continue;
            listener.onResponse((Object)AuthorizationEngine.PrivilegesCheckResult.SOME_CHECKS_FAILURE_NO_DETAILS);
            return;
        }
        ResourcePrivilegesMap.Builder combineIndicesResourcePrivileges = privilegesToCheck.runDetailedCheck() ? ResourcePrivilegesMap.builder() : null;
        for (RoleDescriptor.IndicesPrivileges check : privilegesToCheck.index()) {
            boolean privilegesGranted = userRole.checkIndicesPrivileges((Set)Sets.newHashSet((Object[])check.getIndices()), check.allowRestrictedIndices(), (Set)Sets.newHashSet((Object[])check.getPrivileges()), combineIndicesResourcePrivileges);
            boolean bl = allMatch = allMatch && privilegesGranted;
            if (privilegesToCheck.runDetailedCheck() || allMatch) continue;
            assert (combineIndicesResourcePrivileges == null);
            listener.onResponse((Object)AuthorizationEngine.PrivilegesCheckResult.SOME_CHECKS_FAILURE_NO_DETAILS);
            return;
        }
        HashMap privilegesByApplication = new HashMap();
        Set applicationNames = Arrays.stream(privilegesToCheck.application()).map(RoleDescriptor.ApplicationResourcePrivileges::getApplication).collect(Collectors.toSet());
        for (String applicationName : applicationNames) {
            logger.debug(() -> Strings.format((String)"Checking privileges for application [%s]", (Object[])new Object[]{applicationName}));
            ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder = privilegesToCheck.runDetailedCheck() ? ResourcePrivilegesMap.builder() : null;
            for (RoleDescriptor.ApplicationResourcePrivileges p : privilegesToCheck.application()) {
                if (!applicationName.equals(p.getApplication())) continue;
                boolean privilegesGranted = userRole.checkApplicationResourcePrivileges(applicationName, (Set)Sets.newHashSet((Object[])p.getResources()), (Set)Sets.newHashSet((Object[])p.getPrivileges()), applicationPrivileges, resourcePrivilegesMapBuilder);
                boolean bl = allMatch = allMatch && privilegesGranted;
                if (privilegesToCheck.runDetailedCheck() || allMatch) continue;
                listener.onResponse((Object)AuthorizationEngine.PrivilegesCheckResult.SOME_CHECKS_FAILURE_NO_DETAILS);
                return;
            }
            if (resourcePrivilegesMapBuilder == null) continue;
            privilegesByApplication.put(applicationName, resourcePrivilegesMapBuilder.build().getResourceToResourcePrivileges().values());
        }
        if (privilegesToCheck.runDetailedCheck()) {
            assert (combineIndicesResourcePrivileges != null);
            listener.onResponse((Object)new AuthorizationEngine.PrivilegesCheckResult(allMatch, new AuthorizationEngine.PrivilegesCheckResult.Details(clusterPrivilegesCheckResults, combineIndicesResourcePrivileges.build().getResourceToResourcePrivileges(), privilegesByApplication)));
        } else {
            assert (allMatch);
            listener.onResponse((Object)AuthorizationEngine.PrivilegesCheckResult.ALL_CHECKS_SUCCESS_NO_DETAILS);
        }
    }

    public void getUserPrivileges(AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<GetUserPrivilegesResponse> listener) {
        if (!(authorizationInfo instanceof RBACAuthorizationInfo)) {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        } else {
            GetUserPrivilegesResponse getUserPrivilegesResponse;
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            try {
                getUserPrivilegesResponse = RBACEngine.buildUserPrivilegesResponseObject(role);
            }
            catch (UnsupportedOperationException e) {
                listener.onFailure((Exception)new IllegalArgumentException("Cannot retrieve privileges for API keys with assigned role descriptors. Please use the Get API key information API https://ela.st/es-api-get-api-key", e));
                return;
            }
            listener.onResponse((Object)getUserPrivilegesResponse);
        }
    }

    public void getRoleDescriptorsIntersectionForRemoteCluster(String remoteClusterAlias, TransportVersion remoteClusterVersion, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<RoleDescriptorsIntersection> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            RBACAuthorizationInfo rbacAuthzInfo = (RBACAuthorizationInfo)authorizationInfo;
            Role role = rbacAuthzInfo.getRole();
            listener.onResponse((Object)role.getRoleDescriptorsIntersectionForRemoteCluster(remoteClusterAlias, remoteClusterVersion));
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info: " + authorizationInfo.getClass().getSimpleName()));
        }
    }

    static GetUserPrivilegesResponse buildUserPrivilegesResponseObject(Role userRole) {
        logger.trace(() -> "List privileges for role [" + org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])userRole.names()) + "]");
        TreeSet<String> cluster = new TreeSet<String>();
        HashSet<ConfigurableClusterPrivilege> conditionalCluster = new HashSet<ConfigurableClusterPrivilege>();
        for (IndicesPermission.Group[] privilege : userRole.cluster().privileges()) {
            if (privilege instanceof NamedClusterPrivilege) {
                cluster.add(((NamedClusterPrivilege)privilege).name());
                continue;
            }
            if (privilege instanceof ConfigurableClusterPrivilege) {
                conditionalCluster.add((ConfigurableClusterPrivilege)privilege);
                continue;
            }
            throw new IllegalArgumentException("found unsupported cluster privilege : " + String.valueOf(privilege) + (String)(privilege != null ? " of type " + privilege.getClass().getSimpleName() : ""));
        }
        LinkedHashSet<GetUserPrivilegesResponse.Indices> indices = new LinkedHashSet<GetUserPrivilegesResponse.Indices>();
        for (IndicesPermission.Group group : userRole.indices().groups()) {
            indices.add(RBACEngine.toIndices(group));
        }
        LinkedHashSet<GetUserPrivilegesResponse.RemoteIndices> remoteIndices = new LinkedHashSet<GetUserPrivilegesResponse.RemoteIndices>();
        for (RemoteIndicesPermission.RemoteIndicesGroup remoteIndicesGroup : userRole.remoteIndices().remoteIndicesGroups()) {
            for (IndicesPermission.Group group : remoteIndicesGroup.indicesPermissionGroups()) {
                remoteIndices.add(new GetUserPrivilegesResponse.RemoteIndices(RBACEngine.toIndices(group), remoteIndicesGroup.remoteClusterAliases()));
            }
        }
        LinkedHashSet<RoleDescriptor.ApplicationResourcePrivileges> application = new LinkedHashSet<RoleDescriptor.ApplicationResourcePrivileges>();
        for (String applicationName : userRole.application().getApplicationNames()) {
            for (ApplicationPrivilege privilege : userRole.application().getPrivileges(applicationName)) {
                Set resources = userRole.application().getResourcePatterns(privilege);
                if (resources.isEmpty()) {
                    logger.trace("No resources defined in application privilege {}", (Object)privilege);
                    continue;
                }
                application.add(RoleDescriptor.ApplicationResourcePrivileges.builder().application(applicationName).privileges((Collection)privilege.name()).resources((Collection)resources).build());
            }
        }
        Privilege runAsPrivilege = userRole.runAs().getPrivilege();
        Set runAs = Operations.isEmpty((Automaton)runAsPrivilege.getAutomaton()) ? Collections.emptySet() : runAsPrivilege.name();
        return new GetUserPrivilegesResponse(cluster, conditionalCluster, RBACEngine.combineIndices(indices), application, runAs, remoteIndices, userRole.remoteCluster());
    }

    private static Set<GetUserPrivilegesResponse.Indices> combineIndices(Set<GetUserPrivilegesResponse.Indices> indices) {
        LinkedHashMap<Tuple, GetUserPrivilegesResponse.Indices> combinedIndices = new LinkedHashMap<Tuple, GetUserPrivilegesResponse.Indices>();
        for (GetUserPrivilegesResponse.Indices index : indices) {
            boolean flsDlsMatch;
            GetUserPrivilegesResponse.Indices existing = (GetUserPrivilegesResponse.Indices)combinedIndices.get(new Tuple((Object)index.allowRestrictedIndices(), (Object)index.getIndices()));
            if (existing == null) {
                combinedIndices.put(new Tuple((Object)index.allowRestrictedIndices(), (Object)index.getIndices()), index);
                continue;
            }
            HashSet combinedPrivileges = new HashSet(existing.getPrivileges());
            combinedPrivileges.addAll(index.getPrivileges());
            boolean bl = flsDlsMatch = Objects.equals(existing.getFieldSecurity(), index.getFieldSecurity()) && Objects.equals(existing.getQueries(), index.getQueries());
            assert (existing.getIndices().equals(index.getIndices()) && existing.allowRestrictedIndices() == index.allowRestrictedIndices() && flsDlsMatch);
            if (!flsDlsMatch) {
                return indices;
            }
            combinedIndices.put(new Tuple((Object)index.allowRestrictedIndices(), (Object)index.getIndices()), new GetUserPrivilegesResponse.Indices((Collection)index.getIndices(), combinedPrivileges, index.getFieldSecurity(), index.getQueries(), index.allowRestrictedIndices()));
        }
        return new LinkedHashSet<GetUserPrivilegesResponse.Indices>(combinedIndices.values());
    }

    private static GetUserPrivilegesResponse.Indices toIndices(IndicesPermission.Group group) {
        Set queries = group.getQuery() == null ? Collections.emptySet() : group.getQuery();
        Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldSecurity = RBACEngine.getFieldGrantExcludeGroups(group);
        return new GetUserPrivilegesResponse.Indices(Arrays.asList(group.indices()), (Collection)group.privilege().name(), fieldSecurity, queries, group.allowRestrictedIndices());
    }

    private static Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> getFieldGrantExcludeGroups(IndicesPermission.Group group) {
        if (group.getFieldPermissions().hasFieldLevelSecurity()) {
            List fieldPermissionsDefinitions = group.getFieldPermissions().getFieldPermissionsDefinitions();
            assert (fieldPermissionsDefinitions.size() == 1) : "limited-by field must not exist since we do not support reporting user privileges for limited roles";
            FieldPermissionsDefinition definition = (FieldPermissionsDefinition)fieldPermissionsDefinitions.get(0);
            return definition.getFieldGrantExcludeGroups();
        }
        return Collections.emptySet();
    }

    static AuthorizedIndices resolveAuthorizedIndicesFromRole(Role role, AuthorizationEngine.RequestInfo requestInfo, Map<String, IndexAbstraction> lookup, Supplier<Consumer<Collection<String>>> timerSupplier) {
        IndicesPermission.IsResourceAuthorizedPredicate predicate = role.allowedIndicesMatcher(requestInfo.getAction());
        TransportRequest request = requestInfo.getRequest();
        boolean includeDataStreams = request instanceof IndicesRequest && ((IndicesRequest)request).includeDataStreams();
        return new AuthorizedIndices(() -> {
            Consumer timeChecker = (Consumer)timerSupplier.get();
            HashSet<String> indicesAndAliases = new HashSet<String>();
            if (includeDataStreams) {
                for (IndexAbstraction indexAbstraction : lookup.values()) {
                    if (indexAbstraction.isFailureIndexOfDataStream() && predicate.test((IndexAbstraction)indexAbstraction.getParentDataStream(), IndexComponentSelector.FAILURES)) {
                        indicesAndAliases.add(indexAbstraction.getName());
                        continue;
                    }
                    if (!predicate.test(indexAbstraction, IndexComponentSelector.DATA)) continue;
                    indicesAndAliases.add(indexAbstraction.getName());
                    if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) continue;
                    for (Index index : indexAbstraction.getIndices()) {
                        indicesAndAliases.add(index.getName());
                    }
                }
            } else {
                for (IndexAbstraction indexAbstraction : lookup.values()) {
                    if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM || !predicate.test(indexAbstraction, IndexComponentSelector.DATA)) continue;
                    indicesAndAliases.add(indexAbstraction.getName());
                }
            }
            timeChecker.accept(indicesAndAliases);
            return indicesAndAliases;
        }, () -> {
            HashSet<String> indicesAndAliases = new HashSet<String>();
            if (includeDataStreams) {
                for (IndexAbstraction indexAbstraction : lookup.values()) {
                    if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM || !predicate.test(indexAbstraction, IndexComponentSelector.FAILURES)) continue;
                    indicesAndAliases.add(indexAbstraction.getName());
                    for (Index index : ((DataStream)indexAbstraction).getFailureIndices()) {
                        indicesAndAliases.add(index.getName());
                    }
                }
            }
            return indicesAndAliases;
        }, (name, selector) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)lookup.get(name);
            if (indexAbstraction == null) {
                return predicate.test(name, null, selector);
            }
            if (indexAbstraction.getParentDataStream() != null && (indexAbstraction.isFailureIndexOfDataStream() ? predicate.test((IndexAbstraction)indexAbstraction.getParentDataStream(), IndexComponentSelector.FAILURES) : (IndexComponentSelector.DATA.equals(selector) || selector == null) && predicate.test((IndexAbstraction)indexAbstraction.getParentDataStream(), IndexComponentSelector.DATA))) {
                return true;
            }
            return predicate.test(indexAbstraction, selector);
        });
    }

    private AuthorizationEngine.IndexAuthorizationResult buildIndicesAccessControl(String action, Role role, ResolvedIndices resolvedIndices, ProjectMetadata metadata) {
        IndicesAccessControl accessControl = role.authorize(action, (Set)Sets.newHashSet((Iterable)resolvedIndices.getLocal()), metadata, this.fieldPermissionsCache);
        return new AuthorizationEngine.IndexAuthorizationResult(accessControl);
    }

    private static RBACAuthorizationInfo ensureRBAC(AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (!(authorizationInfo instanceof RBACAuthorizationInfo)) {
            throw new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName());
        }
        return (RBACAuthorizationInfo)authorizationInfo;
    }

    public static Role maybeGetRBACEngineRole(AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            return ((RBACAuthorizationInfo)authorizationInfo).getRole();
        }
        return null;
    }

    private static boolean checkChangePasswordAction(Authentication authentication) {
        boolean isRunAs = authentication.isRunAs();
        String realmType = isRunAs ? authentication.getEffectiveSubject().getRealm().getType() : authentication.getAuthenticatingSubject().getRealm().getType();
        assert (realmType != null);
        Authentication.AuthenticationType authType = authentication.getAuthenticationType();
        return authType.equals((Object)Authentication.AuthenticationType.REALM) && ("reserved".equals(realmType) || "native".equals(realmType));
    }

    private static boolean isAsyncRelatedAction(String action) {
        return action.equals("indices:data/read/async_search/submit") || action.equals("indices:data/read/async_search/get") || action.equals(TransportDeleteAsyncResultAction.TYPE.name()) || action.equals("indices:data/read/eql/async/get") || action.equals("indices:data/read/esql/async/get") || action.equals("indices:data/read/esql/async/stop") || action.equals("indices:data/read/sql/async/get");
    }

    static class RBACAuthorizationInfo
    implements AuthorizationEngine.AuthorizationInfo {
        private final Role role;
        private final Map<String, Object> info;
        private final RBACAuthorizationInfo authenticatedUserAuthorizationInfo;

        RBACAuthorizationInfo(Role role, Role authenticatedUserRole) {
            this.role = Objects.requireNonNull(role);
            this.info = Collections.singletonMap("user.roles", role.names());
            this.authenticatedUserAuthorizationInfo = authenticatedUserRole == null ? this : new RBACAuthorizationInfo(authenticatedUserRole, null);
        }

        Role getRole() {
            return this.role;
        }

        public Map<String, Object> asMap() {
            return this.info;
        }

        public RBACAuthorizationInfo getAuthenticatedUserAuthorizationInfo() {
            return this.authenticatedUserAuthorizationInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RBACAuthorizationInfo that = (RBACAuthorizationInfo)o;
            if (!this.role.equals((Object)that.role)) {
                return false;
            }
            if (this.authenticatedUserAuthorizationInfo == this) {
                return that.authenticatedUserAuthorizationInfo == that;
            }
            return this.authenticatedUserAuthorizationInfo.equals(that.authenticatedUserAuthorizationInfo);
        }

        public int hashCode() {
            if (this.authenticatedUserAuthorizationInfo == this) {
                return Objects.hashCode(this.role);
            }
            return Objects.hash(this.role, this.authenticatedUserAuthorizationInfo);
        }
    }

    static final class AuthorizedIndices
    implements AuthorizationEngine.AuthorizedIndices {
        private final CachedSupplier<Set<String>> authorizedAndAvailableDataResources;
        private final CachedSupplier<Set<String>> authorizedAndAvailableFailuresResources;
        private final BiPredicate<String, IndexComponentSelector> isAuthorizedPredicate;

        AuthorizedIndices(Supplier<Set<String>> authorizedAndAvailableDataResources, Supplier<Set<String>> authorizedAndAvailableFailuresResources, BiPredicate<String, IndexComponentSelector> isAuthorizedPredicate) {
            this.authorizedAndAvailableDataResources = CachedSupplier.wrap(authorizedAndAvailableDataResources);
            this.authorizedAndAvailableFailuresResources = CachedSupplier.wrap(authorizedAndAvailableFailuresResources);
            this.isAuthorizedPredicate = Objects.requireNonNull(isAuthorizedPredicate);
        }

        public Set<String> all(IndexComponentSelector selector) {
            Objects.requireNonNull(selector, "must specify a selector to get authorized indices");
            return IndexComponentSelector.FAILURES.equals((Object)selector) ? (Set)this.authorizedAndAvailableFailuresResources.get() : (Set)this.authorizedAndAvailableDataResources.get();
        }

        public boolean check(String name, IndexComponentSelector selector) {
            Objects.requireNonNull(selector, "must specify a selector for authorization check");
            return this.isAuthorizedPredicate.test(name, selector);
        }
    }
}

