/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class CrossClusterAccessHeaders {
    public static final String CROSS_CLUSTER_ACCESS_CREDENTIALS_HEADER_KEY = "_cross_cluster_access_credentials";
    private final String credentialsHeader;
    private final CrossClusterAccessSubjectInfo crossClusterAccessSubjectInfo;

    public CrossClusterAccessHeaders(String credentialsHeader, CrossClusterAccessSubjectInfo crossClusterAccessSubjectInfo) {
        assert (credentialsHeader.startsWith("ApiKey ")) : "credentials header must start with [ApiKey ]";
        this.credentialsHeader = credentialsHeader;
        this.crossClusterAccessSubjectInfo = crossClusterAccessSubjectInfo;
    }

    public void writeToContext(ThreadContext ctx) throws IOException {
        ctx.putHeader(CROSS_CLUSTER_ACCESS_CREDENTIALS_HEADER_KEY, this.credentialsHeader);
        this.crossClusterAccessSubjectInfo.writeToContext(ctx);
    }

    public static CrossClusterAccessHeaders readFromContext(ThreadContext ctx) throws IOException {
        String credentialsHeader = ctx.getHeader(CROSS_CLUSTER_ACCESS_CREDENTIALS_HEADER_KEY);
        if (credentialsHeader == null) {
            throw new IllegalArgumentException("cross cluster access header [_cross_cluster_access_credentials] is required");
        }
        CrossClusterAccessHeaders.parseCredentialsHeader(credentialsHeader).close();
        return new CrossClusterAccessHeaders(credentialsHeader, CrossClusterAccessSubjectInfo.readFromContext((ThreadContext)ctx));
    }

    public ApiKeyService.ApiKeyCredentials credentials() {
        return CrossClusterAccessHeaders.parseCredentialsHeader(this.credentialsHeader);
    }

    static ApiKeyService.ApiKeyCredentials parseCredentialsHeader(String header) {
        try {
            return Objects.requireNonNull(ApiKeyService.getCredentialsFromHeader(header, ApiKey.Type.CROSS_CLUSTER));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("cross cluster access header [_cross_cluster_access_credentials] value must be a valid API key credential", ex);
        }
    }

    public CrossClusterAccessSubjectInfo getCleanAndValidatedSubjectInfo() {
        return this.crossClusterAccessSubjectInfo.cleanAndValidate();
    }

    CrossClusterAccessSubjectInfo getSubjectInfo() {
        return this.crossClusterAccessSubjectInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CrossClusterAccessHeaders that = (CrossClusterAccessHeaders)obj;
        return Objects.equals(this.credentialsHeader, that.credentialsHeader) && Objects.equals(this.crossClusterAccessSubjectInfo, that.crossClusterAccessSubjectInfo);
    }

    public int hashCode() {
        return Objects.hash(this.credentialsHeader, this.crossClusterAccessSubjectInfo);
    }
}

