/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingResponse;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authc.support.mapper.ProjectStateRoleMapper;

public class TransportPutRoleMappingAction
extends HandledTransportAction<PutRoleMappingRequest, PutRoleMappingResponse> {
    private final NativeRoleMappingStore roleMappingStore;
    private final ProjectStateRoleMapper projectStateRoleMapper;

    @Inject
    public TransportPutRoleMappingAction(ActionFilters actionFilters, TransportService transportService, NativeRoleMappingStore roleMappingStore, ProjectStateRoleMapper projectStateRoleMapper) {
        super("cluster:admin/xpack/security/role_mapping/put", transportService, actionFilters, PutRoleMappingRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.roleMappingStore = roleMappingStore;
        this.projectStateRoleMapper = projectStateRoleMapper;
    }

    protected void doExecute(Task task, PutRoleMappingRequest request, ActionListener<PutRoleMappingResponse> listener) {
        ExpressionRoleMapping.validateNoReadOnlySuffix((String)request.getName());
        if (this.projectStateRoleMapper.hasMapping(request.getName())) {
            HeaderWarning.addWarning((String)("A read-only role mapping with the same name [" + request.getName() + "] has been previously defined in a configuration file. Both role mappings will be used to determine role assignments."), (Object[])new Object[0]);
        }
        this.roleMappingStore.putRoleMapping(request, (ActionListener<Boolean>)ActionListener.wrap(created -> listener.onResponse((Object)new PutRoleMappingResponse(created.booleanValue())), arg_0 -> listener.onFailure(arg_0)));
    }
}

