/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.ProvAES;
import org.bouncycastle.jcajce.provider.ProvARC4;
import org.bouncycastle.jcajce.provider.ProvBCFKS;
import org.bouncycastle.jcajce.provider.ProvBlowfish;
import org.bouncycastle.jcajce.provider.ProvCAST5;
import org.bouncycastle.jcajce.provider.ProvCamellia;
import org.bouncycastle.jcajce.provider.ProvChaCha20;
import org.bouncycastle.jcajce.provider.ProvDES;
import org.bouncycastle.jcajce.provider.ProvDESede;
import org.bouncycastle.jcajce.provider.ProvDH;
import org.bouncycastle.jcajce.provider.ProvDSA;
import org.bouncycastle.jcajce.provider.ProvDSTU4145;
import org.bouncycastle.jcajce.provider.ProvEC;
import org.bouncycastle.jcajce.provider.ProvECGOST3410;
import org.bouncycastle.jcajce.provider.ProvEdEC;
import org.bouncycastle.jcajce.provider.ProvElgamal;
import org.bouncycastle.jcajce.provider.ProvFipsKS;
import org.bouncycastle.jcajce.provider.ProvGOST28147;
import org.bouncycastle.jcajce.provider.ProvGOST3410;
import org.bouncycastle.jcajce.provider.ProvIDEA;
import org.bouncycastle.jcajce.provider.ProvJKS;
import org.bouncycastle.jcajce.provider.ProvOpenSSLPBKDF;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.ProvPKIX;
import org.bouncycastle.jcajce.provider.ProvPoly1305;
import org.bouncycastle.jcajce.provider.ProvRC2;
import org.bouncycastle.jcajce.provider.ProvRSA;
import org.bouncycastle.jcajce.provider.ProvRandom;
import org.bouncycastle.jcajce.provider.ProvSEED;
import org.bouncycastle.jcajce.provider.ProvSHACAL2;
import org.bouncycastle.jcajce.provider.ProvSHS;
import org.bouncycastle.jcajce.provider.ProvSecureHash;
import org.bouncycastle.jcajce.provider.ProvSerpent;
import org.bouncycastle.jcajce.provider.ProvSipHash;
import org.bouncycastle.jcajce.provider.ProvSunTLSKDF;
import org.bouncycastle.jcajce.provider.ProvTwofish;
import org.bouncycastle.jcajce.provider.ProvX509;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import sun.security.provider.SecureRandom;
import sun.security.provider.Sun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BouncyCastleFipsProvider
extends Provider {
    private static final String info = "BouncyCastle Security Provider (FIPS edition) v1.0.2.6";
    public static final String PROVIDER_NAME = "BCFIPS";
    private static final Map<String, FipsDRBG.Base> drbgTable = new HashMap<String, FipsDRBG.Base>();
    private static final Map<String, Integer> drbgStrengthTable = new HashMap<String, Integer>();
    private volatile java.security.SecureRandom entropySource;
    private Thread entropyThread = null;
    private EntropyDaemon entropyDaemon = null;
    private FipsDRBG.Base providerDefaultRandomBuilder = FipsDRBG.SHA512;
    private int providerDefaultSecurityStrength = 256;
    private boolean providerDefaultPredictionResistance = true;
    private boolean useThreadLocal = false;
    private int providerRandomPoolSize = 16;
    private boolean hybridSource = false;
    private int providerDefaultRandomSecurityStrength = this.providerDefaultSecurityStrength;
    private final SecureRandomProvider providerDefaultSecureRandomProvider;
    private Map<String, BcService> serviceMap = new HashMap<String, BcService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final Map<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter> keyInfoConverters = new HashMap<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter>();
    private final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public BouncyCastleFipsProvider() {
        this((String)null);
    }

    public BouncyCastleFipsProvider(String string) {
        this(string, null);
    }

    public BouncyCastleFipsProvider(String string, java.security.SecureRandom secureRandom) {
        super(PROVIDER_NAME, 1.000206, info);
        if (string != null) {
            if (string.startsWith("C:") || string.startsWith("c:")) {
                this.processConfigString(Strings.toUpperCase(string));
            } else {
                throw new IllegalArgumentException("Unrecognized config string passed to BCFIPS provider.");
            }
        }
        this.entropySource = secureRandom;
        this.providerDefaultSecureRandomProvider = this.useThreadLocal ? new ThreadLocalSecureRandomProvider() : new PooledSecureRandomProvider();
        new ProvRandom().configure(this);
        new ProvSHS.SHA1().configure(this);
        new ProvSHS.SHA224().configure(this);
        new ProvSHS.SHA256().configure(this);
        new ProvSHS.SHA384().configure(this);
        new ProvSHS.SHA512().configure(this);
        new ProvSHS.SHA3_224().configure(this);
        new ProvSHS.SHA3_256().configure(this);
        new ProvSHS.SHA3_384().configure(this);
        new ProvSHS.SHA3_512().configure(this);
        if (!this.isDisabled("MD5")) {
            new ProvSecureHash.MD5().configure(this);
        }
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvSecureHash.GOST3411().configure(this);
            new ProvSecureHash.RIPEMD128().configure(this);
            new ProvSecureHash.RIPEMD160().configure(this);
            new ProvSecureHash.RIPEMD256().configure(this);
            new ProvSecureHash.RIPEMD320().configure(this);
            new ProvSecureHash.Tiger().configure(this);
            new ProvSecureHash.Whirlpool().configure(this);
        }
        new ProvDH().configure(this);
        new ProvDSA().configure(this);
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            new ProvEC().configure(this);
        }
        new ProvRSA().configure(this);
        new ProvPBEPBKDF2().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvPBEPBKDF1().configure(this);
            new ProvOpenSSLPBKDF().configure(this);
            new ProvPKCS12().configure(this);
        }
        new ProvAES().configure(this);
        new ProvDESede().configure(this);
        new ProvX509().configure(this);
        new ProvBCFKS().configure(this);
        new ProvFipsKS().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvEdEC().configure(this);
            new ProvDSTU4145().configure(this);
            new ProvElgamal().configure(this);
            new ProvGOST3410().configure(this);
            new ProvECGOST3410().configure(this);
            new ProvBlowfish().configure(this);
            new ProvCAST5().configure(this);
            new ProvRC2().configure(this);
            new ProvGOST28147().configure(this);
            new ProvSEED().configure(this);
            new ProvCamellia().configure(this);
            new ProvChaCha20().configure(this);
            new ProvDES().configure(this);
            new ProvIDEA().configure(this);
            new ProvSerpent().configure(this);
            new ProvSHACAL2().configure(this);
            new ProvTwofish().configure(this);
            new ProvARC4().configure(this);
            new ProvSipHash().configure(this);
            new ProvPoly1305().configure(this);
        }
        if (!Properties.isOverrideSet("org.bouncycastle.jsse.disable_kdf")) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsKeyMaterialParameterSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsKeyMaterialSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsMasterSecretParameterSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsPrfParameterSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec")) {
                        new ProvSunTLSKDF().configure(BouncyCastleFipsProvider.this);
                    }
                    return null;
                }
            });
        }
        if (!Properties.isOverrideSet("org.bouncycastle.pkix.disable_certpath")) {
            new ProvPKIX().configure(this);
        }
        if (Properties.isOverrideSet("org.bouncycastle.jca.enable_jks")) {
            new ProvJKS().configure(this);
        }
    }

    @Override
    public Provider configure(String string) {
        return new BouncyCastleFipsProvider(string);
    }

    private void processConfigString(String string) {
        String[] stringArray = string.substring(2).split(";");
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2.startsWith("DEFRND")) {
                String string3 = this.extractString('[', ']', string2).trim();
                while (string3 != null) {
                    String string4;
                    int n = string3.indexOf(",");
                    if (n > 0) {
                        string4 = string3.substring(0, n).trim();
                        string3 = string3.substring(n + 1);
                    } else {
                        string4 = string3;
                        string3 = null;
                    }
                    if (string4.equals("TRUE") || string4.equals("FALSE")) {
                        this.providerDefaultPredictionResistance = Boolean.valueOf(string4);
                        continue;
                    }
                    if (string4.equals("LOCAL")) {
                        this.useThreadLocal = true;
                        continue;
                    }
                    if (string4.startsWith("POOL=")) {
                        this.providerRandomPoolSize = Integer.parseInt(string4.substring(5));
                        continue;
                    }
                    this.providerDefaultRandomBuilder = drbgTable.get(string4);
                    if (drbgStrengthTable.containsKey(string4)) {
                        this.providerDefaultSecurityStrength = drbgStrengthTable.get(string4);
                    }
                    if (this.providerDefaultRandomBuilder != null) continue;
                    throw new IllegalArgumentException("Unknown DEFRND - " + string4 + " - found in config string.");
                }
                continue;
            }
            if (string2.startsWith("HYBRID")) {
                this.hybridSource = true;
                this.entropyDaemon = new EntropyDaemon();
                this.entropyThread = new Thread((Runnable)this.entropyDaemon, "BC FIPS Entropy Daemon");
                this.entropyThread.setDaemon(true);
                this.entropyThread.start();
                continue;
            }
            if (!string2.startsWith("ENABLE") || !"ENABLE{ALL}".equals(string2)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("No ENABLE command found in config string.");
        }
    }

    private String extractString(char c, char c2, String string) {
        int n = string.indexOf(c);
        int n2 = string.indexOf(c2);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Unable to parse config: ('" + c + "', '" + c2 + "') missing.");
        }
        return string.substring(n + 1, n2);
    }

    int getProviderDefaultSecurityStrength() {
        return this.providerDefaultSecurityStrength;
    }

    FipsDRBG.Base getProviderDefaultRandomBuilder() {
        return this.providerDefaultRandomBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.security.SecureRandom getDefaultSecureRandom() {
        java.security.SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandomIfSet(this.providerDefaultSecureRandomProvider);
        BouncyCastleFipsProvider bouncyCastleFipsProvider = this;
        synchronized (bouncyCastleFipsProvider) {
            if (secureRandom instanceof FipsSecureRandom) {
                int n = ((FipsSecureRandom)secureRandom).getSecurityStrength();
                if (n < this.providerDefaultRandomSecurityStrength) {
                    this.providerDefaultRandomSecurityStrength = n;
                }
            } else {
                this.providerDefaultRandomSecurityStrength = -1;
            }
        }
        return secureRandom;
    }

    EntropySourceProvider getEntropySourceProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                if (BouncyCastleFipsProvider.this.hybridSource) {
                    return new EntropySourceProvider(){

                        public EntropySource get(int n) {
                            return new HybridEntropySource(BouncyCastleFipsProvider.this.entropyDaemon, n);
                        }
                    };
                }
                if (BouncyCastleFipsProvider.this.entropySource != null) {
                    return new BasicEntropySourceProvider(BouncyCastleFipsProvider.this.entropySource, true);
                }
                return new BasicEntropySourceProvider(BouncyCastleFipsProvider.getCoreSecureRandom(), true);
            }
        });
    }

    private static java.security.SecureRandom getCoreSecureRandom() {
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<java.security.SecureRandom> clazz = java.security.SecureRandom.class;
                    return clazz.getMethod("getInstanceStrong", new Class[0]) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        if (bl) {
            return AccessController.doPrivileged(new PrivilegedAction<java.security.SecureRandom>(){

                @Override
                public java.security.SecureRandom run() {
                    try {
                        return (java.security.SecureRandom)java.security.SecureRandom.class.getMethod("getInstanceStrong", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception exception) {
                        return new CoreSecureRandom();
                    }
                }
            });
        }
        return new CoreSecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultRandomSecurityStrength() {
        BouncyCastleFipsProvider bouncyCastleFipsProvider = this;
        synchronized (bouncyCastleFipsProvider) {
            return this.providerDefaultRandomSecurityStrength;
        }
    }

    void addAttribute(String string, String string2, String string3) {
        String string4 = string + " " + string2;
        if (this.containsKey(string4)) {
            throw new IllegalStateException("duplicate provider attribute key (" + string4 + ") found");
        }
        this.put(string4, string3);
    }

    void addAttribute(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, String string3) {
        String string4 = string + "." + aSN1ObjectIdentifier + " " + string2;
        if (this.containsKey(string4)) {
            throw new IllegalStateException("duplicate provider attribute key (" + string4 + ") found");
        }
        this.put(string4, string3);
    }

    void addAttributes(String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addAttribute(string, entry.getKey(), entry.getValue());
        }
    }

    void addAttributes(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addAttribute(string, aSN1ObjectIdentifier, entry.getKey(), entry.getValue());
        }
    }

    void addAlgorithmImplementation(String string, String string2, Map<String, String> map, EngineCreator engineCreator) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.addAttribute(string, "ImplementedIn", "Software");
        this.addAttributes(string, map);
        this.put(string, string2);
        this.creatorMap.put(string2, engineCreator);
    }

    void addAlgorithmImplementation(String string, String string2, EngineCreator engineCreator) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.addAttribute(string, "ImplementedIn", "Software");
        this.put(string, string2);
        this.creatorMap.put(string2, engineCreator);
    }

    void addAlgorithmImplementation(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, EngineCreator engineCreator) {
        String string3 = string + "." + aSN1ObjectIdentifier;
        if (this.containsKey(string3)) {
            throw new IllegalStateException("duplicate provider key (" + string3 + ") found");
        }
        this.addAttribute(string, aSN1ObjectIdentifier, "ImplementedIn", "Software");
        this.put(string3, string2);
        this.creatorMap.put(string2, engineCreator);
        this.addAlias(string, aSN1ObjectIdentifier.getId(), "OID." + aSN1ObjectIdentifier.getId());
    }

    void addAlgorithmImplementation(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, Map<String, String> map, EngineCreator engineCreator) {
        String string3 = string + "." + aSN1ObjectIdentifier;
        if (this.containsKey(string3)) {
            throw new IllegalStateException("duplicate provider key (" + string3 + ") found");
        }
        this.addAttributes(string, aSN1ObjectIdentifier, map);
        this.addAttribute(string, aSN1ObjectIdentifier, "ImplementedIn", "Software");
        this.put(string3, string2);
        this.creatorMap.put(string2, engineCreator);
        this.addAlias(string, aSN1ObjectIdentifier.getId(), "OID." + aSN1ObjectIdentifier.getId());
    }

    void addAlias(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    void addAlias(String string, String string2, String ... stringArray) {
        if (!this.containsKey(string + "." + string2)) {
            throw new IllegalStateException("primary key (" + string + "." + string2 + ") not found");
        }
        for (String string3 : stringArray) {
            this.doPut("Alg.Alias." + string + "." + string3, string2);
        }
    }

    void addAlias(String string, String string2, ASN1ObjectIdentifier ... aSN1ObjectIdentifierArray) {
        if (!this.containsKey(string + "." + string2)) {
            throw new IllegalStateException("primary key (" + string + "." + string2 + ") not found");
        }
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : aSN1ObjectIdentifierArray) {
            this.doPut("Alg.Alias." + string + "." + aSN1ObjectIdentifier, string2);
            this.doPut("Alg.Alias." + string + ".OID." + aSN1ObjectIdentifier, string2);
        }
    }

    private void doPut(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    @Override
    public final synchronized Provider.Service getService(String string, String string2) {
        String string3 = Strings.toUpperCase(string2);
        BcService bcService = this.serviceMap.get(string + "." + string3);
        if (bcService == null) {
            String string4;
            String string5 = "Alg.Alias." + string + ".";
            String string6 = (String)this.get(string5 + string3);
            if (string6 == null) {
                string6 = string3;
            }
            if ((string4 = (String)this.get(string + "." + string6)) == null) {
                return null;
            }
            String string7 = string + "." + string6 + " ";
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String string8 = (String)entry.getKey();
                if (string8.startsWith(string5) && entry.getValue().equals(string2)) {
                    arrayList.add(string8.substring(string5.length()));
                }
                if (!string8.startsWith(string7)) continue;
                hashMap.put(string8.substring(string7.length()), (String)entry.getValue());
            }
            bcService = new BcService(this, string, string3, string4, arrayList, this.getAttributeMap(hashMap), this.creatorMap.get(string4));
            this.serviceMap.put(string + "." + string3, bcService);
        }
        return bcService;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> set = super.getServices();
        LinkedHashSet<Provider.Service> linkedHashSet = new LinkedHashSet<Provider.Service>();
        for (Provider.Service service : set) {
            linkedHashSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return linkedHashSet;
    }

    void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        this.keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
    }

    private boolean isDisabled(String string) {
        String string2 = Properties.getPropertyValue("org.bouncycastle.disabledAlgorithms");
        return string2 != null && string2.indexOf(string) >= 0;
    }

    private byte[] generatePersonalizationString(int n) {
        return Arrays.concatenate(Pack.intToBigEndian(n), Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private Map<String, String> getAttributeMap(Map<String, String> map) {
        Map<String, String> map2 = this.attributeMaps.get(map);
        if (map2 != null) {
            return map2;
        }
        this.attributeMaps.put(map, map);
        return map;
    }

    private static boolean classExists(String string) {
        try {
            Class clazz = ClassUtil.lookup(string);
            return clazz != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = this.keyInfoConverters.get(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = this.keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    static {
        drbgTable.put("SHA1", FipsDRBG.SHA1);
        drbgTable.put("SHA224", FipsDRBG.SHA224);
        drbgTable.put("SHA256", FipsDRBG.SHA256);
        drbgTable.put("SHA384", FipsDRBG.SHA384);
        drbgTable.put("SHA512", FipsDRBG.SHA512);
        drbgTable.put("SHA512(224)", FipsDRBG.SHA512_224);
        drbgTable.put("SHA512(256)", FipsDRBG.SHA512_256);
        drbgTable.put("HMACSHA1", FipsDRBG.SHA1_HMAC);
        drbgTable.put("HMACSHA224", FipsDRBG.SHA224_HMAC);
        drbgTable.put("HMACSHA256", FipsDRBG.SHA256_HMAC);
        drbgTable.put("HMACSHA384", FipsDRBG.SHA384_HMAC);
        drbgTable.put("HMACSHA512", FipsDRBG.SHA512_HMAC);
        drbgTable.put("HMACSHA512(224)", FipsDRBG.SHA512_224_HMAC);
        drbgTable.put("HMACSHA512(256)", FipsDRBG.SHA512_256_HMAC);
        drbgTable.put("CTRAES128", FipsDRBG.CTR_AES_128);
        drbgTable.put("CTRAES192", FipsDRBG.CTR_AES_192);
        drbgTable.put("CTRAES256", FipsDRBG.CTR_AES_256);
        drbgTable.put("CTRDESEDE", FipsDRBG.CTR_Triple_DES_168);
        drbgStrengthTable.put("SHA1", 128);
        drbgStrengthTable.put("SHA224", 192);
        drbgStrengthTable.put("SHA256", 256);
        drbgStrengthTable.put("SHA384", 256);
        drbgStrengthTable.put("SHA512", 256);
        drbgStrengthTable.put("SHA512(224)", 192);
        drbgStrengthTable.put("SHA512(256)", 256);
        drbgStrengthTable.put("HMACSHA1", 128);
        drbgStrengthTable.put("HMACSHA224", 192);
        drbgStrengthTable.put("HMACSHA256", 256);
        drbgStrengthTable.put("HMACSHA384", 256);
        drbgStrengthTable.put("HMACSHA512", 256);
        drbgStrengthTable.put("HMACSHA512(224)", 192);
        drbgStrengthTable.put("HMACSHA512(256)", 256);
        drbgStrengthTable.put("CTRAES128", 128);
        drbgStrengthTable.put("CTRAES192", 192);
        drbgStrengthTable.put("CTRAES256", 256);
        drbgStrengthTable.put("CTRDESEDE", 112);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BcService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcService(Provider provider, String string, String string2, String string3, List<String> list, Map<String, String> map, EngineCreator engineCreator) {
            super(provider, string, string2, string3, list, map);
            this.creator = engineCreator;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            try {
                FipsStatus.isReady();
                Object object2 = this.creator.createInstance(object);
                if (object2 == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return object2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + exception.getMessage(), exception);
            }
        }
    }

    private static class CoreSecureRandom
    extends java.security.SecureRandom {
        CoreSecureRandom() {
            super(new SecureRandom(), CoreSecureRandom.getSunProvider());
        }

        private static Provider getSunProvider() {
            try {
                Class<?> clazz = Class.forName("sun.security.jca.Providers");
                Method method = clazz.getMethod("getSunProvider", new Class[0]);
                return (Provider)method.invoke(clazz, new Object[0]);
            }
            catch (Exception exception) {
                return new Sun();
            }
        }
    }

    private static class EntropyDaemon
    implements Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();

        private EntropyDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTask(Runnable runnable) {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.add(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                Runnable runnable;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    runnable = this.tasks.poll();
                }
                if (runnable != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class HybridEntropySource
    implements EntropySource {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final FipsSecureRandom drbg;
        private final SignallingEntropySource entropySource;
        private final int bytesRequired;

        HybridEntropySource(EntropyDaemon entropyDaemon, int n) {
            java.security.SecureRandom secureRandom = BouncyCastleFipsProvider.getCoreSecureRandom();
            this.bytesRequired = (n + 7) / 8;
            this.entropySource = new SignallingEntropySource(entropyDaemon, this.seedAvailable, secureRandom, 256);
            this.drbg = FipsDRBG.SHA512.fromEntropySource(new EntropySourceProvider(){

                public EntropySource get(int n) {
                    return HybridEntropySource.this.entropySource;
                }
            }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).build(secureRandom.generateSeed(32), false, null);
        }

        public boolean isPredictionResistant() {
            return true;
        }

        public byte[] getEntropy() {
            byte[] byArray = new byte[this.bytesRequired];
            if (this.samples.getAndIncrement() > 20) {
                if (this.seedAvailable.getAndSet(false)) {
                    this.samples.set(0);
                    this.drbg.reseed();
                } else {
                    this.entropySource.schedule();
                }
            }
            this.drbg.nextBytes(byArray);
            return byArray;
        }

        public int entropySize() {
            return this.bytesRequired * 8;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntropyGatherer
        implements Runnable {
            private final int numBytes;
            private final java.security.SecureRandom baseRandom;
            private final AtomicBoolean seedAvailable;
            private final AtomicReference<byte[]> entropy;

            EntropyGatherer(int n, java.security.SecureRandom secureRandom, AtomicBoolean atomicBoolean, AtomicReference<byte[]> atomicReference) {
                this.numBytes = n;
                this.baseRandom = secureRandom;
                this.seedAvailable = atomicBoolean;
                this.entropy = atomicReference;
            }

            private void sleep(long l) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void run() {
                byte[] byArray;
                int n;
                long l;
                String string = Properties.getPropertyValue("org.bouncycastle.drbg.gather_pause_secs");
                if (string != null) {
                    try {
                        l = Long.parseLong(string) * 1000L;
                    }
                    catch (Exception exception) {
                        l = 5000L;
                    }
                } else {
                    l = 5000L;
                }
                byte[] byArray2 = new byte[this.numBytes];
                for (n = 0; n < this.numBytes / 8; ++n) {
                    this.sleep(l);
                    byArray = this.baseRandom.generateSeed(8);
                    System.arraycopy(byArray, 0, byArray2, n * 8, byArray.length);
                }
                n = this.numBytes - this.numBytes / 8 * 8;
                if (n != 0) {
                    this.sleep(l);
                    byArray = this.baseRandom.generateSeed(n);
                    System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
                }
                this.entropy.set(byArray2);
                this.seedAvailable.set(true);
            }
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final EntropyDaemon entropyDaemon;
            private final AtomicBoolean seedAvailable;
            private final java.security.SecureRandom baseRandom;
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(EntropyDaemon entropyDaemon, AtomicBoolean atomicBoolean, java.security.SecureRandom secureRandom, int n) {
                this.entropyDaemon = entropyDaemon;
                this.seedAvailable = atomicBoolean;
                this.baseRandom = secureRandom;
                this.byteLength = (n + 7) / 8;
            }

            public boolean isPredictionResistant() {
                return true;
            }

            public byte[] getEntropy() {
                byte[] byArray = this.entropy.getAndSet(null);
                if (byArray == null || byArray.length != this.byteLength) {
                    byArray = this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                this.schedule();
                return byArray;
            }

            void schedule() {
                if (!this.scheduled.getAndSet(true)) {
                    this.entropyDaemon.addTask(new EntropyGatherer(this.byteLength, this.baseRandom, this.seedAvailable, this.entropy));
                }
            }

            public int entropySize() {
                return this.byteLength * 8;
            }
        }
    }

    private class PooledSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<java.security.SecureRandom>[] providerDefaultRandom;
        private final AtomicInteger providerDefaultRandomCount;

        PooledSecureRandomProvider() {
            this.providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.this.providerRandomPoolSize];
            this.providerDefaultRandomCount = new AtomicInteger(0);
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public java.security.SecureRandom get() {
            int n = this.providerDefaultRandomCount.getAndSet((this.providerDefaultRandomCount.get() + 1) % this.providerDefaultRandom.length);
            if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
            AtomicReference<java.security.SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.providerDefaultRandom[n].compareAndSet(null, BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString(n)).build(entropySource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[n].get();
            }
        }
    }

    private class ThreadLocalSecureRandomProvider
    implements SecureRandomProvider {
        final ThreadLocal<FipsSecureRandom> defaultRandoms = new ThreadLocal();

        private ThreadLocalSecureRandomProvider() {
        }

        public java.security.SecureRandom get() {
            if (this.defaultRandoms.get() == null) {
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.defaultRandoms.set(BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString((int)Thread.currentThread().getId())).build(entropySource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
            }
            return this.defaultRandoms.get();
        }
    }
}

