/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class RegisteredDomainProcessor
extends AbstractProcessor {
    public static final String TYPE = "registered_domain";
    private static final PublicSuffixMatcher SUFFIX_MATCHER = PublicSuffixMatcherLoader.getDefault();
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;

    RegisteredDomainProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public boolean getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument document) throws Exception {
        String fqdn = (String)document.getFieldValue(this.field, String.class, this.ignoreMissing);
        DomainInfo info = RegisteredDomainProcessor.getRegisteredDomain(fqdn);
        if (info == null) {
            if (this.ignoreMissing) {
                return document;
            }
            throw new IllegalArgumentException("unable to set domain information for document");
        }
        Object fieldPrefix = this.targetField;
        if (!((String)fieldPrefix).isEmpty()) {
            fieldPrefix = (String)fieldPrefix + ".";
        }
        String domainTarget = (String)fieldPrefix + "domain";
        String registeredDomainTarget = (String)fieldPrefix + TYPE;
        String subdomainTarget = (String)fieldPrefix + "subdomain";
        String topLevelDomainTarget = (String)fieldPrefix + "top_level_domain";
        if (info.domain() != null) {
            document.setFieldValue(domainTarget, (Object)info.domain());
        }
        if (info.registeredDomain() != null) {
            document.setFieldValue(registeredDomainTarget, (Object)info.registeredDomain());
        }
        if (info.eTLD() != null) {
            document.setFieldValue(topLevelDomainTarget, (Object)info.eTLD());
        }
        if (info.subdomain() != null) {
            document.setFieldValue(subdomainTarget, (Object)info.subdomain());
        }
        return document;
    }

    @Nullable
    static DomainInfo getRegisteredDomain(@Nullable String fqdn) {
        if (!Strings.hasText((String)fqdn)) {
            return null;
        }
        String registeredDomain = SUFFIX_MATCHER.getDomainRoot(fqdn);
        if (registeredDomain == null) {
            if (SUFFIX_MATCHER.matches(fqdn)) {
                return DomainInfo.of(fqdn);
            }
            return null;
        }
        if (registeredDomain.indexOf(46) == -1) {
            return null;
        }
        return DomainInfo.of(registeredDomain, fqdn);
    }

    public String getType() {
        return TYPE;
    }

    record DomainInfo(String domain, String registeredDomain, String eTLD, String subdomain) {
        static DomainInfo of(String eTLD) {
            return new DomainInfo(eTLD, null, eTLD, null);
        }

        static DomainInfo of(String registeredDomain, String domain) {
            int index = registeredDomain.indexOf(46) + 1;
            if (index > 0 && index < registeredDomain.length()) {
                int subdomainIndex = domain.lastIndexOf("." + registeredDomain);
                String subdomain = subdomainIndex > 0 ? domain.substring(0, subdomainIndex) : null;
                return new DomainInfo(domain, registeredDomain, registeredDomain.substring(index), subdomain);
            }
            return new DomainInfo(null, null, null, null);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final String DEFAULT_TARGET_FIELD = "";

        public RegisteredDomainProcessor create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)RegisteredDomainProcessor.TYPE, (String)tag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)RegisteredDomainProcessor.TYPE, (String)tag, config, (String)"target_field", (String)DEFAULT_TARGET_FIELD);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RegisteredDomainProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)true);
            return new RegisteredDomainProcessor(tag, description, field, targetField, ignoreMissing);
        }
    }
}

