/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;

public class NullIfProcessor
implements Processor {
    public static final String NAME = "nni";
    private final Processor leftProcessor;
    private final Processor rightProcessor;

    public NullIfProcessor(Processor leftProcessor, Processor rightProcessor) {
        this.leftProcessor = leftProcessor;
        this.rightProcessor = rightProcessor;
    }

    public NullIfProcessor(StreamInput in) throws IOException {
        this.leftProcessor = (Processor)in.readNamedWriteable(Processor.class);
        this.rightProcessor = (Processor)in.readNamedWriteable(Processor.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.leftProcessor);
        out.writeNamedWriteable((NamedWriteable)this.rightProcessor);
    }

    public Object process(Object input) {
        Object leftValue = this.leftProcessor.process(input);
        Object rightValue = this.rightProcessor.process(input);
        return NullIfProcessor.apply(leftValue, rightValue);
    }

    public static Object apply(Object leftValue, Object rightValue) {
        if (BinaryComparisonProcessor.BinaryComparisonOperation.EQ.apply(leftValue, rightValue) == Boolean.TRUE) {
            return null;
        }
        return leftValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullIfProcessor that = (NullIfProcessor)o;
        return Objects.equals(this.leftProcessor, that.leftProcessor) && Objects.equals(this.rightProcessor, that.rightProcessor);
    }

    public int hashCode() {
        return Objects.hash(this.leftProcessor, this.rightProcessor);
    }
}

