/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public abstract class ConditionalFunction
extends ScalarFunction {
    protected DataType dataType = null;

    ConditionalFunction(Source source, List<Expression> fields) {
        super(source, fields);
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = DataTypes.NULL;
            for (Expression exp : this.children()) {
                this.dataType = SqlDataTypeConverter.commonType(this.dataType, exp.dataType());
            }
        }
        return this.dataType;
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    protected Expression.TypeResolution resolveType() {
        DataType dt = DataTypes.NULL;
        for (int i = 0; i < this.children().size(); ++i) {
            Expression child = (Expression)this.children().get(i);
            if (dt == DataTypes.NULL) {
                if (Expressions.isNull((Expression)child)) continue;
                dt = child.dataType();
                continue;
            }
            if (SqlDataTypes.areCompatible(dt, child.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal((int)(i + 1)), this.sourceText(), dt.typeName(), Expressions.name((Expression)child), child.dataType().typeName()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConditionalFunction that = (ConditionalFunction)((Object)o);
        return this.children().equals(that.children());
    }

    public int hashCode() {
        return Objects.hash(this.children());
    }
}

