/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.JulianFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;

class ToCharFormatter {
    protected static final Map<String, ToCharFormatter> FORMATTER_MAP;
    private static final int MAX_TO_CHAR_FORMAT_STRING_LENGTH;
    private static final String[] ROMAN_NUMBERS;
    private final String pattern;
    private final boolean acceptsLowercase;
    private final Function<String, String> fillModeFn;
    private final boolean hasOrdinalSuffix;
    private final Function<TemporalAccessor, String> formatter;

    private ToCharFormatter(String pattern, boolean acceptsLowercase, Function<String, String> fillModeFn, boolean hasOrdinalSuffix, Function<TemporalAccessor, String> formatter) {
        this.pattern = pattern;
        this.acceptsLowercase = acceptsLowercase;
        this.fillModeFn = fillModeFn;
        this.hasOrdinalSuffix = hasOrdinalSuffix;
        this.formatter = formatter;
    }

    private static Builder of(String pattern) {
        return new Builder(pattern);
    }

    private static String monthToRoman(int month) {
        return ROMAN_NUMBERS[month - 1];
    }

    private static int yearToCentury(int year) {
        int offset = -1;
        if (year > 0) {
            offset = year % 100 == 0 ? 0 : 1;
        }
        return year / 100 + offset;
    }

    private String format(TemporalAccessor temporalAccessor) {
        return this.formatter.apply(temporalAccessor);
    }

    private ToCharFormatter withModifier(Function<String, String> modifier) {
        return new ToCharFormatter(this.pattern, this.acceptsLowercase, this.fillModeFn, this.hasOrdinalSuffix, this.formatter.andThen(modifier));
    }

    private static List<ToCharFormatter> parsePattern(String toCharPattern) {
        LinkedList<ToCharFormatter> formatters = new LinkedList<ToCharFormatter>();
        while (!toCharPattern.isEmpty()) {
            ToCharFormatter formatter = null;
            boolean fillModeModifierActive = false;
            if (toCharPattern.startsWith("FM") || toCharPattern.startsWith("fm")) {
                fillModeModifierActive = true;
                toCharPattern = toCharPattern.substring(2);
            }
            for (int length = Math.min(MAX_TO_CHAR_FORMAT_STRING_LENGTH, toCharPattern.length()); length >= 1; --length) {
                String potentialPattern = toCharPattern.substring(0, length);
                formatter = FORMATTER_MAP.get(potentialPattern);
                if (formatter == null) continue;
                if (fillModeModifierActive && formatter.fillModeFn != null) {
                    formatter = formatter.withModifier(formatter.fillModeFn);
                }
                toCharPattern = toCharPattern.substring(length);
                break;
            }
            if (formatter == null) {
                formatter = ToCharFormatter.literal(toCharPattern.substring(0, 1));
                toCharPattern = toCharPattern.substring(1);
            } else if (toCharPattern.startsWith("TH") || toCharPattern.startsWith("th")) {
                String ordinalSuffixModifier = toCharPattern.substring(0, 2);
                if (formatter.hasOrdinalSuffix) {
                    formatter = formatter.withModifier(s -> ToCharFormatter.appendOrdinalSuffix(ordinalSuffixModifier, s));
                }
                toCharPattern = toCharPattern.substring(2);
            }
            formatters.addLast(formatter);
        }
        return formatters;
    }

    public static Function<TemporalAccessor, String> ofPattern(String pattern) {
        if (Strings.isEmpty((CharSequence)pattern)) {
            return timestamp -> "";
        }
        List<ToCharFormatter> toCharFormatters = ToCharFormatter.parsePattern(pattern);
        return timestamp -> toCharFormatters.stream().map(p -> p.format((TemporalAccessor)timestamp)).collect(Collectors.joining());
    }

    private static ToCharFormatter literal(String literal) {
        return new ToCharFormatter(literal, false, null, true, t -> literal);
    }

    private static String ordinalSuffix(int i) {
        if (i < 0) {
            i = -i;
        }
        int mod100 = i % 100;
        int mod10 = i % 10;
        if (mod10 == 1 && mod100 != 11) {
            return "st";
        }
        if (mod10 == 2 && mod100 != 12) {
            return "nd";
        }
        if (mod10 == 3 && mod100 != 13) {
            return "rd";
        }
        return "th";
    }

    private static String appendOrdinalSuffix(String defaultSuffix, String s) {
        try {
            int i = Integer.parseInt(ToCharFormatter.lastNCharacter(s, 3));
            boolean upperCase = defaultSuffix.equals(defaultSuffix.toUpperCase(Locale.ENGLISH));
            return s + (upperCase ? ToCharFormatter.ordinalSuffix(i).toUpperCase(Locale.ENGLISH) : ToCharFormatter.ordinalSuffix(i));
        }
        catch (NumberFormatException ex) {
            return s + defaultSuffix;
        }
    }

    private static String formatOffset(String offset) {
        if (((String)offset).equals("Z")) {
            return "+00";
        }
        if (((String)offset).matches("^[+-][0-9][0-9]00$")) {
            offset = ((String)offset).substring(0, ((String)offset).length() - 2);
        } else if (((String)offset).matches("^[+-][0-9]{3,4}$")) {
            offset = ((String)offset).substring(0, ((String)offset).length() - 2) + ":" + ((String)offset).substring(((String)offset).length() - 2);
        } else if (((String)offset).matches("^[+-][0-9][0-9]:00$")) {
            offset = ((String)offset).substring(0, ((String)offset).length() - 3);
        }
        return ((String)offset).substring(0, Math.min(((String)offset).length(), 6));
    }

    private static String removeLeadingZerosFromOffset(String offset) {
        if (offset.matches("[+-]0{1,2}")) {
            return offset.substring(0, 2);
        }
        if (offset.startsWith("+0")) {
            return "+" + offset.substring(2);
        }
        if (offset.startsWith("-0")) {
            return "-" + offset.substring(2);
        }
        return offset;
    }

    private static String absoluteWeekBasedYear(TemporalAccessor t) {
        int year = t.get(IsoFields.WEEK_BASED_YEAR);
        year = year > 0 ? year : -(year - 1);
        return String.format(Locale.ENGLISH, "%04d", year);
    }

    private static String firstDigitsOfNanos(String nano, int digits) {
        return String.format(Locale.ENGLISH, "%09d", Integer.parseInt(nano)).substring(0, digits);
    }

    private static String lastNCharacter(String s, int n) {
        return s.substring(Math.max(0, s.length() - n));
    }

    private static String zoneAbbreviationOf(TemporalAccessor temporalAccessor) {
        String zone = ZoneId.from(temporalAccessor).getDisplayName(TextStyle.SHORT, Locale.ENGLISH);
        return "Z".equals(zone) ? "UTC" : zone;
    }

    static {
        List<ToCharFormatter> formatters = List.of(ToCharFormatter.of("HH").formatFn("hh").numeric(), ToCharFormatter.of("HH12").formatFn("hh").numeric(), ToCharFormatter.of("HH24").formatFn("HH").numeric(), ToCharFormatter.of("MI").formatFn("mm").numeric(), ToCharFormatter.of("SS").formatFn("s", x -> String.format(Locale.ENGLISH, "%02d", Integer.parseInt(x))).numeric(), ToCharFormatter.of("MS").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 3)).numericWithLeadingZeros(), ToCharFormatter.of("US").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 6)).numericWithLeadingZeros(), ToCharFormatter.of("FF1").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 1)).numericWithLeadingZeros(), ToCharFormatter.of("FF2").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 2)).numericWithLeadingZeros(), ToCharFormatter.of("FF3").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 3)).numericWithLeadingZeros(), ToCharFormatter.of("FF4").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 4)).numericWithLeadingZeros(), ToCharFormatter.of("FF5").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 5)).numericWithLeadingZeros(), ToCharFormatter.of("FF6").formatFn("n", nano -> ToCharFormatter.firstDigitsOfNanos(nano, 6)).numericWithLeadingZeros(), ToCharFormatter.of("SSSSS").formatFn("A", milliSecondOfDay -> String.valueOf(Integer.parseInt(milliSecondOfDay) / 1000)).numeric(), ToCharFormatter.of("SSSS").formatFn("A", milliSecondOfDay -> String.valueOf(Integer.parseInt(milliSecondOfDay) / 1000)).numeric(), ToCharFormatter.of("AM").formatFn("a", x -> x.toUpperCase(Locale.ENGLISH)).text(), ToCharFormatter.of("am").formatFn("a", x -> x.toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("PM").formatFn("a", x -> x.toUpperCase(Locale.ENGLISH)).text(), ToCharFormatter.of("pm").formatFn("a", x -> x.toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("A.M.").formatFn("a", x -> x.charAt(0) + "." + x.charAt(1) + ".").text(), ToCharFormatter.of("a.m.").formatFn("a", x -> (x.charAt(0) + "." + x.charAt(1) + ".").toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("P.M.").formatFn("a", x -> x.charAt(0) + "." + x.charAt(1) + ".").text(), ToCharFormatter.of("p.m.").formatFn("a", x -> (x.charAt(0) + "." + x.charAt(1) + ".").toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("Y,YYY").formatFn("yyyy", year -> year.charAt(0) + "," + year.substring(1)).numericWithLeadingZeros(), ToCharFormatter.of("YYYY").formatFn("yyyy").numeric(), ToCharFormatter.of("YYY").formatFn("yyyy", year -> year.substring(1)).numeric(), ToCharFormatter.of("YY").formatFn("yy").numeric(), ToCharFormatter.of("Y").formatFn("yy", year -> year.substring(1)).numeric(), ToCharFormatter.of("IYYY").formatFn(t -> ToCharFormatter.lastNCharacter(ToCharFormatter.absoluteWeekBasedYear(t), 4)).numeric(), ToCharFormatter.of("IYY").formatFn(t -> ToCharFormatter.lastNCharacter(ToCharFormatter.absoluteWeekBasedYear(t), 3)).numeric(), ToCharFormatter.of("IY").formatFn(t -> ToCharFormatter.lastNCharacter(ToCharFormatter.absoluteWeekBasedYear(t), 2)).numeric(), ToCharFormatter.of("I").formatFn(t -> ToCharFormatter.lastNCharacter(ToCharFormatter.absoluteWeekBasedYear(t), 1)).numeric(), ToCharFormatter.of("BC").formatFn("G").text(), ToCharFormatter.of("bc").formatFn("G", x -> x.toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("AD").formatFn("G").text(), ToCharFormatter.of("ad").formatFn("G", x -> x.toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("B.C.").formatFn("G", x -> x.charAt(0) + "." + x.charAt(1) + ".").text(), ToCharFormatter.of("b.c.").formatFn("G", x -> (x.charAt(0) + "." + x.charAt(1) + ".").toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("A.D.").formatFn("G", x -> x.charAt(0) + "." + x.charAt(1) + ".").text(), ToCharFormatter.of("a.d.").formatFn("G", x -> (x.charAt(0) + "." + x.charAt(1) + ".").toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("MONTH").formatFn("MMMM", x -> String.format(Locale.ENGLISH, "%-9s", x.toUpperCase(Locale.ENGLISH))).text(), ToCharFormatter.of("Month").formatFn("MMMM", x -> String.format(Locale.ENGLISH, "%-9s", x)).text(), ToCharFormatter.of("month").formatFn("MMMM", x -> String.format(Locale.ENGLISH, "%-9s", x.toLowerCase(Locale.ENGLISH))).text(), ToCharFormatter.of("MON").formatFn("MMM", x -> x.toUpperCase(Locale.ENGLISH)).text(), ToCharFormatter.of("Mon").formatFn("MMM").text(), ToCharFormatter.of("mon").formatFn("MMM", x -> x.toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("MM").formatFn("MM").numeric(), ToCharFormatter.of("DAY").formatFn("EEEE", x -> String.format(Locale.ENGLISH, "%-9s", x.toUpperCase(Locale.ENGLISH))).text(), ToCharFormatter.of("Day").formatFn("EEEE", x -> String.format(Locale.ENGLISH, "%-9s", x)).text(), ToCharFormatter.of("day").formatFn("EEEE", x -> String.format(Locale.ENGLISH, "%-9s", x.toLowerCase(Locale.ENGLISH))).text(), ToCharFormatter.of("DY").formatFn("E", x -> x.toUpperCase(Locale.ENGLISH)).text(), ToCharFormatter.of("Dy").formatFn("E").text(), ToCharFormatter.of("dy").formatFn("E", x -> x.toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("DDD").formatFn("DDD").numeric(), ToCharFormatter.of("IDDD").formatFn(t -> String.format(Locale.ENGLISH, "%03d", (t.get(WeekFields.ISO.weekOfWeekBasedYear()) - 1) * 7 + t.get(ChronoField.DAY_OF_WEEK))).numeric(), ToCharFormatter.of("DD").formatFn("d", x -> String.format(Locale.ENGLISH, "%02d", Integer.parseInt(x))).numeric(), ToCharFormatter.of("ID").formatFn(t -> String.valueOf(t.get(ChronoField.DAY_OF_WEEK))).numeric(), ToCharFormatter.of("D").formatFn(t -> String.valueOf(t.get(WeekFields.SUNDAY_START.dayOfWeek()))).numeric(), ToCharFormatter.of("W").formatFn(t -> String.valueOf(t.get(ChronoField.ALIGNED_WEEK_OF_MONTH))).numeric(), ToCharFormatter.of("WW").formatFn(t -> String.format(Locale.ENGLISH, "%02d", t.get(ChronoField.ALIGNED_WEEK_OF_YEAR))).numeric(), ToCharFormatter.of("IW").formatFn(t -> String.format(Locale.ENGLISH, "%02d", t.get(WeekFields.ISO.weekOfWeekBasedYear()))).numeric(), ToCharFormatter.of("CC").formatFn(t -> {
            int century = ToCharFormatter.yearToCentury(t.get(ChronoField.YEAR));
            return String.format(Locale.ENGLISH, century < 0 ? "%03d" : "%02d", century);
        }).numeric(), ToCharFormatter.of("J").formatFn(t -> String.valueOf(t.getLong(JulianFields.JULIAN_DAY))).numeric(), ToCharFormatter.of("Q").formatFn("Q").numeric(), ToCharFormatter.of("RM").formatFn("MM", month -> String.format(Locale.ENGLISH, "%-4s", ToCharFormatter.monthToRoman(Integer.parseInt(month)))).text(), ToCharFormatter.of("rm").formatFn("MM", month -> String.format(Locale.ENGLISH, "%-4s", ToCharFormatter.monthToRoman(Integer.parseInt(month)).toLowerCase(Locale.ENGLISH))).text(), ToCharFormatter.of("TZ").formatFn(ToCharFormatter::zoneAbbreviationOf).text(), ToCharFormatter.of("tz").formatFn(t -> ToCharFormatter.zoneAbbreviationOf(t).toLowerCase(Locale.ENGLISH)).text(), ToCharFormatter.of("TZH").acceptsLowercase(false).formatFn("ZZ", s -> s.substring(0, 3)).text(), ToCharFormatter.of("TZM").acceptsLowercase(false).formatFn("ZZ", s -> ToCharFormatter.lastNCharacter(s, 2)).text(), ToCharFormatter.of("OF").acceptsLowercase(false).formatFn("ZZZZZ", ToCharFormatter::formatOffset).offset());
        LinkedHashMap<String, ToCharFormatter> formatterMap = new LinkedHashMap<String, ToCharFormatter>();
        for (ToCharFormatter formatter : formatters) {
            formatterMap.put(formatter.pattern, formatter);
        }
        for (ToCharFormatter formatter : formatters) {
            if (!formatter.acceptsLowercase) continue;
            formatterMap.putIfAbsent(formatter.pattern.toLowerCase(Locale.ENGLISH), formatter);
        }
        FORMATTER_MAP = formatterMap;
        MAX_TO_CHAR_FORMAT_STRING_LENGTH = FORMATTER_MAP.keySet().stream().mapToInt(String::length).max().orElse(Integer.MAX_VALUE);
        ROMAN_NUMBERS = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};
    }

    private static class Builder {
        private final String pattern;
        private boolean lowercaseAccepted = true;
        private Function<TemporalAccessor, String> formatFn;

        Builder(String pattern) {
            this.pattern = pattern;
        }

        public Builder formatFn(String javaPattern) {
            return this.formatFn(javaPattern, null);
        }

        public Builder formatFn(String javaPattern, Function<String, String> additionalMapper) {
            this.formatFn = temporalAccessor -> {
                String formatted = DateTimeFormatter.ofPattern((String)(javaPattern != null ? javaPattern : "'" + this.pattern + "'"), Locale.ENGLISH).format((TemporalAccessor)temporalAccessor);
                return additionalMapper == null ? formatted : (String)additionalMapper.apply(formatted);
            };
            return this;
        }

        public Builder formatFn(Function<TemporalAccessor, String> formatFn) {
            this.formatFn = formatFn;
            return this;
        }

        public ToCharFormatter numeric() {
            return this.build(number -> String.valueOf(Integer.parseInt(number)), true);
        }

        public ToCharFormatter numericWithLeadingZeros() {
            return this.build(null, true);
        }

        public ToCharFormatter text() {
            return this.build(paddedText -> paddedText.replaceAll(" +$", ""), false);
        }

        public ToCharFormatter offset() {
            return this.build(ToCharFormatter::removeLeadingZerosFromOffset, false);
        }

        public Builder acceptsLowercase(boolean lowercaseAccepted) {
            this.lowercaseAccepted = lowercaseAccepted;
            return this;
        }

        private ToCharFormatter build(Function<String, String> fillModeFn, boolean hasOrdinalSuffix) {
            return new ToCharFormatter(this.pattern, this.lowercaseAccepted, fillModeFn, hasOrdinalSuffix, this.formatFn);
        }
    }
}

