/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.ssl.SslConfiguration;

public record TLSConfig(SslConfiguration sslConfiguration, EngineProvider engineProvider) {
    public boolean isTLSEnabled() {
        return this.sslConfiguration != null;
    }

    public SSLEngine createServerSSLEngine() {
        assert (this.isTLSEnabled());
        SSLEngine sslEngine = this.engineProvider.create(this.sslConfiguration, null, -1);
        sslEngine.setUseClientMode(false);
        return sslEngine;
    }

    public static TLSConfig noTLS() {
        return new TLSConfig(null, null);
    }

    @FunctionalInterface
    public static interface EngineProvider {
        public SSLEngine create(SslConfiguration var1, String var2, int var3);
    }
}

