/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;

public class FluxInputStream
extends InputStream {
    private static final ClientLogger LOGGER = new ClientLogger(FluxInputStream.class);
    private Flux<ByteBuffer> data;
    private Subscription subscription;
    private ByteArrayInputStream buffer;
    private boolean subscribed = false;
    private boolean fluxComplete = false;
    private boolean waitingForData = false;
    private final Lock lock;
    private final Condition dataAvailable;
    private IOException lastError;

    public FluxInputStream(Flux<ByteBuffer> data) {
        this.data = data;
        this.lock = new ReentrantLock();
        this.dataAvailable = this.lock.newCondition();
    }

    @Override
    public int read() throws IOException {
        byte[] ret = new byte[1];
        int count = this.read(ret, 0, 1);
        return count == -1 ? -1 : ret[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.validateParameters(b, off, len);
        if (len == 0) {
            return 0;
        }
        if (!this.subscribed) {
            this.blockForData();
        }
        if (this.buffer == null) {
            if (this.lastError != null) {
                throw (IOException)LOGGER.logThrowableAsError((Throwable)this.lastError);
            }
            if (this.fluxComplete) {
                return -1;
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("An unexpected error occurred. No data was read from the stream but the stream did not indicate completion."));
        }
        if (this.buffer.available() == 0) {
            if (this.fluxComplete) {
                return -1;
            }
            this.blockForData();
        }
        if (this.buffer.available() > 0) {
            return this.buffer.read(b, off, len);
        }
        if (this.fluxComplete) {
            return -1;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("An unexpected error occurred. No data was read from the stream but the stream did not indicate completion."));
    }

    @Override
    public void close() throws IOException {
        this.subscription.cancel();
        if (this.buffer != null) {
            this.buffer.close();
        }
        super.close();
        if (this.lastError != null) {
            throw (IOException)LOGGER.logThrowableAsError((Throwable)this.lastError);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void blockForData() {
        this.lock.lock();
        try {
            this.waitingForData = true;
            if (!this.subscribed) {
                this.subscribeToData();
            } else {
                this.subscription.request(1L);
            }
            while (this.waitingForData) {
                if (this.fluxComplete) {
                    return;
                }
                try {
                    this.dataAvailable.await();
                }
                catch (InterruptedException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(e));
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void subscribeToData() {
        this.data.filter(Buffer::hasRemaining).onBackpressureBuffer().subscribe(byteBuffer -> {
            this.buffer = new ByteArrayInputStream(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
            this.lock.lock();
            try {
                this.waitingForData = false;
                this.dataAvailable.signal();
            }
            finally {
                this.lock.unlock();
            }
        }, throwable -> {
            this.lastError = throwable instanceof IOException ? (IOException)throwable : new IOException((Throwable)throwable);
            this.signalOnCompleteOrError();
        }, this::signalOnCompleteOrError, subscription -> {
            this.subscription = subscription;
            this.subscribed = true;
            this.subscription.request(1L);
        });
    }

    private void signalOnCompleteOrError() {
        this.fluxComplete = true;
        this.lock.lock();
        try {
            this.waitingForData = false;
            this.dataAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void validateParameters(byte[] b, int off, int len) {
        if (b == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'b' cannot be null"));
        }
        if (off < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException("'off' cannot be less than 0"));
        }
        if (len < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException("'len' cannot be less than 0"));
        }
        if (len > b.length - off) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException("'len' cannot be greater than 'b'.length - 'off'"));
        }
    }
}

