/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.Closeable;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.scheduler.CronSchedule;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;

public class SnapshotRetentionService
implements LocalNodeMasterListener,
Closeable {
    static final String SLM_RETENTION_JOB_ID = "slm-retention-job";
    static final String SLM_RETENTION_MANUAL_JOB_ID = "slm-execute-manual-retention-job";
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionService.class);
    private final SchedulerEngine scheduler;
    private final SnapshotRetentionTask retentionTask;
    private final Clock clock;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private volatile String slmRetentionSchedule;
    private volatile boolean isMaster = false;

    public SnapshotRetentionService(Settings settings, Supplier<SnapshotRetentionTask> taskSupplier, Clock clock) {
        this.clock = clock;
        this.scheduler = new SchedulerEngine(settings, clock);
        this.retentionTask = taskSupplier.get();
        this.scheduler.register((SchedulerEngine.Listener)this.retentionTask);
        this.slmRetentionSchedule = (String)LifecycleSettings.SLM_RETENTION_SCHEDULE_SETTING.get(settings);
    }

    public void init(ClusterService clusterService) {
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LifecycleSettings.SLM_RETENTION_SCHEDULE_SETTING, this::setUpdateSchedule);
    }

    void setUpdateSchedule(String retentionSchedule) {
        this.slmRetentionSchedule = retentionSchedule;
        this.rescheduleRetentionJob();
    }

    SchedulerEngine getScheduler() {
        return this.scheduler;
    }

    public void onMaster() {
        this.isMaster = true;
        this.rescheduleRetentionJob();
    }

    public void offMaster() {
        this.isMaster = false;
        this.cancelRetentionJob();
    }

    private void rescheduleRetentionJob() {
        String schedule = this.slmRetentionSchedule;
        if (this.running.get() && this.isMaster && Strings.hasText((String)schedule)) {
            SchedulerEngine.Job retentionJob = new SchedulerEngine.Job(SLM_RETENTION_JOB_ID, (SchedulerEngine.Schedule)new CronSchedule(schedule));
            logger.debug("scheduling SLM retention job for [{}]", (Object)schedule);
            this.scheduler.add(retentionJob);
        } else {
            this.cancelRetentionJob();
        }
    }

    private void cancelRetentionJob() {
        this.scheduler.scheduledJobIds().forEach(arg_0 -> ((SchedulerEngine)this.scheduler).remove(arg_0));
    }

    public void triggerRetention() {
        if (this.isMaster) {
            long now = this.clock.millis();
            this.retentionTask.triggered(new SchedulerEngine.Event(SLM_RETENTION_MANUAL_JOB_ID, now, now));
        }
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            this.scheduler.stop();
        }
    }
}

