/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.ql.tree.Source;

public class ScriptQuery
extends LeafQuery {
    private final ScriptTemplate script;

    public ScriptQuery(Source source, ScriptTemplate script) {
        super(source);
        this.script = this.nullSafeScript(script);
    }

    public ScriptTemplate script() {
        return this.script;
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.scriptQuery((Script)this.script.toPainless());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.script);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptQuery other = (ScriptQuery)obj;
        return Objects.equals(this.script, other.script);
    }

    @Override
    protected String innerToString() {
        return this.script.toString();
    }

    protected ScriptTemplate nullSafeScript(ScriptTemplate scriptTemplate) {
        return Scripts.nullSafeFilter(scriptTemplate);
    }
}

