/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.format;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.LongFunction;

public enum NumberStyle {
    CURRENCY,
    GENERAL,
    INTEGER,
    PERCENT,
    SCIENTIFIC;


    public static LongFunction<String> newUniformFormatter(long rangeSize) {
        IntegerToUniformString formatter = new IntegerToUniformString(rangeSize);
        return formatter::toString;
    }

    public static String toUniformString(long value, long rangeSize) {
        int maxNumberOfDigits = IntegerToUniformString.numberOfDigits(rangeSize - 1L);
        return IntegerToUniformString.toStringWithFixedNumberOfDigits(value, maxNumberOfDigits);
    }

    public NumberFormat getFormat() {
        return this.getFormat(Locale.getDefault());
    }

    public NumberFormat getFormat(Locale locale) {
        switch (this) {
            case CURRENCY: {
                return NumberFormat.getCurrencyInstance(locale != null ? locale : Locale.getDefault());
            }
            case INTEGER: {
                return NumberFormat.getIntegerInstance(locale != null ? locale : Locale.getDefault());
            }
            case PERCENT: {
                return NumberFormat.getPercentInstance(locale != null ? locale : Locale.getDefault());
            }
        }
        return NumberFormat.getInstance(locale != null ? locale : Locale.getDefault());
    }

    static final class IntegerToUniformString {
        private static final String PADDING = "00000000000000000000";
        private final int myMaxNumberOfDigits;

        static int numberOfDigits(long number) {
            if (number == 0L) {
                return 1;
            }
            long nmbr = number;
            int count = 0;
            while (nmbr != 0L) {
                nmbr /= 10L;
                ++count;
            }
            return count;
        }

        static String toStringWithFixedNumberOfDigits(long value, int numberOfDigits) {
            String retVal = Long.toString(value);
            retVal = PADDING + retVal;
            return retVal.substring(retVal.length() - numberOfDigits);
        }

        IntegerToUniformString(long rangeSize) {
            this.myMaxNumberOfDigits = IntegerToUniformString.numberOfDigits(rangeSize - 1L);
        }

        public String toString(long value) {
            return IntegerToUniformString.toStringWithFixedNumberOfDigits(value, this.myMaxNumberOfDigits);
        }
    }
}

