/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class CollectionUtils {
    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static <T> List<T> combine(List<? extends T> left, List<? extends T> right) {
        if (right.isEmpty()) {
            return left;
        }
        if (left.isEmpty()) {
            return right;
        }
        ArrayList<T> list = new ArrayList<T>(left.size() + right.size());
        list.addAll(left);
        list.addAll(right);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> combine(Collection<? extends T> ... collections) {
        if (org.elasticsearch.common.util.CollectionUtils.isEmpty((Object[])collections)) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Collection<T> collection : collections) {
            if (collection instanceof Set) {
                for (T t : collection) {
                    list.add(t);
                }
                continue;
            }
            list.addAll(collection);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> combine(Collection<? extends T> left, T ... entries) {
        ArrayList<T> list = new ArrayList<T>(left.size() + entries.length);
        if (!left.isEmpty()) {
            list.addAll(left);
        }
        if (entries.length > 0) {
            Collections.addAll(list, entries);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> nullSafeList(T ... entries) {
        if (entries == null || entries.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(entries.length);
        for (T entry : entries) {
            if (entry == null) continue;
            list.add(entry);
        }
        return list;
    }
}

