/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic;

import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.inference.services.sagemaker.SageMakerInferenceRequest;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchemaPayload;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic.SageMakerElasticTaskSettings;
import software.amazon.awssdk.core.SdkBytes;

interface ElasticPayload
extends SageMakerSchemaPayload {
    public static final String API = "elastic";
    public static final String APPLICATION_JSON = JsonXContent.jsonXContent.type().mediaTypeWithoutParameters();
    public static final boolean IGNORE_UNKNOWN_FIELDS = false;

    @Override
    default public String api() {
        return API;
    }

    @Override
    default public String accept(SageMakerModel model) {
        return APPLICATION_JSON;
    }

    @Override
    default public String contentType(SageMakerModel model) {
        return APPLICATION_JSON;
    }

    @Override
    default public SdkBytes requestBytes(SageMakerModel model, SageMakerInferenceRequest request) throws Exception {
        SageMakerStoredTaskSchema sageMakerStoredTaskSchema = model.apiTaskSettings();
        if (sageMakerStoredTaskSchema instanceof SageMakerElasticTaskSettings) {
            SageMakerElasticTaskSettings elasticTaskSettings = (SageMakerElasticTaskSettings)sageMakerStoredTaskSchema;
            return SdkBytes.fromUtf8String((String)Strings.toString((builder, params) -> {
                if (request.input().size() > 1) {
                    builder.field(InferenceAction.Request.INPUT.getPreferredName(), request.input());
                } else {
                    builder.field(InferenceAction.Request.INPUT.getPreferredName(), request.input().get(0));
                }
                if (InputType.isSpecified((InputType)request.inputType())) {
                    String string = InferenceAction.Request.INPUT_TYPE.getPreferredName();
                    builder.field(string, (Enum)(switch (request.inputType()) {
                        case InputType.INGEST, InputType.INTERNAL_INGEST -> InputType.INGEST;
                        case InputType.SEARCH, InputType.INTERNAL_SEARCH -> InputType.SEARCH;
                        default -> request.inputType();
                    }));
                }
                if (request.query() != null) {
                    builder.field(InferenceAction.Request.QUERY.getPreferredName(), request.query());
                }
                if (!elasticTaskSettings.isEmpty()) {
                    builder.field(InferenceAction.Request.TASK_SETTINGS.getPreferredName());
                    if (elasticTaskSettings.isFragment()) {
                        builder.startObject();
                    }
                    builder.value((ToXContent)elasticTaskSettings);
                    if (elasticTaskSettings.isFragment()) {
                        builder.endObject();
                    }
                }
                return builder;
            }));
        }
        throw this.createUnsupportedSchemaException(model);
    }

    @Override
    default public SageMakerElasticTaskSettings apiTaskSettings(Map<String, Object> taskSettings, ValidationException validationException) {
        return SageMakerElasticTaskSettings.empty();
    }

    @Override
    default public Stream<NamedWriteableRegistry.Entry> namedWriteables() {
        return Stream.of(new NamedWriteableRegistry.Entry(SageMakerStoredTaskSchema.class, "sagemaker_elastic_task_settings", SageMakerElasticTaskSettings::new));
    }
}

