/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.io.IOException;
import java.util.Deque;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiUnifiedStreamingProcessor;

public class GoogleVertexAiStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, InferenceServiceResults.Result> {
    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        Deque results = GoogleVertexAiStreamingProcessor.parseEvent(item, GoogleVertexAiStreamingProcessor::parse, parserConfig);
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingChatCompletionResults.Results(results));
        }
    }

    public static Stream<StreamingChatCompletionResults.Result> parse(XContentParserConfiguration parserConfig, ServerSentEvent event) {
        Stream<StreamingChatCompletionResults.Result> stream;
        block8: {
            String data = event.data();
            XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);
            try {
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = GoogleVertexAiUnifiedStreamingProcessor.GoogleVertexAiChatCompletionChunkParser.parse(jsonParser);
                stream = chunk.choices().stream().map(choice -> choice.delta()).filter(Objects::nonNull).map(delta -> delta.content()).filter(content -> !Strings.isNullOrEmpty((String)content)).map(StreamingChatCompletionResults.Result::new);
                if (jsonParser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonParser != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchStatusException("Failed to parse event from inference provider: {}", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{event});
                }
            }
            jsonParser.close();
        }
        return stream;
    }
}

