/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.user.User;

public class InternalUser
extends User {
    private final Optional<RoleDescriptor> localClusterRoleDescriptor;
    private final Optional<RoleDescriptor> remoteAccessRoleDescriptor;

    InternalUser(String username, @Nullable RoleDescriptor localClusterRole) {
        this(username, Optional.ofNullable(localClusterRole), Optional.empty());
    }

    InternalUser(String username, Optional<RoleDescriptor> localClusterRole, Optional<RoleDescriptor> remoteAccessRole) {
        super(username, Strings.EMPTY_ARRAY);
        assert (this.enabled());
        assert (this.roles() != null && this.roles().length == 0);
        this.localClusterRoleDescriptor = Objects.requireNonNull(localClusterRole);
        this.localClusterRoleDescriptor.ifPresent(rd -> {
            assert (rd.getName().equals(username));
        });
        this.remoteAccessRoleDescriptor = Objects.requireNonNull(remoteAccessRole);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public Optional<RoleDescriptor> getLocalClusterRoleDescriptor() {
        return this.localClusterRoleDescriptor;
    }

    public Optional<RoleDescriptor> getRemoteAccessRoleDescriptor() {
        return this.remoteAccessRoleDescriptor;
    }
}

