/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Arrays;
import org.elasticsearch.common.Strings;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.RealmDomain;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.NamedClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class ManageOwnApiKeyClusterPrivilege
implements NamedClusterPrivilege {
    public static final ManageOwnApiKeyClusterPrivilege INSTANCE = new ManageOwnApiKeyClusterPrivilege();
    private static final String PRIVILEGE_NAME = "manage_own_api_key";
    private final ClusterPermission permission = this.buildPermission(ClusterPermission.builder()).build();

    private ManageOwnApiKeyClusterPrivilege() {
    }

    @Override
    public String name() {
        return PRIVILEGE_NAME;
    }

    @Override
    public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
        return builder.add(this, ManageOwnClusterPermissionCheck.INSTANCE);
    }

    @Override
    public ClusterPermission permission() {
        return this.permission;
    }

    private static final class ManageOwnClusterPermissionCheck
    extends ClusterPermission.ActionBasedPermissionCheck {
        public static final ManageOwnClusterPermissionCheck INSTANCE = new ManageOwnClusterPermissionCheck();

        private ManageOwnClusterPermissionCheck() {
            super(Automatons.patterns("cluster:admin/xpack/security/api_key/*"));
        }

        @Override
        protected boolean extendedCheck(String action, TransportRequest request, Authentication authentication) {
            if (request instanceof CreateApiKeyRequest) {
                return true;
            }
            if (request instanceof UpdateApiKeyRequest || request instanceof BulkUpdateApiKeyRequest) {
                return true;
            }
            if (request instanceof GetApiKeyRequest) {
                GetApiKeyRequest getApiKeyRequest = (GetApiKeyRequest)request;
                if (authentication.isApiKey() && getApiKeyRequest.withLimitedBy()) {
                    return false;
                }
                return ManageOwnClusterPermissionCheck.checkIfUserIsOwnerOfApiKeys(authentication, getApiKeyRequest.getApiKeyId(), getApiKeyRequest.getUserName(), getApiKeyRequest.getRealmName(), getApiKeyRequest.ownedByAuthenticatedUser());
            }
            if (request instanceof InvalidateApiKeyRequest) {
                InvalidateApiKeyRequest invalidateApiKeyRequest = (InvalidateApiKeyRequest)request;
                String[] apiKeyIds = invalidateApiKeyRequest.getIds();
                if (apiKeyIds == null) {
                    return ManageOwnClusterPermissionCheck.checkIfUserIsOwnerOfApiKeys(authentication, null, invalidateApiKeyRequest.getUserName(), invalidateApiKeyRequest.getRealmName(), invalidateApiKeyRequest.ownedByAuthenticatedUser());
                }
                return Arrays.stream(apiKeyIds).allMatch(id -> ManageOwnClusterPermissionCheck.checkIfUserIsOwnerOfApiKeys(authentication, id, invalidateApiKeyRequest.getUserName(), invalidateApiKeyRequest.getRealmName(), invalidateApiKeyRequest.ownedByAuthenticatedUser()));
            }
            if (request instanceof QueryApiKeyRequest) {
                QueryApiKeyRequest queryApiKeyRequest = (QueryApiKeyRequest)request;
                if (authentication.isApiKey() && queryApiKeyRequest.withLimitedBy()) {
                    return false;
                }
                return queryApiKeyRequest.isFilterForCurrentUser();
            }
            if (request instanceof GrantApiKeyRequest) {
                return false;
            }
            String message = "manage own api key privilege only supports API key requests (not " + request.getClass().getName() + ")";
            assert (false) : message;
            throw new IllegalArgumentException(message);
        }

        @Override
        protected boolean doImplies(ClusterPermission.ActionBasedPermissionCheck permissionCheck) {
            return permissionCheck instanceof ManageOwnClusterPermissionCheck;
        }

        private static boolean checkIfUserIsOwnerOfApiKeys(Authentication authentication, String apiKeyId, String username, String realmName, boolean ownedByAuthenticatedUser) {
            if (ManageOwnClusterPermissionCheck.isCurrentAuthenticationUsingSameApiKeyIdFromRequest(authentication, apiKeyId)) {
                return true;
            }
            if (authentication.isApiKey()) {
                return false;
            }
            if (ownedByAuthenticatedUser) {
                return true;
            }
            if (Strings.hasText((String)username) && Strings.hasText((String)realmName)) {
                if (!username.equals(authentication.getEffectiveSubject().getUser().principal())) {
                    return false;
                }
                RealmDomain domain = authentication.getEffectiveSubject().getRealm().getDomain();
                if (domain != null) {
                    return domain.realms().stream().anyMatch(realmIdentifier -> realmName.equals(realmIdentifier.getName()));
                }
                return realmName.equals(authentication.getEffectiveSubject().getRealm().getName());
            }
            return false;
        }

        private static boolean isCurrentAuthenticationUsingSameApiKeyIdFromRequest(Authentication authentication, String apiKeyId) {
            if (authentication.isApiKey()) {
                String authenticatedApiKeyId = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
                if (Strings.hasText((String)apiKeyId)) {
                    return apiKeyId.equals(authenticatedApiKeyId);
                }
            }
            return false;
        }
    }
}

