/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.lucene.util.CombinedBitSet;
import org.elasticsearch.lucene.util.MatchAllBitSet;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetBitsetCache;

public final class DocumentSubsetReader
extends SequentialStoredFieldsLeafReader {
    static final Map<IndexReader.CacheKey, Cache<Query, Integer>> NUM_DOCS_CACHE = new ConcurrentHashMap<IndexReader.CacheKey, Cache<Query, Integer>>();
    private final DocumentSubsetBitsetCache bitsetCache;
    private final Query roleQuery;
    private BitSet roleQueryBits;
    private volatile int numDocs = -1;

    public static DocumentSubsetDirectoryReader wrap(DirectoryReader in, DocumentSubsetBitsetCache bitsetCache, Query roleQuery) throws IOException {
        return new DocumentSubsetDirectoryReader(in, bitsetCache, roleQuery);
    }

    private static int computeNumDocs(LeafReader reader, BitSet roleQueryBits) {
        Bits liveDocs = reader.getLiveDocs();
        if (roleQueryBits == null) {
            return 0;
        }
        if (roleQueryBits instanceof MatchAllBitSet) {
            return reader.numDocs();
        }
        if (liveDocs == null) {
            return roleQueryBits.cardinality();
        }
        int numDocs = 0;
        BitSetIterator it = new BitSetIterator(roleQueryBits, 0L);
        try {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs.get(doc)) {
                    ++numDocs;
                }
                doc = it.nextDoc();
            }
            return numDocs;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int getNumDocs(LeafReader reader, Query roleQuery, BitSet roleQueryBits) throws IOException, ExecutionException {
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        if (cacheHelper == null) {
            return DocumentSubsetReader.computeNumDocs(reader, roleQueryBits);
        }
        boolean[] added = new boolean[]{false};
        Cache perReaderCache = NUM_DOCS_CACHE.computeIfAbsent(cacheHelper.getKey(), key -> {
            added[0] = true;
            return CacheBuilder.builder().setMaximumWeight(1000L).weigher((k, v) -> 1L).build();
        });
        if (added[0]) {
            IndexReader.ClosedListener closedListener = NUM_DOCS_CACHE::remove;
            try {
                cacheHelper.addClosedListener(closedListener);
            }
            catch (AlreadyClosedException e) {
                closedListener.onClose(cacheHelper.getKey());
                throw e;
            }
        }
        return (Integer)perReaderCache.computeIfAbsent((Object)roleQuery, q -> DocumentSubsetReader.computeNumDocs(reader, roleQueryBits));
    }

    private DocumentSubsetReader(LeafReader in, DocumentSubsetBitsetCache bitsetCache, Query roleQuery) {
        super(in);
        this.bitsetCache = bitsetCache;
        this.roleQuery = roleQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeNumDocsIfNeeded() {
        if (this.numDocs == -1) {
            DocumentSubsetReader documentSubsetReader = this;
            synchronized (documentSubsetReader) {
                if (this.numDocs == -1) {
                    assert (Transports.assertNotTransportThread((String)"resolving role query"));
                    try {
                        this.roleQueryBits = this.bitsetCache.getBitSet(this.roleQuery, this.in.getContext());
                        this.numDocs = DocumentSubsetReader.getNumDocs(this.in, this.roleQuery, this.roleQueryBits);
                    }
                    catch (Exception e) {
                        throw new ElasticsearchException("Failed to load role query", (Throwable)e, new Object[0]);
                    }
                }
            }
        }
    }

    public Bits getLiveDocs() {
        this.computeNumDocsIfNeeded();
        Bits actualLiveDocs = this.in.getLiveDocs();
        if (this.roleQueryBits == null) {
            return new Bits.MatchNoBits(this.in.maxDoc());
        }
        if (this.roleQueryBits instanceof MatchAllBitSet) {
            return actualLiveDocs;
        }
        if (actualLiveDocs == null) {
            return this.roleQueryBits;
        }
        return new CombinedBitSet(this.roleQueryBits, actualLiveDocs);
    }

    public int numDocs() {
        this.computeNumDocsIfNeeded();
        return this.numDocs;
    }

    public boolean hasDeletions() {
        return true;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return reader;
    }

    public static final class DocumentSubsetDirectoryReader
    extends FilterDirectoryReader {
        private final Query roleQuery;
        private final DocumentSubsetBitsetCache bitsetCache;

        DocumentSubsetDirectoryReader(DirectoryReader in, final DocumentSubsetBitsetCache bitsetCache, final Query roleQuery) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    try {
                        return new DocumentSubsetReader(reader, bitsetCache, roleQuery);
                    }
                    catch (Exception e) {
                        throw ExceptionsHelper.convertToElastic((Exception)e);
                    }
                }
            });
            this.bitsetCache = bitsetCache;
            this.roleQuery = roleQuery;
            DocumentSubsetDirectoryReader.verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(in);
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DocumentSubsetDirectoryReader(in, this.bitsetCache, this.roleQuery);
        }

        private static void verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(DirectoryReader reader) {
            if (reader instanceof FilterDirectoryReader) {
                FilterDirectoryReader filterDirectoryReader = (FilterDirectoryReader)reader;
                if (filterDirectoryReader instanceof DocumentSubsetDirectoryReader) {
                    throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Can't wrap [{}] twice", (Object[])new Object[]{DocumentSubsetDirectoryReader.class}));
                }
                DocumentSubsetDirectoryReader.verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(filterDirectoryReader.getDelegate());
            }
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }
}

