/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;

public class UsernamePasswordToken
implements AuthenticationToken {
    public static final String BASIC_AUTH_PREFIX = "Basic ";
    public static final String BASIC_AUTH_HEADER = "Authorization";
    private static final boolean IGNORE_CASE_AUTH_HEADER_MATCH = true;
    private final String username;
    private final SecureString password;

    public UsernamePasswordToken(String username, SecureString password) {
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String basicAuthHeaderValue(String username, SecureString passwd) {
        String string;
        CharBuffer chars = CharBuffer.allocate(username.length() + passwd.length() + 1);
        byte[] charBytes = null;
        try {
            chars.put(username).put(':').put(passwd.getChars());
            charBytes = CharArrays.toUtf8Bytes((char[])chars.array());
            String basicToken = Base64.getEncoder().encodeToString(charBytes);
            string = BASIC_AUTH_PREFIX + basicToken;
        }
        catch (Throwable throwable) {
            Arrays.fill(chars.array(), '\u0000');
            if (charBytes != null) {
                Arrays.fill(charBytes, (byte)0);
            }
            throw throwable;
        }
        Arrays.fill(chars.array(), '\u0000');
        if (charBytes != null) {
            Arrays.fill(charBytes, (byte)0);
        }
        return string;
    }

    @Override
    public String principal() {
        return this.username;
    }

    public SecureString credentials() {
        return this.password;
    }

    @Override
    public void clearCredentials() {
        this.password.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePasswordToken that = (UsernamePasswordToken)o;
        return Objects.equals(this.password, that.password) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password.hashCode());
    }

    public static UsernamePasswordToken extractToken(ThreadContext context) {
        String authStr = context.getHeader(BASIC_AUTH_HEADER);
        return UsernamePasswordToken.extractToken(authStr);
    }

    private static UsernamePasswordToken extractToken(String headerValue) {
        char[] userpasswd;
        if (Strings.isNullOrEmpty((String)headerValue)) {
            return null;
        }
        if (!headerValue.regionMatches(true, 0, BASIC_AUTH_PREFIX, 0, BASIC_AUTH_PREFIX.length())) {
            return null;
        }
        if (headerValue.length() == BASIC_AUTH_PREFIX.length()) {
            throw Exceptions.authenticationError("invalid basic authentication header value", new Object[0]);
        }
        try {
            userpasswd = CharArrays.utf8BytesToChars((byte[])Base64.getDecoder().decode(headerValue.substring(BASIC_AUTH_PREFIX.length()).trim()));
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.authenticationError("invalid basic authentication header encoding", e, new Object[0]);
        }
        int i = UsernamePasswordToken.indexOfColon(userpasswd);
        if (i < 0) {
            throw Exceptions.authenticationError("invalid basic authentication header value", new Object[0]);
        }
        return new UsernamePasswordToken(new String(Arrays.copyOfRange(userpasswd, 0, i)), new SecureString(Arrays.copyOfRange(userpasswd, i + 1, userpasswd.length)));
    }

    public static void putTokenHeader(ThreadContext context, UsernamePasswordToken token) {
        context.putHeader(BASIC_AUTH_HEADER, UsernamePasswordToken.basicAuthHeaderValue(token.username, token.password));
    }

    public static int indexOfColon(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != ':') continue;
            return i;
        }
        return -1;
    }
}

