/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.service;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.user.User;

public interface ServiceAccount {
    public ServiceAccountId id();

    public RoleDescriptor roleDescriptor();

    public User asUser();

    public static final class ServiceAccountId {
        private final String namespace;
        private final String serviceName;

        public static ServiceAccountId fromPrincipal(String principal) {
            int split = principal.indexOf(47);
            if (split == -1) {
                throw new IllegalArgumentException("a service account ID must be in the form {namespace}/{service-name}, but was [" + principal + "]");
            }
            return new ServiceAccountId(principal.substring(0, split), principal.substring(split + 1));
        }

        public ServiceAccountId(String namespace, String serviceName) {
            this.namespace = namespace;
            this.serviceName = serviceName;
            if (Strings.isBlank((String)this.namespace)) {
                throw new IllegalArgumentException("the namespace of a service account ID must not be empty");
            }
            if (Strings.isBlank((String)this.serviceName)) {
                throw new IllegalArgumentException("the service-name of a service account ID must not be empty");
            }
        }

        public ServiceAccountId(StreamInput in) throws IOException {
            this.namespace = in.readString();
            this.serviceName = in.readString();
        }

        public void write(StreamOutput out) throws IOException {
            out.writeString(this.namespace);
            out.writeString(this.serviceName);
        }

        public String namespace() {
            return this.namespace;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public String asPrincipal() {
            return this.namespace + "/" + this.serviceName;
        }

        public String toString() {
            return this.asPrincipal();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceAccountId that = (ServiceAccountId)o;
            return this.namespace.equals(that.namespace) && this.serviceName.equals(that.serviceName);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.serviceName);
        }
    }
}

