/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.support.Validation;

public class DeleteServiceAccountTokenRequest
extends LegacyActionRequest {
    private final String namespace;
    private final String serviceName;
    private final String tokenName;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.WAIT_UNTIL;

    public DeleteServiceAccountTokenRequest(String namespace, String serviceName, String tokenName) {
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.tokenName = tokenName;
    }

    public DeleteServiceAccountTokenRequest(StreamInput in) throws IOException {
        super(in);
        this.namespace = in.readString();
        this.serviceName = in.readString();
        this.tokenName = in.readString();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refresh policy may not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeleteServiceAccountTokenRequest that = (DeleteServiceAccountTokenRequest)((Object)o);
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.tokenName, that.tokenName) && this.refreshPolicy == that.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.serviceName, this.tokenName, this.refreshPolicy);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.namespace);
        out.writeString(this.serviceName);
        out.writeString(this.tokenName);
        this.refreshPolicy.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.namespace)) {
            validationException = ValidateActions.addValidationError((String)"service account namespace is required", validationException);
        }
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            validationException = ValidateActions.addValidationError((String)"service account service-name is required", (ActionRequestValidationException)validationException);
        }
        if (!Validation.isValidServiceAccountTokenName(this.tokenName)) {
            validationException = ValidateActions.addValidationError((String)Validation.formatInvalidServiceTokenNameErrorMessage(this.tokenName), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

