/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.scheduler;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.scheduler.LocalDateTimeLegacyWrapper;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;

public class Cron
implements ToXContentFragment {
    protected static final TimeZone UTC = TimeZone.getTimeZone(ZoneOffset.UTC);
    protected static final DateFormatter formatter = DateFormatter.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int HOUR = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int MONTH = 4;
    private static final int DAY_OF_WEEK = 5;
    private static final int YEAR = 6;
    private static final int ALL_SPEC_INT = 99;
    private static final int NO_SPEC_INT = 98;
    private static final Integer ALL_SPEC = 99;
    private static final Integer NO_SPEC = 98;
    private static final Map<String, Integer> MONTH_MAP = Map.ofEntries(Map.entry("JAN", 0), Map.entry("FEB", 1), Map.entry("MAR", 2), Map.entry("APR", 3), Map.entry("MAY", 4), Map.entry("JUN", 5), Map.entry("JUL", 6), Map.entry("AUG", 7), Map.entry("SEP", 8), Map.entry("OCT", 9), Map.entry("NOV", 10), Map.entry("DEC", 11));
    private static final Map<String, Integer> DAY_MAP = Map.of("SUN", 1, "MON", 2, "TUE", 3, "WED", 4, "THU", 5, "FRI", 6, "SAT", 7);
    private final String expression;
    private ZoneId timeZone;
    private transient TreeSet<Integer> seconds;
    private transient TreeSet<Integer> minutes;
    private transient TreeSet<Integer> hours;
    private transient TreeSet<Integer> daysOfMonth;
    private transient TreeSet<Integer> months;
    private transient TreeSet<Integer> daysOfWeek;
    private transient TreeSet<Integer> years;
    private transient boolean lastdayOfWeek = false;
    private transient int nthdayOfWeek = 0;
    private transient boolean lastdayOfMonth = false;
    private transient boolean nearestWeekday = false;
    private transient int lastdayOffset = 0;
    public static final int MAX_YEAR = Calendar.getInstance(UTC, Locale.ROOT).get(1) + 50;

    public Cron(String expression, ZoneId timeZone) {
        this.timeZone = timeZone;
        assert (expression != null) : "cron expression cannot be null";
        this.expression = expression.toUpperCase(Locale.ROOT);
        try {
            this.buildExpression(this.expression);
        }
        catch (Exception e) {
            throw Exceptions.illegalArgument("invalid cron expression [{}]", e, expression);
        }
    }

    public Cron(String expression) {
        this(expression, UTC.toZoneId());
    }

    public Cron(Cron cron) {
        this(cron.expression, cron.timeZone);
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    @SuppressForbidden(reason="In this case, the DST ambiguity of the atZone method is desired, understood and tested")
    public long getNextValidTimeAfter(long time) {
        LocalDateTime afterTimeLdt = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), this.timeZone).plusSeconds(1L);
        LocalDateTimeLegacyWrapper cl = new LocalDateTimeLegacyWrapper(afterTimeLdt.with(ChronoField.MILLI_OF_SECOND, 0L));
        boolean gotOne = false;
        while (!gotOne) {
            boolean dayOfWSpec;
            if (cl.getYear() > 2999) {
                return -1L;
            }
            SortedSet<Integer> st = null;
            int t = 0;
            int sec = cl.getSecond();
            int min = cl.getMinute();
            st = this.seconds.tailSet(sec);
            if (st != null && st.size() != 0) {
                sec = st.first();
            } else {
                sec = this.seconds.first();
                cl.setMinute(++min);
            }
            cl.setSecond(sec);
            min = cl.getMinute();
            int hr = cl.getHour();
            t = -1;
            st = this.minutes.tailSet(min);
            if (st != null && st.size() != 0) {
                t = min;
                min = st.first();
            } else {
                min = this.minutes.first();
                ++hr;
            }
            if (min != t) {
                cl.setSecond(0);
                cl.setMinute(min);
                cl.setHour(hr);
                continue;
            }
            cl.setMinute(min);
            hr = cl.getHour();
            int day = cl.getDayOfMonth();
            t = -1;
            st = this.hours.tailSet(hr);
            if (st != null && st.size() != 0) {
                t = hr;
                hr = st.first();
            } else {
                hr = this.hours.first();
                ++day;
            }
            if (hr != t) {
                cl.setSecond(0);
                cl.setMinute(0);
                cl.setDayOfMonth(day);
                cl.setHour(hr);
                continue;
            }
            cl.setHour(hr);
            day = cl.getDayOfMonth();
            int mon = cl.getMonth() + 1;
            t = -1;
            int tmon = mon;
            boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec && !dayOfWSpec) {
                st = this.daysOfMonth.tailSet(day);
                if (this.lastdayOfMonth) {
                    if (!this.nearestWeekday) {
                        t = day;
                        day = Cron.getLastDayOfMonth(mon, cl.getYear());
                        if (t > (day -= this.lastdayOffset)) {
                            if (++mon > 12) {
                                mon = 1;
                                tmon = 3333;
                                cl.plusYears(1L);
                            }
                            day = 1;
                        }
                    } else {
                        t = day;
                        day = Cron.getLastDayOfMonth(mon, cl.getYear());
                        LocalDateTimeLegacyWrapper tcal = new LocalDateTimeLegacyWrapper(LocalDateTime.now(this.timeZone));
                        tcal.setSecond(0);
                        tcal.setMinute(0);
                        tcal.setHour(0);
                        tcal.setDayOfMonth(day -= this.lastdayOffset);
                        tcal.setMonth(mon - 1);
                        tcal.setYear(cl.getYear());
                        ldom = Cron.getLastDayOfMonth(mon, cl.getYear());
                        dow = tcal.getDayOfWeek();
                        if (dow == 7 && day == 1) {
                            day += 2;
                        } else if (dow == 7) {
                            --day;
                        } else if (dow == 1 && day == ldom) {
                            day -= 2;
                        } else if (dow == 1) {
                            ++day;
                        }
                        tcal.setSecond(sec);
                        tcal.setMinute(min);
                        tcal.setHour(hr);
                        tcal.setDayOfMonth(day);
                        tcal.setMonth(mon - 1);
                        if (tcal.isBefore(afterTimeLdt)) {
                            day = 1;
                            ++mon;
                        }
                    }
                } else if (this.nearestWeekday) {
                    t = day;
                    day = this.daysOfMonth.first();
                    LocalDateTimeLegacyWrapper tcal = new LocalDateTimeLegacyWrapper(LocalDateTime.now(this.timeZone));
                    tcal.setSecond(0);
                    tcal.setMinute(0);
                    tcal.setHour(0);
                    tcal.setDayOfMonth(day);
                    tcal.setMonth(mon - 1);
                    tcal.setYear(cl.getYear());
                    ldom = Cron.getLastDayOfMonth(mon, cl.getYear());
                    dow = tcal.getDayOfWeek();
                    if (dow == 7 && day == 1) {
                        day += 2;
                    } else if (dow == 7) {
                        --day;
                    } else if (dow == 1 && day == ldom) {
                        day -= 2;
                    } else if (dow == 1) {
                        ++day;
                    }
                    tcal.setSecond(sec);
                    tcal.setMinute(min);
                    tcal.setHour(hr);
                    tcal.setDayOfMonth(day);
                    tcal.setMonth(mon - 1);
                    if (tcal.isAfter(afterTimeLdt)) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else if (st != null && st.size() != 0) {
                    int lastDay;
                    t = day;
                    day = st.first();
                    if (day > (lastDay = Cron.getLastDayOfMonth(mon, cl.getYear()))) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else {
                    day = this.daysOfMonth.first();
                    ++mon;
                }
                if (day != t || mon != tmon) {
                    cl.setSecond(0);
                    cl.setMinute(0);
                    cl.setHour(0);
                    cl.setDayOfMonth(day);
                    cl.setMonth(mon - 1);
                    continue;
                }
            } else if (dayOfWSpec && !dayOfMSpec) {
                if (this.lastdayOfWeek) {
                    int dow = this.daysOfWeek.first();
                    cDow = cl.getDayOfWeek();
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = Cron.getLastDayOfMonth(mon, cl.getYear()))) {
                        cl.setSecond(0);
                        cl.setMinute(0);
                        cl.setHour(0);
                        cl.setDayOfMonth(1);
                        cl.setMonth(mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                    if (daysToAdd > 0) {
                        cl.setSecond(0);
                        cl.setMinute(0);
                        cl.setHour(0);
                        cl.setDayOfMonth(day);
                        cl.setMonth(mon - 1);
                        continue;
                    }
                } else if (this.nthdayOfWeek != 0) {
                    int dow = this.daysOfWeek.first();
                    cDow = cl.getDayOfWeek();
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    } else if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    boolean dayShifted = false;
                    if (daysToAdd > 0) {
                        dayShifted = true;
                    }
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > Cron.getLastDayOfMonth(mon, cl.getYear())) {
                        cl.setSecond(0);
                        cl.setMinute(0);
                        cl.setHour(0);
                        cl.setDayOfMonth(1);
                        cl.setMonth(mon);
                        continue;
                    }
                    if (daysToAdd > 0 || dayShifted) {
                        cl.setSecond(0);
                        cl.setMinute(0);
                        cl.setHour(0);
                        cl.setDayOfMonth(day);
                        cl.setMonth(mon - 1);
                        continue;
                    }
                } else {
                    int cDow = cl.getDayOfWeek();
                    int dow = this.daysOfWeek.first();
                    st = this.daysOfWeek.tailSet(cDow);
                    if (st != null && st.size() > 0) {
                        dow = st.first();
                    }
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = Cron.getLastDayOfMonth(mon, cl.getYear()))) {
                        cl.setSecond(0);
                        cl.setMinute(0);
                        cl.setHour(0);
                        cl.setDayOfMonth(1);
                        cl.setMonth(mon);
                        continue;
                    }
                    if (daysToAdd > 0) {
                        cl.setSecond(0);
                        cl.setMinute(0);
                        cl.setHour(0);
                        cl.setDayOfMonth(day + daysToAdd);
                        cl.setMonth(mon - 1);
                        continue;
                    }
                }
            } else {
                return -1L;
            }
            cl.setDayOfMonth(day);
            mon = cl.getMonth() + 1;
            int year = cl.getYear();
            t = -1;
            if (year > MAX_YEAR) {
                return -1L;
            }
            st = this.months.tailSet(mon);
            if (st != null && st.size() != 0) {
                t = mon;
                mon = st.first();
            } else {
                mon = this.months.first();
                ++year;
            }
            if (mon != t) {
                cl.setSecond(0);
                cl.setMinute(0);
                cl.setHour(0);
                cl.setDayOfMonth(1);
                cl.setMonth(mon - 1);
                cl.setYear(year);
                continue;
            }
            cl.setMonth(mon - 1);
            year = cl.getYear();
            t = -1;
            st = this.years.tailSet(year);
            if (st == null || st.size() == 0) {
                return -1L;
            }
            t = year;
            year = st.first();
            if (year != t) {
                cl.setSecond(0);
                cl.setMinute(0);
                cl.setHour(0);
                cl.setDayOfMonth(1);
                cl.setMonth(0);
                cl.setYear(year);
                continue;
            }
            cl.setYear(year);
            gotOne = true;
        }
        LocalDateTime nextRuntime = cl.getLocalDateTime();
        return nextRuntime.atZone(this.timeZone).toInstant().toEpochMilli();
    }

    public String expression() {
        return this.expression;
    }

    public String getExpressionSummary() {
        StringBuilder buf = new StringBuilder();
        buf.append("seconds: ");
        buf.append(Cron.expressionSetSummary(this.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        buf.append(Cron.expressionSetSummary(this.minutes));
        buf.append("\n");
        buf.append("hours: ");
        buf.append(Cron.expressionSetSummary(this.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        buf.append(Cron.expressionSetSummary(this.daysOfMonth));
        buf.append("\n");
        buf.append("months: ");
        buf.append(Cron.expressionSetSummary(this.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        buf.append(Cron.expressionSetSummary(this.daysOfWeek));
        buf.append("\n");
        buf.append("lastdayOfWeek: ");
        buf.append(this.lastdayOfWeek);
        buf.append("\n");
        buf.append("nearestWeekday: ");
        buf.append(this.nearestWeekday);
        buf.append("\n");
        buf.append("NthDayOfWeek: ");
        buf.append(this.nthdayOfWeek);
        buf.append("\n");
        buf.append("lastdayOfMonth: ");
        buf.append(this.lastdayOfMonth);
        buf.append("\n");
        buf.append("years: ");
        buf.append(Cron.expressionSetSummary(this.years));
        buf.append("\n");
        return buf.toString();
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.timeZone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cron other = (Cron)obj;
        return Objects.equals(this.expression, other.expression) && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return "Cron{timeZone=" + String.valueOf(this.timeZone) + ", expression='" + this.expression + "'}";
    }

    public static boolean isValid(String expression) {
        try {
            Cron.validate(expression);
        }
        catch (IllegalArgumentException pe) {
            return false;
        }
        return true;
    }

    public static void validate(String expression) throws IllegalArgumentException {
        new Cron(expression);
    }

    private void buildExpression(String expression) {
        try {
            boolean dayOfWSpec;
            int exprOn;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer exprsTok = new StringTokenizer(expression, " \t", false);
            for (exprOn = 0; exprsTok.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprsTok.nextToken().trim();
                if (exprOn == 3 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw Exceptions.illegalArgument("support for specifying 'L' and 'LW' with other days of the month is not implemented", new Object[0]);
                }
                if (exprOn == 5 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw Exceptions.illegalArgument("support for specifying 'L' with other days of the week is not implemented", new Object[0]);
                }
                if (exprOn == 5 && expr.indexOf(35) != -1 && expr.indexOf(35, expr.indexOf(35) + 1) != -1) {
                    throw Exceptions.illegalArgument("support for specifying multiple \"nth\" days is not implemented.", new Object[0]);
                }
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw Exceptions.illegalArgument("unexpected end of expression at pos [{}].", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
            TreeSet<Integer> dow = this.getSet(5);
            TreeSet<Integer> dom = this.getSet(3);
            boolean dayOfMSpec = !dom.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !dow.contains(NO_SPEC);
            if (!(dayOfMSpec && !dayOfWSpec || dayOfWSpec && !dayOfMSpec)) {
                throw Exceptions.illegalArgument("support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", new Object[0]);
            }
        }
        catch (Exception e) {
            throw Exceptions.illegalArgument("illegal cron expression format [{}]", e.toString());
        }
    }

    private int storeExpressionVals(int pos, String s, int type) throws ElasticsearchParseException {
        int val;
        int incr = 0;
        int i = Cron.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        if (!(c < 'A' || c > 'Z' || s.equals("L") || s.equals("LW") || s.matches("^L-[0-9]*[W]?"))) {
            int eval;
            int sval;
            block47: {
                String sub = s.substring(i, i + 3);
                sval = -1;
                eval = -1;
                if (type == 4) {
                    sval = Cron.getMonthNumber(sub) + 1;
                    if (sval <= 0) {
                        throw Exceptions.illegalArgument("invalid Month value [{}] at pos [{}]", sub, i);
                    }
                    if (s.length() > i + 3 && (c = s.charAt(i + 3)) == '-' && (eval = Cron.getMonthNumber(sub = s.substring(i += 4, i + 3)) + 1) <= 0) {
                        throw Exceptions.illegalArgument("invalid Month value [{}] at pos [{}]", sub, i);
                    }
                } else if (type == 5) {
                    sval = Cron.getDayOfWeekNumber(sub);
                    if (sval < 0) {
                        throw Exceptions.illegalArgument("invalid Day-of-Week value [{}] at pos [{}]", sub, i);
                    }
                    if (s.length() > i + 3) {
                        c = s.charAt(i + 3);
                        if (c == '-') {
                            if ((eval = Cron.getDayOfWeekNumber(sub = s.substring(i += 4, i + 3))) < 0) {
                                throw Exceptions.illegalArgument("invalid Day-of-Week value [{}] at pos [{}]", sub, i);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.nthdayOfWeek = Integer.parseInt(s.substring(i += 4));
                                    if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                                        throw new Exception();
                                    }
                                    break block47;
                                }
                                catch (Exception e) {
                                    throw Exceptions.illegalArgument("a numeric value between 1 and 5 must follow the '#' option at pos [{}]", i);
                                }
                            }
                            if (c == 'L') {
                                this.lastdayOfWeek = true;
                                ++i;
                            }
                        }
                    }
                } else {
                    throw Exceptions.illegalArgument("illegal characters [{}] at pos [{}] '", sub, i);
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        if (c == '?') {
            int val2;
            if (++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t') {
                throw Exceptions.illegalArgument("illegal character [{}] after '?' at pos [{}]", Character.valueOf(s.charAt(i)), i);
            }
            if (type != 5 && type != 3) {
                throw Exceptions.illegalArgument("'?' can only be specified for Day-of-Month or Day-of-Week. at pos [{}]", i);
            }
            if (type == 5 && !this.lastdayOfMonth && (val2 = this.daysOfMonth.last().intValue()) == 98) {
                throw Exceptions.illegalArgument("'?' can only be specified for Day-of-Month -OR- Day-of-Week. at pos [{}]", i);
            }
            this.addToSet(98, -1, 0, type);
            return i;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && i + 1 >= s.length()) {
                this.addToSet(99, -1, incr, type);
                return i + 1;
            }
            if (c == '/' && (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t')) {
                throw Exceptions.illegalArgument("'/' must be followed by an integer. at pos [{}]", i);
            }
            if (c == '*') {
                ++i;
            }
            if ((c = s.charAt(i)) == '/') {
                if (++i >= s.length()) {
                    throw Exceptions.illegalArgument("Unexpected end of string. at pos [{}]", i);
                }
                incr = Cron.getNumericValue(s, i);
                ++i;
                if (incr > 10) {
                    ++i;
                }
                if (incr > 59 && (type == 0 || type == 1)) {
                    throw Exceptions.illegalArgument("increment [{}] > 60 at pos [{}]", incr, i);
                }
                if (incr > 23 && type == 2) {
                    throw Exceptions.illegalArgument("increment [{}] > 24 at pos [{}]", incr, i);
                }
                if (incr > 31 && type == 3) {
                    throw Exceptions.illegalArgument("increment [{}] > 31 at pos [{}] ", incr, i);
                }
                if (incr > 7 && type == 5) {
                    throw Exceptions.illegalArgument("increment [{}] > 7 at pos [{}] ", incr, i);
                }
                if (incr > 12 && type == 4) {
                    throw Exceptions.illegalArgument("increment [{}] > 12 at pos [{}]", incr, i);
                }
            } else {
                incr = 1;
            }
            this.addToSet(99, -1, incr, type);
            return i;
        }
        if (c == 'L') {
            ++i;
            if (type == 3) {
                this.lastdayOfMonth = true;
            }
            if (type == 5) {
                this.addToSet(7, 7, 0, type);
            }
            if (type == 3 && s.length() > i) {
                c = s.charAt(i);
                if (c == '-') {
                    ValueSet vs = Cron.getValue(0, s, i + 1);
                    this.lastdayOffset = vs.value;
                    if (this.lastdayOffset > 30) {
                        throw Exceptions.illegalArgument("offset from last day must be <= 30 at pos [{}]", i + 1);
                    }
                    i = vs.pos;
                }
                if (s.length() > i && (c = s.charAt(i)) == 'W') {
                    this.nearestWeekday = true;
                    ++i;
                }
            }
            return i;
        }
        if (c >= '0' && c <= '9') {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s.length()) {
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = Cron.getValue(val, s, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s, val, type);
                return i;
            }
        } else {
            throw Exceptions.illegalArgument("Unexpected character [{}] at pos [{}] ", Character.valueOf(c), i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    private int checkNext(int pos, String s, int val, int type) throws ElasticsearchParseException {
        int end = -1;
        int i = pos;
        if (i >= s.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s.charAt(pos);
        if (c == 'L') {
            if (type == 5) {
                if (val < 1 || val > 7) {
                    throw Exceptions.illegalArgument("Day-of-Week values must be between 1 and 7", new Object[0]);
                }
            } else {
                throw Exceptions.illegalArgument("'L' option is not valid here. at pos [{}]", i);
            }
            this.lastdayOfWeek = true;
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw Exceptions.illegalArgument("'W' option is not valid here. at pos [{}]", i);
            }
            this.nearestWeekday = true;
            if (val > 31) {
                throw Exceptions.illegalArgument("the 'W' option does not make sense with values larger than 31 (max number of days in a month) at pos [{}]", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '#') {
            if (type != 5) {
                throw Exceptions.illegalArgument("'#' option is not valid here. at pos [{}]", i);
            }
            ++i;
            try {
                this.nthdayOfWeek = Integer.parseInt(s.substring(i));
                if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw Exceptions.illegalArgument("a numeric value between 1 and 5 must follow the '#' option at pos [{}]", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '-') {
            int v;
            c = s.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = Cron.getValue(v, s, i);
                end = vs.value;
                i = vs.pos;
            }
            if (i < s.length() && (c = s.charAt(i)) == '/') {
                c = s.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = Cron.getValue(v2, s, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == '/') {
            c = s.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = Cron.getValue(v2, s, i);
                int v3 = vs.value;
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw Exceptions.illegalArgument("Unexpected character [{}] after '/' at pos [{}]", Character.valueOf(c), i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    private static String expressionSetSummary(Set<Integer> set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    private static int skipWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    private static int findNextWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) != ' ' || s.charAt(i) != '\t')) {
            ++i;
        }
        return i;
    }

    private void addToSet(int val, int end, int incr, int type) throws ElasticsearchParseException {
        TreeSet<Integer> set = this.getSet(type);
        if (type == 0 || type == 1) {
            if ((val < 0 || val > 59 || end > 59) && val != 99) {
                throw Exceptions.illegalArgument("Minute and Second values must be between 0 and 59", new Object[0]);
            }
        } else if (type == 2) {
            if ((val < 0 || val > 23 || end > 23) && val != 99) {
                throw Exceptions.illegalArgument("Hour values must be between 0 and 23", new Object[0]);
            }
        } else if (type == 3) {
            if ((val < 1 || val > 31 || end > 31) && val != 99 && val != 98) {
                throw Exceptions.illegalArgument("Day of month values must be between 1 and 31", new Object[0]);
            }
        } else if (type == 4) {
            if ((val < 1 || val > 12 || end > 12) && val != 99) {
                throw Exceptions.illegalArgument("Month values must be between 1 and 12", new Object[0]);
            }
        } else if (type == 5 && (val == 0 || val > 7 || end > 7) && val != 99 && val != 98) {
            throw Exceptions.illegalArgument("Day-of-Week values must be between 1 and 7", new Object[0]);
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(val);
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        int startAt = val;
        int stopAt = end;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        if (type == 0 || type == 1) {
            if (stopAt == -1) {
                stopAt = 59;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 2) {
            if (stopAt == -1) {
                stopAt = 23;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 3) {
            if (stopAt == -1) {
                stopAt = 31;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 4) {
            if (stopAt == -1) {
                stopAt = 12;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 5) {
            if (stopAt == -1) {
                stopAt = 7;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 6) {
            if (stopAt == -1) {
                stopAt = MAX_YEAR;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1970;
            }
        }
        int max = -1;
        if (stopAt < startAt) {
            max = switch (type) {
                case 0 -> 60;
                case 1 -> 60;
                case 2 -> 24;
                case 4 -> 12;
                case 5 -> 7;
                case 3 -> 31;
                case 6 -> throw new IllegalArgumentException("Start year must be less than stop year");
                default -> throw new IllegalArgumentException("Unexpected type encountered");
            };
            stopAt += max;
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            if (max == -1) {
                set.add(i);
                continue;
            }
            int i2 = i % max;
            if (i2 == 0 && (type == 4 || type == 5 || type == 3)) {
                i2 = max;
            }
            set.add(i2);
        }
    }

    private TreeSet<Integer> getSet(int type) {
        return switch (type) {
            case 0 -> this.seconds;
            case 1 -> this.minutes;
            case 2 -> this.hours;
            case 3 -> this.daysOfMonth;
            case 4 -> this.months;
            case 5 -> this.daysOfWeek;
            case 6 -> this.years;
            default -> null;
        };
    }

    private static ValueSet getValue(int v, String s, int i) {
        char c = s.charAt(i);
        StringBuilder s1 = new StringBuilder(String.valueOf(v));
        while (c >= '0' && c <= '9') {
            s1.append(c);
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s.length() ? i : i + 1;
        val.value = Integer.parseInt(s1.toString());
        return val;
    }

    private static int getNumericValue(String s, int i) {
        int endOfVal = Cron.findNextWhiteSpace(i, s);
        String val = s.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    private static int getMonthNumber(String s) {
        Integer integer = MONTH_MAP.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    private static int getDayOfWeekNumber(String s) {
        Integer integer = DAY_MAP.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    private static void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        if (cal.get(11) != hour && hour != 24) {
            cal.set(11, hour + 1);
        }
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static int getLastDayOfMonth(int monthNum, int year) {
        return switch (monthNum) {
            case 1 -> 31;
            case 2 -> {
                if (Cron.isLeapYear(year)) {
                    yield 29;
                }
                yield 28;
            }
            case 3 -> 31;
            case 4 -> 30;
            case 5 -> 31;
            case 6 -> 30;
            case 7 -> 31;
            case 8 -> 31;
            case 9 -> 30;
            case 10 -> 31;
            case 11 -> 30;
            case 12 -> 31;
            default -> throw new IllegalArgumentException("Illegal month number: " + monthNum);
        };
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.expression);
    }

    private static class ValueSet {
        int value;
        int pos;

        private ValueSet() {
        }
    }
}

