/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BoostedTreeParams
implements ToXContentFragment,
Writeable {
    static final String NAME = "boosted_tree_params";
    public static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    public static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    public static final ParseField ETA = new ParseField("eta", new String[0]);
    public static final ParseField MAX_TREES = new ParseField("max_trees", new String[]{"maximum_number_trees"});
    public static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    public static final ParseField ALPHA = new ParseField("alpha", new String[0]);
    public static final ParseField ETA_GROWTH_RATE_PER_TREE = new ParseField("eta_growth_rate_per_tree", new String[0]);
    public static final ParseField SOFT_TREE_DEPTH_LIMIT = new ParseField("soft_tree_depth_limit", new String[0]);
    public static final ParseField SOFT_TREE_DEPTH_TOLERANCE = new ParseField("soft_tree_depth_tolerance", new String[0]);
    public static final ParseField DOWNSAMPLE_FACTOR = new ParseField("downsample_factor", new String[0]);
    public static final ParseField MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER = new ParseField("max_optimization_rounds_per_hyperparameter", new String[0]);
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maxTrees;
    private final Double featureBagFraction;
    private final Integer numTopFeatureImportanceValues;
    private final Double alpha;
    private final Double etaGrowthRatePerTree;
    private final Double softTreeDepthLimit;
    private final Double softTreeDepthTolerance;
    private final Double downsampleFactor;
    private final Integer maxOptimizationRoundsPerHyperparameter;

    static void declareFields(AbstractObjectParser<?, Void> parser) {
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_TREES);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ALPHA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA_GROWTH_RATE_PER_TREE);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), SOFT_TREE_DEPTH_LIMIT);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), SOFT_TREE_DEPTH_TOLERANCE);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), DOWNSAMPLE_FACTOR);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER);
    }

    public BoostedTreeParams(@Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maxTrees, @Nullable Double featureBagFraction, @Nullable Integer numTopFeatureImportanceValues, @Nullable Double alpha, @Nullable Double etaGrowthRatePerTree, @Nullable Double softTreeDepthLimit, @Nullable Double softTreeDepthTolerance, @Nullable Double downsampleFactor, @Nullable Integer maxOptimizationRoundsPerHyperparameter) {
        if (lambda != null && lambda < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", LAMBDA.getPreferredName());
        }
        if (gamma != null && gamma < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", GAMMA.getPreferredName());
        }
        if (eta != null && (eta < 0.001 || eta > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [0.001, 1]", ETA.getPreferredName());
        }
        if (maxTrees != null && (maxTrees <= 0 || maxTrees > 2000)) {
            throw ExceptionsHelper.badRequestException("[{}] must be an integer in [1, 2000]", MAX_TREES.getPreferredName());
        }
        if (featureBagFraction != null && (featureBagFraction <= 0.0 || featureBagFraction > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in (0, 1]", FEATURE_BAG_FRACTION.getPreferredName());
        }
        if (numTopFeatureImportanceValues != null && numTopFeatureImportanceValues < 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative integer", NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName());
        }
        if (alpha != null && alpha < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", ALPHA.getPreferredName());
        }
        if (etaGrowthRatePerTree != null && (etaGrowthRatePerTree < 0.5 || etaGrowthRatePerTree > 2.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [0.5, 2.0]", ETA_GROWTH_RATE_PER_TREE.getPreferredName());
        }
        if (softTreeDepthLimit != null && softTreeDepthLimit < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", SOFT_TREE_DEPTH_LIMIT.getPreferredName());
        }
        if (softTreeDepthTolerance != null && softTreeDepthTolerance < 0.01) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double greater than or equal to 0.01", SOFT_TREE_DEPTH_TOLERANCE.getPreferredName());
        }
        if (downsampleFactor != null && (downsampleFactor <= 0.0 || downsampleFactor > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in (0, 1]", DOWNSAMPLE_FACTOR.getPreferredName());
        }
        if (maxOptimizationRoundsPerHyperparameter != null && (maxOptimizationRoundsPerHyperparameter < 0 || maxOptimizationRoundsPerHyperparameter > 20)) {
            throw ExceptionsHelper.badRequestException("[{}] must be an integer in [0, 20]", MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER.getPreferredName());
        }
        this.lambda = lambda;
        this.gamma = gamma;
        this.eta = eta;
        this.maxTrees = maxTrees;
        this.featureBagFraction = featureBagFraction;
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
        this.alpha = alpha;
        this.etaGrowthRatePerTree = etaGrowthRatePerTree;
        this.softTreeDepthLimit = softTreeDepthLimit;
        this.softTreeDepthTolerance = softTreeDepthTolerance;
        this.downsampleFactor = downsampleFactor;
        this.maxOptimizationRoundsPerHyperparameter = maxOptimizationRoundsPerHyperparameter;
    }

    BoostedTreeParams(StreamInput in) throws IOException {
        this.lambda = in.readOptionalDouble();
        this.gamma = in.readOptionalDouble();
        this.eta = in.readOptionalDouble();
        this.maxTrees = in.readOptionalVInt();
        this.featureBagFraction = in.readOptionalDouble();
        this.numTopFeatureImportanceValues = in.readOptionalInt();
        this.alpha = in.readOptionalDouble();
        this.etaGrowthRatePerTree = in.readOptionalDouble();
        this.softTreeDepthLimit = in.readOptionalDouble();
        this.softTreeDepthTolerance = in.readOptionalDouble();
        this.downsampleFactor = in.readOptionalDouble();
        this.maxOptimizationRoundsPerHyperparameter = in.readOptionalVInt();
    }

    public Double getLambda() {
        return this.lambda;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public Double getEta() {
        return this.eta;
    }

    public Integer getMaxTrees() {
        return this.maxTrees;
    }

    public Double getFeatureBagFraction() {
        return this.featureBagFraction;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public Double getAlpha() {
        return this.alpha;
    }

    public Double getEtaGrowthRatePerTree() {
        return this.etaGrowthRatePerTree;
    }

    public Double getSoftTreeDepthLimit() {
        return this.softTreeDepthLimit;
    }

    public Double getSoftTreeDepthTolerance() {
        return this.softTreeDepthTolerance;
    }

    public Double getDownsampleFactor() {
        return this.downsampleFactor;
    }

    public Integer getMaxOptimizationRoundsPerHyperparameter() {
        return this.maxOptimizationRoundsPerHyperparameter;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.lambda);
        out.writeOptionalDouble(this.gamma);
        out.writeOptionalDouble(this.eta);
        out.writeOptionalVInt(this.maxTrees);
        out.writeOptionalDouble(this.featureBagFraction);
        out.writeOptionalInt(this.numTopFeatureImportanceValues);
        out.writeOptionalDouble(this.alpha);
        out.writeOptionalDouble(this.etaGrowthRatePerTree);
        out.writeOptionalDouble(this.softTreeDepthLimit);
        out.writeOptionalDouble(this.softTreeDepthTolerance);
        out.writeOptionalDouble(this.downsampleFactor);
        out.writeOptionalVInt(this.maxOptimizationRoundsPerHyperparameter);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.alpha != null) {
            builder.field(ALPHA.getPreferredName(), this.alpha);
        }
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.etaGrowthRatePerTree != null) {
            builder.field(ETA_GROWTH_RATE_PER_TREE.getPreferredName(), this.etaGrowthRatePerTree);
        }
        if (this.maxTrees != null) {
            builder.field(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (this.softTreeDepthLimit != null) {
            builder.field(SOFT_TREE_DEPTH_LIMIT.getPreferredName(), this.softTreeDepthLimit);
        }
        if (this.softTreeDepthTolerance != null) {
            builder.field(SOFT_TREE_DEPTH_TOLERANCE.getPreferredName(), this.softTreeDepthTolerance);
        }
        if (this.downsampleFactor != null) {
            builder.field(DOWNSAMPLE_FACTOR.getPreferredName(), this.downsampleFactor);
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            builder.field(MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER.getPreferredName(), this.maxOptimizationRoundsPerHyperparameter);
        }
        return builder;
    }

    Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lambda != null) {
            params.put(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            params.put(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            params.put(ETA.getPreferredName(), this.eta);
        }
        if (this.maxTrees != null) {
            params.put(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.featureBagFraction != null) {
            params.put(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            params.put(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (this.alpha != null) {
            params.put(ALPHA.getPreferredName(), this.alpha);
        }
        if (this.etaGrowthRatePerTree != null) {
            params.put(ETA_GROWTH_RATE_PER_TREE.getPreferredName(), this.etaGrowthRatePerTree);
        }
        if (this.softTreeDepthLimit != null) {
            params.put(SOFT_TREE_DEPTH_LIMIT.getPreferredName(), this.softTreeDepthLimit);
        }
        if (this.softTreeDepthTolerance != null) {
            params.put(SOFT_TREE_DEPTH_TOLERANCE.getPreferredName(), this.softTreeDepthTolerance);
        }
        if (this.downsampleFactor != null) {
            params.put(DOWNSAMPLE_FACTOR.getPreferredName(), this.downsampleFactor);
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            params.put(MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER.getPreferredName(), this.maxOptimizationRoundsPerHyperparameter);
        }
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostedTreeParams that = (BoostedTreeParams)o;
        return Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maxTrees, that.maxTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals(this.alpha, that.alpha) && Objects.equals(this.etaGrowthRatePerTree, that.etaGrowthRatePerTree) && Objects.equals(this.softTreeDepthLimit, that.softTreeDepthLimit) && Objects.equals(this.softTreeDepthTolerance, that.softTreeDepthTolerance) && Objects.equals(this.downsampleFactor, that.downsampleFactor) && Objects.equals(this.maxOptimizationRoundsPerHyperparameter, that.maxOptimizationRoundsPerHyperparameter);
    }

    public int hashCode() {
        return Objects.hash(this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.alpha, this.etaGrowthRatePerTree, this.softTreeDepthLimit, this.softTreeDepthTolerance, this.downsampleFactor, this.maxOptimizationRoundsPerHyperparameter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Double lambda;
        private Double gamma;
        private Double eta;
        private Integer maxTrees;
        private Double featureBagFraction;
        private Integer numTopFeatureImportanceValues;
        private Double alpha;
        private Double etaGrowthRatePerTree;
        private Double softTreeDepthLimit;
        private Double softTreeDepthTolerance;
        private Double downsampleFactor;
        private Integer maxOptimizationRoundsPerHyperparameter;

        private Builder() {
        }

        Builder(BoostedTreeParams params) {
            this.lambda = params.lambda;
            this.gamma = params.gamma;
            this.eta = params.eta;
            this.maxTrees = params.maxTrees;
            this.featureBagFraction = params.featureBagFraction;
            this.numTopFeatureImportanceValues = params.numTopFeatureImportanceValues;
            this.alpha = params.alpha;
            this.etaGrowthRatePerTree = params.etaGrowthRatePerTree;
            this.softTreeDepthLimit = params.softTreeDepthLimit;
            this.softTreeDepthTolerance = params.softTreeDepthTolerance;
            this.downsampleFactor = params.downsampleFactor;
            this.maxOptimizationRoundsPerHyperparameter = params.maxOptimizationRoundsPerHyperparameter;
        }

        public Builder setLambda(Double lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder setGamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder setEta(Double eta) {
            this.eta = eta;
            return this;
        }

        public Builder setMaxTrees(Integer maxTrees) {
            this.maxTrees = maxTrees;
            return this;
        }

        public Builder setFeatureBagFraction(Double featureBagFraction) {
            this.featureBagFraction = featureBagFraction;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setAlpha(Double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder setEtaGrowthRatePerTree(Double etaGrowthRatePerTree) {
            this.etaGrowthRatePerTree = etaGrowthRatePerTree;
            return this;
        }

        public Builder setSoftTreeDepthLimit(Double softTreeDepthLimit) {
            this.softTreeDepthLimit = softTreeDepthLimit;
            return this;
        }

        public Builder setSoftTreeDepthTolerance(Double softTreeDepthTolerance) {
            this.softTreeDepthTolerance = softTreeDepthTolerance;
            return this;
        }

        public Builder setDownsampleFactor(Double downsampleFactor) {
            this.downsampleFactor = downsampleFactor;
            return this;
        }

        public Builder setMaxOptimizationRoundsPerHyperparameter(Integer maxOptimizationRoundsPerHyperparameter) {
            this.maxOptimizationRoundsPerHyperparameter = maxOptimizationRoundsPerHyperparameter;
            return this;
        }

        public BoostedTreeParams build() {
            return new BoostedTreeParams(this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.alpha, this.etaGrowthRatePerTree, this.softTreeDepthLimit, this.softTreeDepthTolerance, this.downsampleFactor, this.maxOptimizationRoundsPerHyperparameter);
        }
    }
}

