/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PutTrainedModelDefinitionPartAction
extends ActionType<AcknowledgedResponse> {
    public static final int MAX_NUM_NATIVE_DEFINITION_PARTS = 10000;
    public static final PutTrainedModelDefinitionPartAction INSTANCE = new PutTrainedModelDefinitionPartAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/part/put";

    private PutTrainedModelDefinitionPartAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
        public static final ParseField TOTAL_DEFINITION_LENGTH = new ParseField("total_definition_length", new String[0]);
        public static final ParseField TOTAL_PARTS = new ParseField("total_parts", new String[0]);
        public static final String PART = "part";
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("put_trained_model_part_action", Builder::new);
        private final String modelId;
        private final BytesReference definition;
        private final int part;
        private final long totalDefinitionLength;
        private final int totalParts;
        private final boolean allowOverwriting;

        public static Request parseRequest(String modelId, int part, XContentParser parser) {
            return ((Builder)PARSER.apply(parser, null)).build(modelId, part, false);
        }

        public Request(String modelId, BytesReference definition, int part, long totalDefinitionLength, int totalParts, boolean allowOverwriting) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.modelId = ExceptionsHelper.requireNonNull(modelId, TrainedModelConfig.MODEL_ID);
            this.definition = ExceptionsHelper.requireNonNull(definition, DEFINITION);
            this.part = part;
            this.totalDefinitionLength = totalDefinitionLength;
            this.totalParts = totalParts;
            this.allowOverwriting = allowOverwriting;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.definition = in.readBytesReference();
            this.part = in.readVInt();
            this.totalDefinitionLength = in.readVLong();
            this.totalParts = in.readVInt();
            this.allowOverwriting = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_10_X) ? in.readBoolean() : false;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.part < 0) {
                validationException = ValidateActions.addValidationError((String)"[part] must be greater or equal to 0", validationException);
            }
            if (this.totalParts <= 0) {
                validationException = ValidateActions.addValidationError((String)"[total_parts] must be greater than 0", (ActionRequestValidationException)validationException);
            }
            if (this.totalParts > 10000) {
                validationException = ValidateActions.addValidationError((String)"[total_parts] must be less than or equal to 10000", (ActionRequestValidationException)validationException);
            }
            if (this.totalDefinitionLength <= 0L) {
                validationException = ValidateActions.addValidationError((String)"[total_definition_length] must be greater than 0", (ActionRequestValidationException)validationException);
            }
            if (this.part >= this.totalParts) {
                validationException = ValidateActions.addValidationError((String)"[part] must be less than total_parts", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.part == request.part && this.totalDefinitionLength == request.totalDefinitionLength && this.totalParts == request.totalParts && this.allowOverwriting == request.allowOverwriting && Objects.equals(this.modelId, request.modelId) && Objects.equals(this.definition, request.definition);
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.definition, this.part, this.totalDefinitionLength, this.totalParts, this.allowOverwriting);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeBytesReference(this.definition);
            out.writeVInt(this.part);
            out.writeVLong(this.totalDefinitionLength);
            out.writeVInt(this.totalParts);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_10_X)) {
                out.writeBoolean(this.allowOverwriting);
            }
        }

        public String getModelId() {
            return this.modelId;
        }

        public BytesReference getDefinition() {
            return this.definition;
        }

        public int getPart() {
            return this.part;
        }

        public long getTotalDefinitionLength() {
            return this.totalDefinitionLength;
        }

        public int getTotalParts() {
            return this.totalParts;
        }

        public boolean isOverwritingAllowed() {
            return this.allowOverwriting;
        }

        static {
            PARSER.declareField(Builder::setDefinition, XContentParser::binaryValue, DEFINITION, ObjectParser.ValueType.STRING);
            PARSER.declareLong(Builder::setTotalDefinitionLength, TOTAL_DEFINITION_LENGTH);
            PARSER.declareInt(Builder::setTotalParts, TOTAL_PARTS);
        }

        public static class Builder {
            private BytesReference definition;
            private long totalDefinitionLength;
            private int totalParts;

            public Builder setDefinition(byte[] definition) {
                this.definition = new BytesArray(definition);
                return this;
            }

            public Builder setTotalDefinitionLength(long totalDefinitionLength) {
                this.totalDefinitionLength = totalDefinitionLength;
                return this;
            }

            public Builder setTotalParts(int totalParts) {
                this.totalParts = totalParts;
                return this;
            }

            public Request build(String modelId, int part, boolean allowOverwriting) {
                return new Request(modelId, this.definition, part, this.totalDefinitionLength, this.totalParts, allowOverwriting);
            }
        }
    }
}

