/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;

public class RolloverStep
extends AsyncActionStep {
    private static final Logger logger = LogManager.getLogger(RolloverStep.class);
    public static final String NAME = "attempt-rollover";

    public RolloverStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String rolloverTarget;
        boolean targetFailureStore;
        String indexName = indexMetadata.getIndex().getName();
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetadata.getSettings());
        if (indexingComplete) {
            logger.trace("{} has lifecycle complete set, skipping {}", (Object)indexMetadata.getIndex(), (Object)NAME);
            listener.onResponse(null);
            return;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(indexName);
        assert (indexAbstraction != null) : "expected the index " + indexName + " to exist in the lookup but it didn't";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            boolean isFailureStoreWriteIndex = indexMetadata.getIndex().equals((Object)dataStream.getWriteFailureIndex());
            targetFailureStore = dataStream.isFailureStoreIndex(indexMetadata.getIndex().getName());
            if (!isFailureStoreWriteIndex && !dataStream.getWriteIndex().equals((Object)indexMetadata.getIndex())) {
                logger.warn("index [{}] is not the {}write index for data stream [{}]. skipping rollover for policy [{}]", (Object)indexName, (Object)(targetFailureStore ? "failure store " : ""), (Object)dataStream.getName(), (Object)indexMetadata.getLifecyclePolicyName());
                listener.onResponse(null);
                return;
            }
            rolloverTarget = dataStream.getName();
        } else {
            String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetadata.getSettings());
            if (Strings.isNullOrEmpty((String)rolloverAlias)) {
                listener.onFailure((Exception)new IllegalArgumentException(Strings.format((String)"setting [%s] for index [%s] is empty or not defined, it must be set to the name of the alias pointing to the group of indices being rolled over", (Object[])new Object[]{"index.lifecycle.rollover_alias", indexName})));
                return;
            }
            if (indexMetadata.getRolloverInfos().get(rolloverAlias) != null) {
                logger.info("index [{}] was already rolled over for alias [{}], not attempting to roll over again", (Object)indexName, (Object)rolloverAlias);
                listener.onResponse(null);
                return;
            }
            if (!indexMetadata.getAliases().containsKey(rolloverAlias)) {
                listener.onFailure((Exception)new IllegalArgumentException(Strings.format((String)"%s [%s] does not point to index [%s]", (Object[])new Object[]{"index.lifecycle.rollover_alias", rolloverAlias, indexName})));
                return;
            }
            rolloverTarget = rolloverAlias;
            targetFailureStore = false;
        }
        RolloverRequest rolloverRequest = (RolloverRequest)new RolloverRequest(rolloverTarget, null).masterNodeTimeout(TimeValue.MAX_VALUE);
        if (targetFailureStore) {
            rolloverRequest.setRolloverTarget(IndexNameExpressionResolver.combineSelector((String)rolloverTarget, (IndexComponentSelector)IndexComponentSelector.FAILURES));
        }
        rolloverRequest.setWaitForActiveShards(ActiveShardCount.NONE);
        this.getClient(currentState.projectId()).admin().indices().rolloverIndex(rolloverRequest, listener.delegateFailureAndWrap((l, response) -> {
            assert (response.isRolledOver()) : "the only way this rollover call should fail is with an exception";
            if (response.isRolledOver()) {
                l.onResponse(null);
            } else {
                l.onFailure((Exception)new IllegalStateException("unexepected exception on unconditional rollover"));
            }
        }));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RolloverStep other = (RolloverStep)obj;
        return super.equals(obj);
    }
}

