/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotNameAlreadyInUseException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CreateSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "create-snapshot";
    private static final Logger logger = LogManager.getLogger(CreateSnapshotStep.class);
    private final Step.StepKey nextKeyOnComplete;
    private final Step.StepKey nextKeyOnIncomplete;
    private final SetOnce<Boolean> onResponseResult;

    public CreateSnapshotStep(Step.StepKey key, Step.StepKey nextKeyOnComplete, Step.StepKey nextKeyOnIncomplete, Client client) {
        super(key, null, client);
        this.nextKeyOnComplete = nextKeyOnComplete;
        this.nextKeyOnIncomplete = nextKeyOnIncomplete;
        this.onResponseResult = new SetOnce();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(final IndexMetadata indexMetadata, ProjectMetadata currentProject, final ActionListener<Void> listener) {
        this.createSnapshot(currentProject.id(), indexMetadata, new ActionListener<Boolean>(){

            public void onResponse(Boolean complete) {
                CreateSnapshotStep.this.onResponseResult.set((Object)complete);
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof SnapshotNameAlreadyInUseException) {
                    SnapshotNameAlreadyInUseException snapshotNameAlreadyInUseException = (SnapshotNameAlreadyInUseException)e;
                    logger.warn("snapshot [{}] is already in-progress or in-use for index [{}], ILM will attempt to clean it up and recreate it", (Object)snapshotNameAlreadyInUseException.getSnapshotName(), (Object)indexMetadata.getIndex().getName());
                    this.onResponse(false);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    void createSnapshot(ProjectId projectId, IndexMetadata indexMetadata, ActionListener<Boolean> listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String policyName = indexMetadata.getLifecyclePolicyName();
        String snapshotRepository = lifecycleState.snapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String snapshotName = lifecycleState.snapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        CreateSnapshotRequest request = new CreateSnapshotRequest(TimeValue.MAX_VALUE, snapshotRepository, snapshotName);
        request.indices(new String[]{indexName});
        request.waitForCompletion(true);
        request.includeGlobalState(false);
        this.getClient(projectId).admin().cluster().createSnapshot(request, listener.map(response -> {
            logger.debug("create snapshot response for policy [{}] and index [{}] is: {}", (Object)policyName, (Object)indexName, (Object)Strings.toString((ToXContent)response));
            SnapshotInfo snapInfo = response.getSnapshotInfo();
            if (snapInfo.failedShards() == 0) {
                return true;
            }
            logger.warn(Strings.format((String)"failed to create snapshot [%s:%s] for policy [%s] and index [%s]: %s of %s shards failed", (Object[])new Object[]{snapshotRepository, snapshotName, policyName, indexName, snapInfo.failedShards(), snapInfo.totalShards()}));
            return false;
        }));
    }

    @Override
    public final Step.StepKey getNextStepKey() {
        if (this.onResponseResult.get() == null) {
            throw new IllegalStateException("cannot call getNextStepKey before performAction");
        }
        return (Boolean)this.onResponseResult.get() != false ? this.nextKeyOnComplete : this.nextKeyOnIncomplete;
    }

    Step.StepKey getNextKeyOnIncomplete() {
        return this.nextKeyOnIncomplete;
    }

    Step.StepKey getNextKeyOnComplete() {
        return this.nextKeyOnComplete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateSnapshotStep that = (CreateSnapshotStep)o;
        return Objects.equals(this.nextKeyOnComplete, that.nextKeyOnComplete) && Objects.equals(this.nextKeyOnIncomplete, that.nextKeyOnIncomplete);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextKeyOnComplete, this.nextKeyOnIncomplete);
    }
}

