/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.search.aggregations;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.core.Releasable;

public class MissingHelper
implements Releasable {
    private final BigArrays bigArrays;
    private BitArray tracker;

    public MissingHelper(BigArrays bigArrays) {
        this.bigArrays = bigArrays;
    }

    public void markMissing(long index) {
        if (this.tracker == null) {
            this.tracker = new BitArray(index, this.bigArrays);
        }
        this.tracker.set(index);
    }

    public void markNotMissing(long index) {
        if (this.tracker == null) {
            return;
        }
        this.tracker.clear(index);
    }

    public void swap(long lhs, long rhs) {
        if (this.tracker == null) {
            return;
        }
        boolean backup = this.tracker.get(lhs);
        if (this.tracker.get(rhs)) {
            this.tracker.set(lhs);
        } else {
            this.tracker.clear(lhs);
        }
        if (backup) {
            this.tracker.set(rhs);
        } else {
            this.tracker.clear(rhs);
        }
    }

    public boolean isEmpty(long index) {
        if (this.tracker == null) {
            return false;
        }
        return this.tracker.get(index);
    }

    public void close() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }
}

