/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseCacheManagement;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.WaitForSnapshotAction;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleRequest;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class TransportPutLifecycleAction
extends TransportMasterNodeAction<PutLifecycleRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutLifecycleAction.class);
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final ProjectResolver projectResolver;
    private final MasterServiceTaskQueue<UpdateLifecyclePolicyTask> taskQueue;

    @Inject
    public TransportPutLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, NamedXContentRegistry namedXContentRegistry, XPackLicenseState licenseState, Client client, ProjectResolver projectResolver) {
        super(ILMActions.PUT.name(), transportService, clusterService, threadPool, actionFilters, PutLifecycleRequest::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.xContentRegistry = namedXContentRegistry;
        this.licenseState = licenseState;
        this.client = client;
        this.projectResolver = projectResolver;
        this.taskQueue = clusterService.createTaskQueue("ilm-put-lifecycle-queue", Priority.NORMAL, (ClusterStateTaskExecutor)new IlmLifecycleExecutor());
    }

    protected void masterOperation(Task task, PutLifecycleRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)state);
        LifecyclePolicy.validatePolicyName((String)request.getPolicy().getName());
        request.getPolicy().maybeAddDeprecationWarningForFreezeAction(request.getPolicy().getName());
        ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(state);
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)projectMetadata.custom("index_lifecycle", (Metadata.ProjectCustom)IndexLifecycleMetadata.EMPTY);
        LifecyclePolicyMetadata existingPolicy = (LifecyclePolicyMetadata)lifecycleMetadata.getPolicyMetadatas().get(request.getPolicy().getName());
        if (TransportPutLifecycleAction.isNoopUpdate(existingPolicy, request.getPolicy(), filteredHeaders)) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        UpdateLifecyclePolicyTask putTask = new UpdateLifecyclePolicyTask(projectMetadata.id(), request, listener, this.licenseState, filteredHeaders, this.xContentRegistry, this.client);
        this.taskQueue.submitTask("put-lifecycle-" + request.getPolicy().getName(), (ClusterStateTaskListener)putTask, putTask.timeout());
    }

    static boolean isNoopUpdate(@Nullable LifecyclePolicyMetadata existingPolicy, LifecyclePolicy newPolicy, Map<String, String> filteredHeaders) {
        if (existingPolicy == null) {
            return false;
        }
        return newPolicy.equals((Object)existingPolicy.getPolicy()) && filteredHeaders.equals(existingPolicy.getHeaders());
    }

    private static void validatePrerequisites(LifecyclePolicy policy, ProjectState state, XPackLicenseState licenseState) {
        List<Phase> phasesWithSearchableSnapshotActions = policy.getPhases().values().stream().filter(phase -> phase.getActions().containsKey("searchable_snapshot")).toList();
        if (!phasesWithSearchableSnapshotActions.isEmpty() && !SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOT_FEATURE.checkWithoutTracking(licenseState)) {
            throw new IllegalArgumentException("policy [" + policy.getName() + "] defines the [searchable_snapshot] action but the current license is non-compliant for [searchable-snapshots]");
        }
        for (Phase phase2 : phasesWithSearchableSnapshotActions) {
            SearchableSnapshotAction action = (SearchableSnapshotAction)phase2.getActions().get("searchable_snapshot");
            String repository = action.getSnapshotRepository();
            if (RepositoriesMetadata.get((ClusterState)state.cluster()).repository(repository) != null) continue;
            throw new IllegalArgumentException("no such repository [" + repository + "], the snapshot repository referenced by the [searchable_snapshot] action in the [" + phase2.getName() + "] phase must exist before it can be referenced by an ILM policy");
        }
        List<Phase> phasesWithWaitForSnapshotActions = policy.getPhases().values().stream().filter(phase -> phase.getActions().containsKey("wait_for_snapshot")).toList();
        for (Phase phase3 : phasesWithWaitForSnapshotActions) {
            WaitForSnapshotAction action = (WaitForSnapshotAction)phase3.getActions().get("wait_for_snapshot");
            String slmPolicy = action.getPolicy();
            if (((SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle", (Metadata.ProjectCustom)SnapshotLifecycleMetadata.EMPTY)).getSnapshotConfigurations().get(slmPolicy) != null) continue;
            throw new IllegalArgumentException("no such snapshot lifecycle policy [" + slmPolicy + "], the snapshot lifecycle policy referenced by the [wait_for_snapshot] action in the [" + phase3.getName() + "] phase must exist before it can be referenced by an ILM policy");
        }
    }

    protected ClusterBlockException checkBlock(PutLifecycleRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("ilm");
    }

    public Set<String> modifiedKeys(PutLifecycleRequest request) {
        return Set.of(request.getPolicy().getName());
    }

    private static class IlmLifecycleExecutor
    extends SimpleBatchedAckListenerTaskExecutor<UpdateLifecyclePolicyTask> {
        private IlmLifecycleExecutor() {
        }

        public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateLifecyclePolicyTask task, ClusterState clusterState) throws Exception {
            return Tuple.tuple((Object)task.execute(clusterState), (Object)((Object)task));
        }
    }

    public static class UpdateLifecyclePolicyTask
    extends AckedClusterStateUpdateTask {
        private final ProjectId projectId;
        private final PutLifecycleRequest request;
        private final XPackLicenseState licenseState;
        private final Map<String, String> filteredHeaders;
        private final NamedXContentRegistry xContentRegistry;
        private final Client client;
        private final boolean verboseLogging;

        public UpdateLifecyclePolicyTask(ProjectId projectId, PutLifecycleRequest request, ActionListener<AcknowledgedResponse> listener, XPackLicenseState licenseState, Map<String, String> filteredHeaders, NamedXContentRegistry xContentRegistry, Client client) {
            super((AcknowledgedRequest)request, listener);
            this.projectId = projectId;
            this.request = request;
            this.licenseState = licenseState;
            this.filteredHeaders = filteredHeaders;
            this.xContentRegistry = xContentRegistry;
            this.client = client;
            this.verboseLogging = true;
        }

        UpdateLifecyclePolicyTask(ProjectId projectId, PutLifecycleRequest request, XPackLicenseState licenseState, NamedXContentRegistry xContentRegistry, Client client) {
            super((AcknowledgedRequest)request, null);
            this.projectId = projectId;
            this.request = request;
            this.licenseState = licenseState;
            this.filteredHeaders = Collections.emptyMap();
            this.xContentRegistry = xContentRegistry;
            this.client = client;
            this.verboseLogging = false;
        }

        public ClusterState execute(ClusterState clusterState) throws Exception {
            ProjectState projectState = clusterState.projectState(this.projectId);
            IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)projectState.metadata().custom("index_lifecycle", (Metadata.ProjectCustom)IndexLifecycleMetadata.EMPTY);
            LifecyclePolicyMetadata existingPolicyMetadata = (LifecyclePolicyMetadata)currentMetadata.getPolicyMetadatas().get(this.request.getPolicy().getName());
            if (TransportPutLifecycleAction.isNoopUpdate(existingPolicyMetadata, this.request.getPolicy(), this.filteredHeaders)) {
                return clusterState;
            }
            TransportPutLifecycleAction.validatePrerequisites(this.request.getPolicy(), projectState, this.licenseState);
            long nextVersion = existingPolicyMetadata == null ? 1L : existingPolicyMetadata.getVersion() + 1L;
            TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>(currentMetadata.getPolicyMetadatas());
            LifecyclePolicyMetadata lifecyclePolicyMetadata = new LifecyclePolicyMetadata(this.request.getPolicy(), this.filteredHeaders, nextVersion, Instant.now().toEpochMilli());
            LifecyclePolicyMetadata oldPolicy = newPolicies.put(lifecyclePolicyMetadata.getName(), lifecyclePolicyMetadata);
            if (this.verboseLogging) {
                if (oldPolicy == null) {
                    logger.info("adding index lifecycle policy [{}]", (Object)this.request.getPolicy().getName());
                } else {
                    logger.info("updating index lifecycle policy [{}]", (Object)this.request.getPolicy().getName());
                }
            }
            IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, LifecycleOperationMetadata.currentILMMode((ProjectMetadata)projectState.metadata()));
            ProjectMetadata newProjectMetadata = ProjectMetadata.builder((ProjectMetadata)projectState.metadata()).putCustom("index_lifecycle", (Metadata.ProjectCustom)newMetadata).build();
            ClusterState nonRefreshedState = ClusterState.builder((ClusterState)clusterState).putProjectMetadata(newProjectMetadata).build();
            if (oldPolicy == null) {
                return nonRefreshedState;
            }
            try {
                ProjectMetadata refreshedProjectMetadata = PhaseCacheManagement.updateIndicesForPolicy((ProjectMetadata)newProjectMetadata, (NamedXContentRegistry)this.xContentRegistry, (Client)this.client, (LifecyclePolicy)oldPolicy.getPolicy(), (LifecyclePolicyMetadata)lifecyclePolicyMetadata, (XPackLicenseState)this.licenseState);
                return ClusterState.builder((ClusterState)clusterState).putProjectMetadata(refreshedProjectMetadata).build();
            }
            catch (Exception e) {
                logger.warn(() -> "unable to refresh indices phase JSON for updated policy [" + oldPolicy.getName() + "]", (Throwable)e);
                return nonRefreshedState;
            }
        }
    }
}

