/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedBatchedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.migrate.action.CopyLifecycleIndexMetadataAction;

public class CopyLifecycleIndexMetadataTransportAction
extends TransportMasterNodeAction<CopyLifecycleIndexMetadataAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(CopyLifecycleIndexMetadataTransportAction.class);
    private final ClusterStateTaskExecutor<UpdateIndexMetadataTask> executor = new SimpleBatchedAckListenerTaskExecutor<UpdateIndexMetadataTask>(this){

        public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateIndexMetadataTask task, ClusterState clusterState) {
            return new Tuple((Object)CopyLifecycleIndexMetadataTransportAction.applyUpdate(clusterState, task), (Object)task);
        }
    };
    private final MasterServiceTaskQueue<UpdateIndexMetadataTask> taskQueue;

    @Inject
    public CopyLifecycleIndexMetadataTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("indices:admin/index/copy_lifecycle_index_metadata", transportService, clusterService, threadPool, actionFilters, CopyLifecycleIndexMetadataAction.Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.taskQueue = clusterService.createTaskQueue("migrate-copy-index-metadata", Priority.NORMAL, this.executor);
    }

    protected void masterOperation(Task task, CopyLifecycleIndexMetadataAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.taskQueue.submitTask("migrate-copy-index-metadata", (ClusterStateTaskListener)new UpdateIndexMetadataTask(request.sourceIndex(), request.destIndex(), request.ackTimeout(), listener), request.masterNodeTimeout());
    }

    protected ClusterBlockException checkBlock(CopyLifecycleIndexMetadataAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static ClusterState applyUpdate(ClusterState state, UpdateIndexMetadataTask updateTask) {
        IndexMetadata sourceMetadata = state.metadata().getProject().index(updateTask.sourceIndex);
        if (sourceMetadata == null) {
            throw new IndexNotFoundException(updateTask.sourceIndex);
        }
        IndexMetadata destMetadata = state.metadata().getProject().index(updateTask.destIndex);
        if (destMetadata == null) {
            throw new IndexNotFoundException(updateTask.destIndex);
        }
        IndexMetadata.Builder newDestMetadata = IndexMetadata.builder((IndexMetadata)destMetadata);
        Map sourceILM = sourceMetadata.getCustomData("ilm");
        if (sourceILM != null) {
            newDestMetadata.putCustom("ilm", sourceILM);
        }
        newDestMetadata.putRolloverInfos(sourceMetadata.getRolloverInfos()).creationDate(sourceMetadata.getCreationDate()).settingsVersion(destMetadata.getSettingsVersion() + 1L);
        HashMap<String, IndexMetadata> indices = new HashMap<String, IndexMetadata>(state.metadata().getProject().indices());
        indices.put(updateTask.destIndex, newDestMetadata.build());
        Metadata newMetadata = Metadata.builder((Metadata)state.metadata()).indices(indices).build();
        return ClusterState.builder((ClusterState)state).metadata(newMetadata).build();
    }

    static class UpdateIndexMetadataTask
    extends AckedBatchedClusterStateUpdateTask {
        private final String sourceIndex;
        private final String destIndex;

        UpdateIndexMetadataTask(String sourceIndex, String destIndex, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.sourceIndex = sourceIndex;
            this.destIndex = destIndex;
        }
    }
}

