/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.core;

import java.util.concurrent.TimeUnit;

public class TimeValue {
    private final long duration;
    private final TimeUnit timeUnit;

    public TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public static TimeValue timeValueMillis(long millis) {
        return new TimeValue(millis, TimeUnit.MILLISECONDS);
    }

    public static TimeValue timeValueSeconds(long seconds) {
        return new TimeValue(seconds, TimeUnit.SECONDS);
    }

    public static TimeValue timeValueMinutes(long minutes) {
        return new TimeValue(minutes, TimeUnit.MINUTES);
    }

    public static TimeValue timeValueHours(long hours) {
        return new TimeValue(hours, TimeUnit.HOURS);
    }

    public static TimeValue timeValueDays(long days) {
        if (days > 106751L) {
            throw new IllegalArgumentException("time value cannot store values greater than 106751 days");
        }
        return new TimeValue(days, TimeUnit.DAYS);
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public long duration() {
        return this.duration;
    }

    public String toString() {
        return this.getStringRep();
    }

    public String getStringRep() {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return this.duration + "nanos";
            }
            case MICROSECONDS: {
                return this.duration + "micros";
            }
            case MILLISECONDS: {
                return this.duration + "ms";
            }
            case SECONDS: {
                return this.duration + "s";
            }
            case MINUTES: {
                return this.duration + "m";
            }
            case HOURS: {
                return this.duration + "h";
            }
            case DAYS: {
                return this.duration + "d";
            }
        }
        throw new IllegalArgumentException("unknown time unit: " + this.timeUnit.name());
    }
}

