/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.BlobStoreCacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.CachedBlob;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.recovery.SearchableSnapshotRecoveryState;
import org.elasticsearch.xpack.searchablesnapshots.store.BlobContainerSupplier;
import org.elasticsearch.xpack.searchablesnapshots.store.InMemoryNoOpCommitDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.RepositorySupplier;
import org.elasticsearch.xpack.searchablesnapshots.store.input.CachedBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.store.input.ChecksumBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.store.input.DirectBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.store.input.FrozenIndexInput;

public class SearchableSnapshotDirectory
extends BaseDirectory {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotDirectory.class);
    private final Supplier<BlobContainer> blobContainerSupplier;
    private final Supplier<BlobStoreIndexShardSnapshot> snapshotSupplier;
    private final BlobStoreCacheService blobStoreCacheService;
    private final String repository;
    private final SnapshotId snapshotId;
    private final IndexId indexId;
    private final ShardId shardId;
    private final LongSupplier statsCurrentTimeNanosSupplier;
    private final Map<String, IndexInputStats> stats;
    private final ThreadPool threadPool;
    private final CacheService cacheService;
    private final boolean useCache;
    private final boolean prewarmCache;
    private final Set<String> excludedFileTypes;
    private final long uncachedChunkSize;
    private final Path cacheDir;
    private final ShardPath shardPath;
    private final AtomicBoolean closed;
    private final boolean partial;
    private final SharedBlobCacheService<CacheKey> sharedBlobCacheService;
    private final ByteSizeValue blobStoreCacheMaxLength;
    private volatile BlobStoreIndexShardSnapshot snapshot;
    private volatile boolean loaded;
    private volatile SearchableSnapshotRecoveryState recoveryState;

    public SearchableSnapshotDirectory(Supplier<BlobContainer> blobContainer, Supplier<BlobStoreIndexShardSnapshot> snapshot, BlobStoreCacheService blobStoreCacheService, String repository, SnapshotId snapshotId, IndexId indexId, ShardId shardId, Settings indexSettings, LongSupplier currentTimeNanosSupplier, CacheService cacheService, Path cacheDir, ShardPath shardPath, ThreadPool threadPool, SharedBlobCacheService<CacheKey> sharedBlobCacheService) {
        super((LockFactory)new SingleInstanceLockFactory());
        this.snapshotSupplier = Objects.requireNonNull(snapshot);
        this.blobContainerSupplier = Objects.requireNonNull(blobContainer);
        this.blobStoreCacheService = Objects.requireNonNull(blobStoreCacheService);
        this.repository = Objects.requireNonNull(repository);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indexId = Objects.requireNonNull(indexId);
        this.shardId = Objects.requireNonNull(shardId);
        this.stats = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        this.statsCurrentTimeNanosSupplier = Objects.requireNonNull(currentTimeNanosSupplier);
        this.cacheService = Objects.requireNonNull(cacheService);
        this.cacheDir = Objects.requireNonNull(cacheDir);
        this.shardPath = Objects.requireNonNull(shardPath);
        this.closed = new AtomicBoolean(false);
        this.useCache = (Boolean)SearchableSnapshots.SNAPSHOT_CACHE_ENABLED_SETTING.get(indexSettings);
        this.partial = (Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(indexSettings);
        this.prewarmCache = !this.partial && this.useCache ? (Boolean)SearchableSnapshots.SNAPSHOT_CACHE_PREWARM_ENABLED_SETTING.get(indexSettings) : false;
        this.excludedFileTypes = new HashSet<String>((Collection)SearchableSnapshots.SNAPSHOT_CACHE_EXCLUDED_FILE_TYPES_SETTING.get(indexSettings));
        this.uncachedChunkSize = ((ByteSizeValue)SearchableSnapshots.SNAPSHOT_UNCACHED_CHUNK_SIZE_SETTING.get(indexSettings)).getBytes();
        this.blobStoreCacheMaxLength = (ByteSizeValue)SearchableSnapshots.SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH_SETTING.get(indexSettings);
        this.threadPool = threadPool;
        this.loaded = false;
        this.sharedBlobCacheService = sharedBlobCacheService;
        assert (this.invariant());
    }

    private synchronized boolean invariant() {
        assert (this.loaded != (this.snapshot == null));
        assert (this.loaded != (this.recoveryState == null));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSnapshot(RecoveryState snapshotRecoveryState, Supplier<Boolean> cancelPreWarming, ActionListener<Void> preWarmListener) {
        assert (snapshotRecoveryState != null);
        assert (snapshotRecoveryState instanceof SearchableSnapshotRecoveryState);
        assert (snapshotRecoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT || snapshotRecoveryState.getRecoverySource().getType() == RecoverySource.Type.PEER) : snapshotRecoveryState.getRecoverySource().getType();
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        if (!(snapshotRecoveryState instanceof SearchableSnapshotRecoveryState)) {
            throw new IllegalArgumentException("A SearchableSnapshotRecoveryState instance was expected");
        }
        boolean alreadyLoaded = this.loaded;
        if (!alreadyLoaded) {
            SearchableSnapshotDirectory searchableSnapshotDirectory = this;
            synchronized (searchableSnapshotDirectory) {
                alreadyLoaded = this.loaded;
                if (!alreadyLoaded) {
                    this.snapshot = this.snapshotSupplier.get();
                    this.loaded = true;
                    this.cleanExistingRegularShardFiles();
                    this.waitForPendingEvictions();
                    this.recoveryState = (SearchableSnapshotRecoveryState)snapshotRecoveryState;
                    this.prewarmCache(preWarmListener, cancelPreWarming);
                }
            }
        }
        assert (this.invariant());
        return !alreadyLoaded;
    }

    public BlobContainer blobContainer() {
        BlobContainer blobContainer = this.blobContainerSupplier.get();
        assert (blobContainer != null);
        return blobContainer;
    }

    public BlobStoreIndexShardSnapshot snapshot() {
        BlobStoreIndexShardSnapshot snapshot = this.snapshot;
        assert (snapshot != null);
        return snapshot;
    }

    private List<BlobStoreIndexShardSnapshot.FileInfo> files() {
        if (!this.loaded) {
            return List.of();
        }
        List files = this.snapshot().indexFiles();
        assert (files != null);
        assert (files.size() > 0);
        return files;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Map<String, IndexInputStats> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }

    @Nullable
    IndexInputStats getStats(String fileName) {
        return this.stats.get(SearchableSnapshotDirectory.getNonNullFileExt(fileName));
    }

    public void clearStats() {
        this.stats.clear();
    }

    private BlobStoreIndexShardSnapshot.FileInfo fileInfo(String name) throws FileNotFoundException {
        return this.files().stream().filter(fileInfo -> fileInfo.physicalName().equals(name)).findFirst().orElseThrow(() -> new FileNotFoundException(name));
    }

    public final String[] listAll() {
        this.ensureOpen();
        return this.listAllFiles();
    }

    private String[] listAllFiles() {
        return (String[])this.files().stream().map(BlobStoreIndexShardSnapshot.FileInfo::physicalName).sorted(String::compareTo).toArray(String[]::new);
    }

    public final long fileLength(String name) throws IOException {
        this.ensureOpen();
        return this.fileInfo(name).length();
    }

    public Set<String> getPendingDeletions() {
        throw this.unsupportedException("getPendingDeletions");
    }

    public void sync(Collection<String> names) {
    }

    public void syncMetaData() {
    }

    public void deleteFile(String name) {
        throw this.unsupportedException("deleteFile(" + name + ")");
    }

    public IndexOutput createOutput(String name, IOContext context) {
        throw this.unsupportedException("createOutput(" + name + ", " + String.valueOf(context) + ")");
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw this.unsupportedException("createTempOutput(" + prefix + ", " + suffix + ", " + String.valueOf(context) + ")");
    }

    public void rename(String source, String dest) {
        throw this.unsupportedException("rename(" + source + ", " + dest + ")");
    }

    private UnsupportedOperationException unsupportedException(String description) {
        String message = "Searchable snapshot directory does not support the operation [" + description + "]";
        assert (false) : message + ", current directory files: " + org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])this.listAllFiles());
        return new UnsupportedOperationException(message);
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.isOpen = false;
        }
    }

    public void clearCache(boolean clearCacheService, boolean clearFrozenCacheService) {
        for (BlobStoreIndexShardSnapshot.FileInfo file : this.files()) {
            CacheKey cacheKey = this.createCacheKey(file.physicalName());
            if (clearCacheService) {
                this.cacheService.removeFromCache(cacheKey);
            }
            if (!clearFrozenCacheService) continue;
            this.sharedBlobCacheService.removeFromCache((Object)cacheKey);
        }
    }

    protected IndexInputStats createIndexInputStats(long numFiles, long totalSize, long minSize, long maxSize) {
        return new IndexInputStats(numFiles, totalSize, minSize, maxSize, this.statsCurrentTimeNanosSupplier);
    }

    public CacheKey createCacheKey(String fileName) {
        return new CacheKey(this.snapshotId.getUUID(), this.indexId.getName(), this.shardId, fileName);
    }

    public CacheFile getCacheFile(CacheKey cacheKey, long fileLength) throws Exception {
        return this.cacheService.get(cacheKey, fileLength, this.cacheDir);
    }

    public Executor cacheFetchAsyncExecutor() {
        return this.threadPool.executor("searchable_snapshots_cache_fetch_async");
    }

    public Executor prewarmExecutor() {
        return this.threadPool.executor("searchable_snapshots_cache_prewarming");
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        BlobStoreIndexShardSnapshot.FileInfo fileInfo = this.fileInfo(name);
        if (fileInfo.metadata().hashEqualsContents()) {
            BytesRef content = fileInfo.metadata().hash();
            return new ByteArrayIndexInput("ByteArrayIndexInput(" + name + ")", content.bytes, content.offset, content.length);
        }
        if (context == Store.READONCE_CHECKSUM) {
            return ChecksumBlobContainerIndexInput.create(fileInfo.physicalName(), fileInfo.length(), fileInfo.checksum(), context);
        }
        String ext = SearchableSnapshotDirectory.getNonNullFileExt(name);
        IndexInputStats inputStats = this.stats.computeIfAbsent(ext, n -> {
            IndexInputStats.Counter counter = new IndexInputStats.Counter();
            for (BlobStoreIndexShardSnapshot.FileInfo file : this.files()) {
                if (!n.equals(SearchableSnapshotDirectory.getNonNullFileExt(file.physicalName()))) continue;
                counter.add(file.length());
            }
            return this.createIndexInputStats(counter.count(), counter.total(), counter.min(), counter.max());
        });
        if (this.useCache && !this.isExcludedFromCache(name)) {
            if (this.partial) {
                return new FrozenIndexInput(name, this, fileInfo, context, inputStats, this.sharedBlobCacheService.getRangeSize(), this.sharedBlobCacheService.getRecoveryRangeSize());
            }
            return new CachedBlobContainerIndexInput(name, this, fileInfo, context, inputStats, this.cacheService.getRangeSize(), this.cacheService.getRecoveryRangeSize());
        }
        return new DirectBlobContainerIndexInput(name, this.blobContainer(), fileInfo, context, inputStats, this.getUncachedChunkSize());
    }

    static String getNonNullFileExt(String name) {
        String ext = IndexFileNames.getExtension((String)name);
        return ext == null ? "" : ext;
    }

    private long getUncachedChunkSize() {
        if (this.uncachedChunkSize < 0L) {
            return this.blobContainer().readBlobPreferredLength();
        }
        return this.uncachedChunkSize;
    }

    private boolean isExcludedFromCache(String name) {
        String ext = IndexFileNames.getExtension((String)name);
        return ext != null && this.excludedFileTypes.contains(ext);
    }

    public boolean isRecoveryFinalized() {
        SearchableSnapshotRecoveryState recoveryState = this.recoveryState;
        if (recoveryState == null) {
            return false;
        }
        RecoveryState.Stage stage = recoveryState.getStage();
        return stage == RecoveryState.Stage.DONE || stage == RecoveryState.Stage.FINALIZE;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(snapshotId=" + String.valueOf(this.snapshotId) + ", indexId=" + String.valueOf(this.indexId) + " shardId=" + String.valueOf(this.shardId) + ")";
    }

    private void cleanExistingRegularShardFiles() {
        try {
            IOUtils.rm((Path[])new Path[]{this.shardPath.resolveIndex(), this.shardPath.resolveTranslog()});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void waitForPendingEvictions() {
        assert (Thread.holdsLock((Object)this));
        this.cacheService.waitForCacheFilesEvictionIfNeeded(this.snapshotId.getUUID(), this.indexId.getName(), this.shardId);
    }

    private void prewarmCache(ActionListener<Void> listener, Supplier<Boolean> cancelPreWarming) {
        try (RefCountingListener completionListener = new RefCountingListener(listener.map(v -> {
            this.recoveryState.setPreWarmComplete();
            return v;
        }));){
            if (!this.prewarmCache || cancelPreWarming.get().booleanValue()) {
                return;
            }
            ThrottledTaskRunner prewarmTaskRunner = new ThrottledTaskRunner("prewarm_task_runner" + String.valueOf(this.shardId), this.threadPool.info("searchable_snapshots_cache_prewarming").getMax(), this.prewarmExecutor());
            for (BlobStoreIndexShardSnapshot.FileInfo file : this.snapshot().indexFiles()) {
                if (cancelPreWarming.get().booleanValue()) {
                    return;
                }
                boolean hashEqualsContents = file.metadata().hashEqualsContents();
                if (hashEqualsContents || this.isExcludedFromCache(file.physicalName())) {
                    if (hashEqualsContents) {
                        this.recoveryState.getIndex().addFileDetail(file.physicalName(), file.length(), true);
                        continue;
                    }
                    this.recoveryState.ignoreFile(file.physicalName());
                    continue;
                }
                this.recoveryState.getIndex().addFileDetail(file.physicalName(), file.length(), false);
                try {
                    IndexInput input = this.openInput(file.physicalName(), CachedBlobContainerIndexInput.CACHE_WARMING_CONTEXT);
                    assert (input instanceof CachedBlobContainerIndexInput) : "expected cached index input but got " + String.valueOf(input.getClass());
                    CachedBlobContainerIndexInput cachedIndexInput = (CachedBlobContainerIndexInput)input;
                    AtomicBoolean alreadyCached = new AtomicBoolean();
                    try (RefCountingListener fileListener = new RefCountingListener(ActionListener.runBefore((ActionListener)completionListener.acquire(v -> {
                        if (alreadyCached.get()) {
                            this.recoveryState.markIndexFileAsReused(file.physicalName());
                        } else {
                            this.recoveryState.getIndex().addRecoveredFromSnapshotBytesToFile(file.physicalName(), file.length());
                        }
                    }), () -> IOUtils.closeWhileHandlingException((Closeable)((Object)cachedIndexInput))));){
                        if (cachedIndexInput.getPersistentCacheInitialLength() == file.length()) {
                            alreadyCached.set(true);
                            logger.trace("{} file [{}] is already available in cache ({} bytes)", (Object)this.shardId, (Object)file.physicalName(), (Object)file.length());
                            continue;
                        }
                        int p = 0;
                        while (p < file.numberOfParts()) {
                            int part = p++;
                            prewarmTaskRunner.enqueueTask(fileListener.acquire(releasable -> {
                                try (Releasable releasable2 = releasable;){
                                    String fileName = file.physicalName();
                                    long startTimeInNanos = this.statsCurrentTimeNanosSupplier.getAsLong();
                                    long prefetchedPartBytes = cachedIndexInput.prefetchPart(part, cancelPreWarming);
                                    if (prefetchedPartBytes > -1L && logger.isTraceEnabled()) {
                                        logger.trace("{} part [{}/{}] of [{}] warmed in [{}] ms ({} bytes)", (Object)this.shardId, (Object)(part + 1), (Object)file.numberOfParts(), (Object)fileName, (Object)TimeValue.timeValueNanos((long)(this.statsCurrentTimeNanosSupplier.getAsLong() - startTimeInNanos)).millis(), (Object)prefetchedPartBytes);
                                    }
                                }
                            }));
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn(() -> Strings.format((String)"%s unable to prewarm file [%s]", (Object[])new Object[]{this.shardId, file.physicalName()}), (Throwable)e);
                }
            }
        }
    }

    public static Directory create(RepositoriesService repositories, CacheService cache, IndexSettings indexSettings, ShardPath shardPath, LongSupplier currentTimeNanosSupplier, ThreadPool threadPool, BlobStoreCacheService blobStoreCacheService, SharedBlobCacheService<CacheKey> sharedBlobCacheService) throws IOException {
        if (!(SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.exists(indexSettings.getSettings()))) {
            throw new IllegalArgumentException("directly setting [" + IndexModule.INDEX_STORE_TYPE_SETTING.getKey() + "] to [snapshot] is not permitted; use the mount snapshot API instead");
        }
        if (indexSettings.hasCustomDataPath()) {
            throw new IllegalArgumentException("setting [" + IndexMetadata.INDEX_DATA_PATH_SETTING.getKey() + "] is not permitted on searchable snapshots, but was [" + (String)IndexMetadata.INDEX_DATA_PATH_SETTING.get(indexSettings.getSettings()) + "]");
        }
        RepositorySupplier repositorySupplier = new RepositorySupplier(repositories, (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(indexSettings.getSettings()), SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.exists(indexSettings.getSettings()) ? (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.get(indexSettings.getSettings()) : null);
        BlobStoreRepository initialRepository = (BlobStoreRepository)repositorySupplier.get();
        IndexId indexId = new IndexId((String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings.getSettings()));
        SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()));
        BlobContainerSupplier blobContainerSupplier = new BlobContainerSupplier(repositorySupplier, indexId, shardPath.getShardId().id());
        LazyInitializable lazySnapshot = new LazyInitializable(() -> SearchableSnapshotDirectory.lambda$create$9((Supplier)repositorySupplier, (Supplier)blobContainerSupplier, snapshotId));
        Path cacheDir = CacheService.getShardCachePath(shardPath).resolve(snapshotId.getUUID());
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        SearchableSnapshotDirectory dir = new SearchableSnapshotDirectory(blobContainerSupplier, () -> ((LazyInitializable)lazySnapshot).getOrCompute(), blobStoreCacheService, initialRepository.getMetadata().name(), snapshotId, indexId, shardPath.getShardId(), indexSettings.getSettings(), currentTimeNanosSupplier, cache, cacheDir, shardPath, threadPool, sharedBlobCacheService);
        IndexVersion version = (IndexVersion)IndexMetadata.SETTING_INDEX_VERSION_COMPATIBILITY.get(indexSettings.getSettings());
        if (version.before((VersionId)IndexVersions.UPGRADE_TO_LUCENE_10_0_0) || indexSettings.getIndexVersionCreated().isLegacyIndexVersion()) {
            return new InMemoryNoOpCommitDirectory((Directory)dir);
        }
        return dir;
    }

    public static SearchableSnapshotDirectory unwrapDirectory(Directory dir) {
        while (dir != null) {
            if (dir instanceof SearchableSnapshotDirectory) {
                return (SearchableSnapshotDirectory)dir;
            }
            if (dir instanceof InMemoryNoOpCommitDirectory) {
                dir = ((InMemoryNoOpCommitDirectory)dir).getRealDirectory();
                continue;
            }
            if (dir instanceof FilterDirectory) {
                dir = ((FilterDirectory)dir).getDelegate();
                continue;
            }
            dir = null;
        }
        return null;
    }

    public ByteRange getBlobCacheByteRange(String fileName, long fileLength) {
        return this.blobStoreCacheService.computeBlobCacheByteRange(this.shardId, fileName, fileLength, this.blobStoreCacheMaxLength);
    }

    public CachedBlob getCachedBlob(String name, ByteRange range) {
        return this.blobStoreCacheService.get(this.repository, this.snapshotId, this.indexId, this.shardId, name, range);
    }

    public void putCachedBlob(String name, ByteRange range, BytesReference content, ActionListener<Void> listener) {
        this.blobStoreCacheService.putAsync(this.repository, this.snapshotId, this.indexId, this.shardId, name, range, content, this.threadPool.absoluteTimeInMillis(), listener);
    }

    public SharedBlobCacheService.CacheFile getFrozenCacheFile(String fileName, long length) {
        return this.sharedBlobCacheService.getCacheFile((Object)this.createCacheKey(fileName), length);
    }

    private static /* synthetic */ BlobStoreIndexShardSnapshot lambda$create$9(Supplier repositorySupplier, Supplier blobContainerSupplier, SnapshotId snapshotId) throws RuntimeException {
        return ((BlobStoreRepository)repositorySupplier.get()).loadShardSnapshot((BlobContainer)blobContainerSupplier.get(), snapshotId);
    }
}

