/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestModifyDataStreamsAction
extends BaseRestHandler {
    public String getName() {
        return "modify_data_stream_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_data_stream/_modify"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ModifyDataStreamsAction.Request modifyDsRequest;
        try (XContentParser parser = request.contentParser();){
            modifyDsRequest = (ModifyDataStreamsAction.Request)ModifyDataStreamsAction.Request.PARSER.parse(parser, actions -> new ModifyDataStreamsAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request), RestUtils.getAckTimeout((RestRequest)request), actions));
        }
        if (modifyDsRequest.getActions() == null || modifyDsRequest.getActions().isEmpty()) {
            throw new IllegalArgumentException("no data stream actions specified, at least one must be specified");
        }
        return channel -> client.execute((ActionType)ModifyDataStreamsAction.INSTANCE, (ActionRequest)modifyDsRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

