/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.HealthPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.cluster.action.MigrateToDataTiersAction;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.DeleteAction;
import org.elasticsearch.xpack.core.ilm.DownsampleAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.FreezeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.MigrateAction;
import org.elasticsearch.xpack.core.ilm.ReadOnlyAction;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.WaitForSnapshotAction;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.ExplainLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetStatusAction;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.IlmHealthIndicatorService;
import org.elasticsearch.xpack.ilm.IndexLifecycleInfoTransportAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;
import org.elasticsearch.xpack.ilm.IndexLifecycleUsageTransportAction;
import org.elasticsearch.xpack.ilm.action.ReservedLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestExplainLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestGetLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestGetStatusAction;
import org.elasticsearch.xpack.ilm.action.RestMigrateToDataTiersAction;
import org.elasticsearch.xpack.ilm.action.RestMoveToStepAction;
import org.elasticsearch.xpack.ilm.action.RestPutLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.action.RestRetryAction;
import org.elasticsearch.xpack.ilm.action.RestStartILMAction;
import org.elasticsearch.xpack.ilm.action.RestStopAction;
import org.elasticsearch.xpack.ilm.action.TransportDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportExplainLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportGetLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportGetStatusAction;
import org.elasticsearch.xpack.ilm.action.TransportMigrateToDataTiersAction;
import org.elasticsearch.xpack.ilm.action.TransportMoveToStepAction;
import org.elasticsearch.xpack.ilm.action.TransportPutLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.action.TransportRetryAction;
import org.elasticsearch.xpack.ilm.action.TransportStartILMAction;
import org.elasticsearch.xpack.ilm.action.TransportStopILMAction;
import org.elasticsearch.xpack.ilm.history.ILMHistoryStore;
import org.elasticsearch.xpack.ilm.history.ILMHistoryTemplateRegistry;

public class IndexLifecycle
extends Plugin
implements ActionPlugin,
HealthPlugin {
    public static final List<NamedXContentRegistry.Entry> NAMED_X_CONTENT_ENTRIES = IndexLifecycle.xContentEntries();
    private final SetOnce<IndexLifecycleService> indexLifecycleInitialisationService = new SetOnce();
    private final SetOnce<ILMHistoryStore> ilmHistoryStore = new SetOnce();
    private final SetOnce<IlmHealthIndicatorService> ilmHealthIndicatorService = new SetOnce();
    private final SetOnce<ReservedLifecycleAction> reservedLifecycleAction = new SetOnce();
    private final Settings settings;

    public IndexLifecycle(Settings settings) {
        this.settings = settings;
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public List<Setting<?>> getSettings() {
        return List.of(LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING, LifecycleSettings.LIFECYCLE_NAME_SETTING, LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING, LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING, LifecycleSettings.LIFECYCLE_STEP_MASTER_TIMEOUT_SETTING, LifecycleSettings.LIFECYCLE_STEP_WAIT_TIME_THRESHOLD_SETTING, LifecycleSettings.LIFECYCLE_ROLLOVER_ONLY_IF_HAS_DOCUMENTS_SETTING, LifecycleSettings.LIFECYCLE_SKIP_SETTING, RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING, IlmHealthIndicatorService.MAX_TIME_ON_ACTION_SETTING, IlmHealthIndicatorService.MAX_TIME_ON_STEP_SETTING, IlmHealthIndicatorService.MAX_RETRIES_PER_STEP_SETTING);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ArrayList<Object> components = new ArrayList<Object>();
        ILMHistoryTemplateRegistry ilmTemplateRegistry = new ILMHistoryTemplateRegistry(this.settings, services.clusterService(), services.threadPool(), services.client(), services.xContentRegistry());
        ilmTemplateRegistry.initialize();
        this.ilmHistoryStore.set((Object)new ILMHistoryStore((Client)new OriginSettingClient(services.client(), "index_lifecycle"), services.clusterService(), services.threadPool()));
        LongSupplier nowSupplier = () -> ((ThreadPool)services.threadPool()).absoluteTimeInMillis();
        this.indexLifecycleInitialisationService.set((Object)new IndexLifecycleService(this.settings, services.client(), services.clusterService(), services.threadPool(), this.getClock(), nowSupplier, services.xContentRegistry(), (ILMHistoryStore)this.ilmHistoryStore.get(), this.getLicenseState()));
        components.add(this.indexLifecycleInitialisationService.get());
        this.ilmHealthIndicatorService.set((Object)new IlmHealthIndicatorService(services.clusterService(), new IlmHealthIndicatorService.StagnatingIndicesFinder(services.clusterService(), IlmHealthIndicatorService.RULES_BY_ACTION_CONFIG.values(), System::currentTimeMillis)));
        this.reservedLifecycleAction.set((Object)new ReservedLifecycleAction(services.xContentRegistry(), services.client(), XPackPlugin.getSharedLicenseState()));
        return components;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return NAMED_X_CONTENT_ENTRIES;
    }

    private static List<NamedXContentRegistry.Entry> xContentEntries() {
        return List.of(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("index_lifecycle", new String[0]), parser -> (Metadata.ProjectCustom)IndexLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("lifecycle_operation", new String[0]), parser -> (Metadata.ProjectCustom)LifecycleOperationMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(LifecycleType.class, new ParseField("timeseries", new String[0]), (p, c) -> TimeseriesLifecycleType.INSTANCE), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("allocate", new String[0]), AllocateAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("forcemerge", new String[0]), ForceMergeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("readonly", new String[0]), ReadOnlyAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("rollover", new String[0]), RolloverAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("shrink", new String[0]), ShrinkAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("delete", new String[0]), DeleteAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("freeze", new String[0]), FreezeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("set_priority", new String[0]), SetPriorityAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("unfollow", new String[0]), UnfollowAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("wait_for_snapshot", new String[0]), WaitForSnapshotAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("searchable_snapshot", new String[0]), SearchableSnapshotAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("migrate", new String[0]), MigrateAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("downsample", new String[0]), DownsampleAction::parse));
    }

    public List<RestHandler> getRestHandlers(Settings unused, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestHandler[]{new RestPutLifecycleAction(), new RestGetLifecycleAction(), new RestDeleteLifecycleAction(), new RestExplainLifecycleAction(), new RestRemoveIndexLifecyclePolicyAction(), new RestMoveToStepAction(), new RestRetryAction(), new RestStopAction(), new RestStartILMAction(), new RestGetStatusAction(), new RestMigrateToDataTiersAction()});
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return List.of(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.INDEX_LIFECYCLE, IndexLifecycleUsageTransportAction.class), new ActionPlugin.ActionHandler(XPackInfoFeatureAction.INDEX_LIFECYCLE, IndexLifecycleInfoTransportAction.class), new ActionPlugin.ActionHandler((ActionType)MigrateToDataTiersAction.INSTANCE, TransportMigrateToDataTiersAction.class), new ActionPlugin.ActionHandler(ILMActions.PUT, TransportPutLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)GetLifecycleAction.INSTANCE, TransportGetLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteLifecycleAction.INSTANCE, TransportDeleteLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)ExplainLifecycleAction.INSTANCE, TransportExplainLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)RemoveIndexLifecyclePolicyAction.INSTANCE, TransportRemoveIndexLifecyclePolicyAction.class), new ActionPlugin.ActionHandler(ILMActions.MOVE_TO_STEP, TransportMoveToStepAction.class), new ActionPlugin.ActionHandler(ILMActions.RETRY, TransportRetryAction.class), new ActionPlugin.ActionHandler(ILMActions.START, TransportStartILMAction.class), new ActionPlugin.ActionHandler(ILMActions.STOP, TransportStopILMAction.class), new ActionPlugin.ActionHandler((ActionType)GetStatusAction.INSTANCE, TransportGetStatusAction.class));
    }

    List<ReservedProjectStateHandler<?>> reservedProjectStateHandlers() {
        return List.of((ReservedProjectStateHandler)this.reservedLifecycleAction.get());
    }

    public Collection<HealthIndicatorService> getHealthIndicatorServices() {
        return List.of((HealthIndicatorService)this.ilmHealthIndicatorService.get());
    }

    public void onIndexModule(IndexModule indexModule) {
        assert (this.indexLifecycleInitialisationService.get() != null);
        indexModule.addIndexEventListener((IndexEventListener)this.indexLifecycleInitialisationService.get());
    }

    public void close() {
        try {
            IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.indexLifecycleInitialisationService.get(), (Closeable)this.ilmHistoryStore.get()});
        }
        catch (IOException e) {
            throw new ElasticsearchException("unable to close index lifecycle services", (Throwable)e, new Object[0]);
        }
    }
}

