/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class LowerHessenbergStore<N extends Comparable<N>>
extends ShadingStore<N> {
    LowerHessenbergStore(MatrixStore<N> base) {
        super(base);
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row + 1L < col) {
            return PrimitiveMath.ZERO;
        }
        return this.base().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        if (col == 0) {
            return 0;
        }
        return col - 1;
    }

    @Override
    public N get(long row, long col) {
        if (row + 1L < col) {
            return (N)((Comparable)this.zero().get());
        }
        return this.base().get(row, col);
    }

    @Override
    public int limitOfRow(int row) {
        return Math.min(row + 2, this.getColDim());
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row + 1L < col) {
            return this.zero();
        }
        return this.base().toScalar(row, col);
    }
}

