/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class LeftRightStore<N extends Comparable<N>>
extends ComposingStore<N> {
    private final MatrixStore<N> myRight;
    private final int mySplit;

    LeftRightStore(MatrixStore<N> base, MatrixStore<N> right) {
        super(base, base.countRows(), base.countColumns() + right.countColumns());
        this.myRight = right;
        this.mySplit = Math.toIntExact(base.countColumns());
        if (base.countRows() != right.countRows()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return col >= (long)this.mySplit ? this.myRight.doubleValue(row, col - (long)this.mySplit) : this.base().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        return col < this.mySplit ? this.base().firstInColumn(col) : this.myRight.firstInColumn(col - this.mySplit);
    }

    @Override
    public int firstInRow(int row) {
        int baseFirst = this.base().firstInRow(row);
        return baseFirst < this.mySplit ? baseFirst : this.mySplit + this.myRight.firstInRow(row);
    }

    @Override
    public N get(long row, long col) {
        return col >= (long)this.mySplit ? this.myRight.get(row, col - (long)this.mySplit) : this.base().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        return col < this.mySplit ? this.base().limitOfColumn(col) : this.myRight.limitOfColumn(col - this.mySplit);
    }

    @Override
    public int limitOfRow(int row) {
        int rightLimit = this.myRight.limitOfRow(row);
        return rightLimit == 0 ? this.base().limitOfRow(row) : this.mySplit + rightLimit;
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        super.multiply(right, target);
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        Future<MatrixStore<double>> futureLeft = this.executeMultiply(scalar);
        Object right = this.myRight.multiply(scalar);
        try {
            return new LeftRightStore<double>(futureLeft.get(), (MatrixStore<double>)right);
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        return super.multiply(right);
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        Future<MatrixStore<N>> futureLeft = this.executeMultiply(scalar);
        Object right = this.myRight.multiply((Comparable)scalar);
        try {
            return new LeftRightStore<N>(futureLeft.get(), right);
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public MatrixStore<N> premultiply(Access1D<N> left) {
        Future<ElementsSupplier<N>> futureLeft = this.executePremultiply(left);
        MatrixStore right = (MatrixStore)this.myRight.premultiply(left).collect(this.physical());
        try {
            return new LeftRightStore<N>((MatrixStore)futureLeft.get().collect(this.physical()), right);
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        this.base().supplyTo(receiver.regionByLimits(this.getRowDim(), this.mySplit));
        this.myRight.supplyTo(receiver.regionByOffsets(0, this.mySplit));
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return column >= (long)this.mySplit ? this.myRight.toScalar(row, column - (long)this.mySplit) : this.base().toScalar(row, column);
    }
}

