/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Structure2D;

public final class RationalMatrix
extends BasicMatrix<RationalNumber, RationalMatrix> {
    public static final Factory FACTORY = new Factory();

    RationalMatrix(ElementsSupplier<RationalNumber> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    @Override
    Cholesky<RationalNumber> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.RATIONAL.make(typical);
    }

    @Override
    DeterminantTask<RationalNumber> newDeterminantTask(Structure2D template) {
        return DeterminantTask.RATIONAL.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<RationalNumber> newEigenvalue(Structure2D typical) {
        return Eigenvalue.RATIONAL.make(typical, this.isHermitian());
    }

    @Override
    RationalMatrix newInstance(ElementsSupplier<RationalNumber> store) {
        return new RationalMatrix(store);
    }

    @Override
    InverterTask<RationalNumber> newInverterTask(Structure2D template) {
        return InverterTask.RATIONAL.make(template, this.isHermitian(), false);
    }

    @Override
    LDL<RationalNumber> newLDL(Structure2D typical) {
        return (LDL)LDL.RATIONAL.make(typical);
    }

    @Override
    LU<RationalNumber> newLU(Structure2D typical) {
        return (LU)LU.RATIONAL.make(typical);
    }

    @Override
    QR<RationalNumber> newQR(Structure2D typical) {
        return QR.RATIONAL.make(typical);
    }

    @Override
    SingularValue<RationalNumber> newSingularValue(Structure2D typical) {
        return SingularValue.RATIONAL.make(typical);
    }

    @Override
    SolverTask<RationalNumber> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.RATIONAL.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<RationalNumber, RationalMatrix, SparseStore<RationalNumber>> {
        SparseReceiver(SparseStore<RationalNumber> delegate) {
            super(delegate);
        }

        @Override
        RationalMatrix instantiate(MatrixStore<RationalNumber> store) {
            return (RationalMatrix)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<RationalNumber, RationalMatrix, DenseReceiver, SparseReceiver> {
        Factory() {
            super(RationalMatrix.class, GenericStore.RATIONAL);
        }

        @Override
        DenseReceiver dense(PhysicalStore<RationalNumber> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<RationalNumber> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<RationalNumber, RationalMatrix, PhysicalStore<RationalNumber>> {
        DenseReceiver(PhysicalStore<RationalNumber> delegate) {
            super(delegate);
        }

        @Override
        RationalMatrix instantiate(MatrixStore<RationalNumber> store) {
            return (RationalMatrix)FACTORY.instantiate(store);
        }
    }
}

