/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import org.ojalgo.machine.MemoryEstimator;

public enum JavaType {
    BOOLEAN(Boolean.TYPE, 1, 1L),
    BYTE(Byte.TYPE, 8, 1L),
    CHAR(Character.TYPE, 16, 2L),
    DOUBLE(Double.TYPE, 64, 8L),
    FLOAT(Float.TYPE, 32, 4L),
    INT(Integer.TYPE, 32, 4L),
    LONG(Long.TYPE, 64, 8L),
    REFERENCE(Object.class, 64, 4L),
    SHORT(Short.TYPE, 16, 2L);

    private final int myInformationBits;
    private final Class<?> myJavaClass;
    private final long myMemoryBytes;

    public static final JavaType match(Class<?> aClass) {
        for (JavaType tmpType : JavaType.values()) {
            if (!tmpType.getJavaClass().isAssignableFrom(aClass)) continue;
            return tmpType;
        }
        return null;
    }

    private JavaType(Class<?> aClass, int informationBits, long memoryBytes) {
        this.myJavaClass = aClass;
        this.myInformationBits = informationBits;
        this.myMemoryBytes = memoryBytes;
    }

    public final long estimateSizeOfWrapperClass() {
        return MemoryEstimator.makeForClassExtendingObject().add(this).estimate();
    }

    public final long memory() {
        return this.myMemoryBytes;
    }

    final int getInformationBits() {
        return this.myInformationBits;
    }

    Class<?> getJavaClass() {
        return this.myJavaClass;
    }
}

