/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public final class ConstantFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Constant<N> {
    private final int myArity;
    private Scalar<N> myConstant = null;
    private final PhysicalStore.Factory<N, ?> myFactory;

    public static ConstantFunction<ComplexNumber> makeComplex(int arity) {
        return new ConstantFunction<ComplexNumber>(arity, GenericStore.COMPLEX);
    }

    public static ConstantFunction<ComplexNumber> makeComplex(int arity, Comparable<?> constant) {
        return new ConstantFunction<ComplexNumber>(arity, GenericStore.COMPLEX, constant);
    }

    public static ConstantFunction<Double> makePrimitive(int arity) {
        return new ConstantFunction<Double>(arity, Primitive64Store.FACTORY);
    }

    public static ConstantFunction<Double> makePrimitive(int arity, Comparable<?> constant) {
        return new ConstantFunction<Double>(arity, Primitive64Store.FACTORY, constant);
    }

    public static ConstantFunction<RationalNumber> makeRational(int arity) {
        return new ConstantFunction<RationalNumber>(arity, GenericStore.RATIONAL);
    }

    public static ConstantFunction<RationalNumber> makeRational(int arity, Comparable<?> constant) {
        return new ConstantFunction<RationalNumber>(arity, GenericStore.RATIONAL, constant);
    }

    ConstantFunction(int arity, PhysicalStore.Factory<N, ?> factory, Comparable<?> constant) {
        this(arity, factory);
        this.setConstant(constant);
    }

    ConstantFunction(long arity, PhysicalStore.Factory<N, ?> factory) {
        this.myArity = Math.toIntExact(arity);
        this.myFactory = factory;
    }

    @Override
    public int arity() {
        return this.myArity;
    }

    @Override
    public N getConstant() {
        return (N)((Comparable)this.getScalarConstant().get());
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.getLinearFactors();
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myFactory.makeZero(this.myArity, this.myArity);
    }

    @Override
    public MatrixStore<N> getLinearFactors() {
        return this.myFactory.makeZero(this.myArity, 1L);
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return this.getConstant();
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myConstant = constant != null ? this.myFactory.scalar().convert(constant) : null;
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myFactory;
    }

    Scalar<N> getScalarConstant() {
        return this.myConstant != null ? this.myConstant : this.myFactory.scalar().zero();
    }
}

