/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.HashMap;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.LowerUpper;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.data.domain.finance.portfolio.OptimisedPortfolio;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.context.NumberContext;

public final class MarkowitzModel
extends OptimisedPortfolio {
    private static final double _0_0 = BigMath.ZERO.doubleValue();
    private static final double INIT = PrimitiveMath.SQRT.invoke(PrimitiveMath.TEN);
    private static final double MAX = PrimitiveMath.HUNDRED * PrimitiveMath.HUNDRED;
    private static final double MIN = PrimitiveMath.HUNDREDTH;
    private static final NumberContext TARGET_CONTEXT = NumberContext.of(5, 4);
    private final HashMap<int[], LowerUpper> myConstraints = new HashMap();
    private transient ExpressionsBasedModel myOptimisationModel;
    private BigDecimal myTargetReturn;
    private BigDecimal myTargetVariance;

    public MarkowitzModel(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
    }

    public MarkowitzModel(MarketEquilibrium marketEquilibrium, Primitive64Matrix expectedExcessReturns) {
        super(marketEquilibrium, expectedExcessReturns);
    }

    public MarkowitzModel(Primitive64Matrix covarianceMatrix, Primitive64Matrix expectedExcessReturns) {
        super(covarianceMatrix, expectedExcessReturns);
    }

    public LowerUpper addConstraint(BigDecimal lowerLimit, BigDecimal upperLimit, int ... assetIndeces) {
        return this.myConstraints.put(assetIndeces, new LowerUpper(lowerLimit, upperLimit));
    }

    public void clearAllConstraints() {
        this.myConstraints.clear();
        this.reset();
    }

    public void setLowerLimit(int assetIndex, BigDecimal lowerLimit) {
        this.getVariable(assetIndex).lower((Comparable)lowerLimit);
        this.reset();
    }

    public void setTargetReturn(BigDecimal targetReturn) {
        this.myTargetReturn = targetReturn;
        this.myTargetVariance = null;
        this.reset();
    }

    public void setTargetVariance(BigDecimal targetVariance) {
        this.myTargetVariance = targetVariance;
        this.myTargetReturn = null;
        this.reset();
    }

    public void setUpperLimit(int assetIndex, BigDecimal upperLimit) {
        this.getVariable(assetIndex).upper((Comparable)upperLimit);
        this.reset();
    }

    @Override
    public String toString() {
        if (this.myOptimisationModel == null) {
            this.calculateAssetWeights();
        }
        return this.myOptimisationModel.toString();
    }

    private ExpressionsBasedModel generateOptimisationModel(double riskAversion) {
        if (this.myOptimisationModel == null) {
            this.myOptimisationModel = this.makeModel(this.myConstraints);
        }
        this.myOptimisationModel.getExpression("Variance").weight(riskAversion / 2.0);
        if (this.getOptimisationOptions().logger_appender != null) {
            BasicLogger.debug();
            BasicLogger.debug("@@@@@@@@@@@");
            BasicLogger.debug("Iteration RAF: {}", riskAversion);
            BasicLogger.debug("Iteration point: {}", this.myOptimisationModel.getVariableValues());
            BasicLogger.debug("@@@@@@@@@@@");
            BasicLogger.debug();
        }
        return this.myOptimisationModel;
    }

    @Override
    protected Primitive64Matrix calculateAssetWeights() {
        Optimisation.Result tmpResult;
        if (this.getOptimisationOptions().logger_appender != null) {
            BasicLogger.debug();
            BasicLogger.debug("###################################################");
            BasicLogger.debug("BEGIN RAF: {} MarkowitzModel optimisation", this.getRiskAversion());
            BasicLogger.debug("###################################################");
            BasicLogger.debug();
        }
        if (this.myTargetReturn != null || this.myTargetVariance != null) {
            double tmpTargetValue = this.myTargetVariance != null ? this.myTargetVariance.doubleValue() : (this.myTargetReturn != null ? this.myTargetReturn.doubleValue() : _0_0);
            tmpResult = this.generateOptimisationModel(_0_0).minimise();
            double tmpTargetNow = _0_0;
            double tmpTargetDiff = _0_0;
            double tmpTargetLast = _0_0;
            if (tmpResult.getState().isFeasible()) {
                double tmpHigh;
                double tmpLow;
                double tmpCurrent;
                if (this.isDefaultRiskAversion()) {
                    tmpCurrent = INIT;
                    tmpLow = MAX;
                    tmpHigh = MIN;
                } else {
                    tmpCurrent = this.getRiskAversion().doubleValue();
                    tmpLow = tmpCurrent * INIT;
                    tmpHigh = tmpCurrent / INIT;
                }
                do {
                    ExpressionsBasedModel tmpModel = this.generateOptimisationModel(tmpCurrent);
                    tmpResult = tmpModel.minimise();
                    tmpTargetLast = tmpTargetNow;
                    tmpTargetNow = this.myTargetVariance != null ? this.calculatePortfolioVariance(tmpResult).doubleValue() : (this.myTargetReturn != null ? this.calculatePortfolioReturn(tmpResult, this.calculateAssetReturns()).doubleValue() : tmpTargetValue);
                    tmpTargetDiff = tmpTargetNow - tmpTargetValue;
                    if (this.getOptimisationOptions().logger_appender != null) {
                        BasicLogger.debug();
                        BasicLogger.debug("RAF:   {}", tmpCurrent);
                        BasicLogger.debug("Last: {}", tmpTargetLast);
                        BasicLogger.debug("Now: {}", tmpTargetNow);
                        BasicLogger.debug("Target: {}", tmpTargetValue);
                        BasicLogger.debug("Diff:   {}", tmpTargetDiff);
                        BasicLogger.debug("Iteration:   {}", tmpResult);
                        BasicLogger.debug();
                    }
                    if (tmpTargetDiff < _0_0) {
                        tmpLow = tmpCurrent;
                    } else if (tmpTargetDiff > _0_0) {
                        tmpHigh = tmpCurrent;
                    }
                    tmpCurrent = PrimitiveMath.SQRT.invoke(tmpLow * tmpHigh);
                } while (!TARGET_CONTEXT.isSmall(tmpTargetValue, tmpTargetDiff) && TARGET_CONTEXT.isDifferent(tmpHigh, tmpLow));
            }
        } else {
            tmpResult = this.generateOptimisationModel(this.getRiskAversion().doubleValue()).minimise();
        }
        return this.handle(tmpResult);
    }

    @Override
    protected void reset() {
        super.reset();
        this.myOptimisationModel = null;
    }

    Scalar<?> calculatePortfolioReturn(Access1D<?> weightsVctr, Primitive64Matrix returnsVctr) {
        return super.calculatePortfolioReturn((Primitive64Matrix)MATRIX_FACTORY.columns(new Access1D[]{weightsVctr}), returnsVctr);
    }

    Scalar<?> calculatePortfolioVariance(Access1D<?> weightsVctr) {
        return super.calculatePortfolioVariance((Primitive64Matrix)MATRIX_FACTORY.columns(new Access1D[]{weightsVctr}));
    }
}

