/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.Collections;
import java.util.Map;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.LowerUpper;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.data.domain.finance.portfolio.OptimisedPortfolio;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;

public final class EfficientFrontier
extends OptimisedPortfolio {
    private static final Map<int[], LowerUpper> CONSTRAINTS = Collections.emptyMap();
    private final ExpressionsBasedModel myOptimisationModel = this.makeModel(CONSTRAINTS);

    public EfficientFrontier(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
    }

    public EfficientFrontier(MarketEquilibrium marketEquilibrium, Primitive64Matrix expectedExcessReturns) {
        super(marketEquilibrium, expectedExcessReturns);
    }

    public EfficientFrontier(Primitive64Matrix covarianceMatrix, Primitive64Matrix expectedExcessReturns) {
        super(covarianceMatrix, expectedExcessReturns);
    }

    @Override
    protected Primitive64Matrix calculateAssetWeights() {
        this.myOptimisationModel.getExpression("Variance").weight(this.getRiskAversion().doubleValue() / 2.0);
        Optimisation.Result tmpResult = this.myOptimisationModel.minimise();
        return this.handle(tmpResult);
    }

    @Override
    protected void reset() {
        super.reset();
        boolean tmpAllowed = this.isShortingAllowed();
        this.myOptimisationModel.getVariables().forEach(v -> v.lower((Comparable)(tmpAllowed ? null : BigMath.ZERO)));
    }
}

