/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public final class GenerateApplyAndCopyHouseholderRow
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static boolean invoke(double[] data, int structure, int row, int col, Householder.Primitive64 destination) {
        int tmpColDim = data.length / structure;
        double[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = PrimitiveMath.MAX.invoke(tmpNormInf, PrimitiveMath.ABS.invoke(tmpVector[j]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int j = col + 1;
            while (j < tmpColDim) {
                int n = j++;
                double d = tmpVector[n] / tmpNormInf;
                tmpVector[n] = d;
                double tmpVal = d;
                tmpNorm2 += tmpVal * tmpVal;
            }
            double value = tmpNorm2;
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, value);
        }
        if (retVal) {
            double tmpScale = tmpVector[col] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = PrimitiveMath.SQRT.invoke(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + col * structure] = tmpNorm2 * tmpNormInf;
                tmpScale -= tmpNorm2;
            } else {
                data[row + col * structure] = -tmpNorm2 * tmpNormInf;
                tmpScale += tmpNorm2;
            }
            tmpVector[col] = PrimitiveMath.ONE;
            for (int j = col + 1; j < tmpColDim; ++j) {
                int n = j;
                double d = tmpVector[n] / tmpScale;
                tmpVector[n] = d;
                data[row + j * structure] = d;
            }
            destination.beta = PrimitiveMath.ABS.invoke(tmpScale) / tmpNorm2;
        }
        return retVal;
    }

    public static boolean invoke(float[] data, int structure, int row, int col, Householder.Primitive32 destination) {
        int tmpColDim = data.length / structure;
        float[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = PrimitiveMath.MAX.invoke(tmpNormInf, (double)PrimitiveMath.ABS.invoke(tmpVector[j]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int j = col + 1;
            while (j < tmpColDim) {
                int n = j++;
                float f = (float)((double)tmpVector[n] / tmpNormInf);
                tmpVector[n] = f;
                double tmpVal = f;
                tmpNorm2 += tmpVal * tmpVal;
            }
            double value = tmpNorm2;
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, value);
        }
        if (retVal) {
            double tmpScale = (double)tmpVector[col] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = PrimitiveMath.SQRT.invoke(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + col * structure] = (float)(tmpNorm2 * tmpNormInf);
                tmpScale -= tmpNorm2;
            } else {
                data[row + col * structure] = (float)(-tmpNorm2 * tmpNormInf);
                tmpScale += tmpNorm2;
            }
            tmpVector[col] = (float)PrimitiveMath.ONE;
            for (int j = col + 1; j < tmpColDim; ++j) {
                int n = j;
                float f = (float)((double)tmpVector[n] / tmpScale);
                tmpVector[n] = f;
                data[row + j * structure] = f;
            }
            destination.beta = (float)(PrimitiveMath.ABS.invoke(tmpScale) / tmpNorm2);
        }
        return retVal;
    }

    public static <N extends Scalar<N>> boolean invoke(N[] data, int structure, int row, int col, Householder.Generic<N> destination, Scalar.Factory<N> scalar) {
        int tmpColDim = data.length / structure;
        N[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = PrimitiveMath.MAX.invoke(tmpNormInf, tmpVector[j].norm());
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            for (int j = col + 1; j < tmpColDim; ++j) {
                Scalar tmpVal = (Scalar)((Scalar)tmpVector[j].divide(tmpNormInf)).get();
                tmpNorm2 += tmpVal.norm() * tmpVal.norm();
                tmpVector[j] = tmpVal;
            }
            double value = tmpNorm2;
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, value);
        }
        if (retVal) {
            Scalar tmpScale = (Scalar)((Scalar)tmpVector[col].divide(tmpNormInf)).get();
            tmpNorm2 += tmpScale.norm() * tmpScale.norm();
            tmpNorm2 = PrimitiveMath.SQRT.invoke(tmpNorm2);
            data[row + col * structure] = (Scalar)((Scalar)((Scalar)tmpScale.signum()).multiply(tmpNorm2 * tmpNormInf)).get();
            tmpScale = (Scalar)tmpScale.subtract((Scalar)((Scalar)tmpScale.signum()).multiply(tmpNorm2)).get();
            tmpVector[col] = (Scalar)scalar.one().get();
            for (int j = col + 1; j < tmpColDim; ++j) {
                tmpVector[j] = (Scalar)((Scalar)tmpVector[j].divide((Scalar)tmpScale).conjugate()).get();
                data[row + j * structure] = tmpVector[j];
            }
            destination.beta = (Scalar)scalar.cast(tmpScale.norm() / tmpNorm2);
        }
        return retVal;
    }
}

