/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal.vectorization;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.simdvec.ES91Int4VectorsScorer;
import org.elasticsearch.simdvec.ES91OSQVectorsScorer;
import org.elasticsearch.simdvec.internal.vectorization.DefaultESVectorizationProvider;
import org.elasticsearch.simdvec.internal.vectorization.ESVectorUtilSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ESVectorizationProvider {
    public static ESVectorizationProvider getInstance() {
        return Objects.requireNonNull(Holder.INSTANCE, "call to getInstance() from subclass of VectorizationProvider");
    }

    ESVectorizationProvider() {
    }

    public abstract ESVectorUtilSupport getVectorUtilSupport();

    public abstract ES91OSQVectorsScorer newES91OSQVectorsScorer(IndexInput var1, int var2) throws IOException;

    public abstract ES91Int4VectorsScorer newES91Int4VectorsScorer(IndexInput var1, int var2) throws IOException;

    static ESVectorizationProvider lookup(boolean testMode) {
        return new DefaultESVectorizationProvider();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Holder {
        static final ESVectorizationProvider INSTANCE = ESVectorizationProvider.lookup(false);

        private Holder() {
        }
    }
}

