/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.url.URLBlobContainer;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.blobstore.url.http.RetryingHttpInputStream;
import org.elasticsearch.common.blobstore.url.http.URLHttpClient;
import org.elasticsearch.common.blobstore.url.http.URLHttpClientSettings;

public class HttpURLBlobContainer
extends URLBlobContainer {
    private final URLHttpClient httpClient;
    private final URLHttpClientSettings httpClientSettings;

    public HttpURLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path, URLHttpClient httpClient, URLHttpClientSettings httpClientSettings) {
        super(blobStore, blobPath, path);
        this.httpClient = httpClient;
        this.httpClientSettings = httpClientSettings;
    }

    @Override
    public InputStream readBlob(OperationPurpose purpose, String name, long position, long length) throws IOException {
        if (length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new RetryingHttpInputStream(name, this.getURIForBlob(name), position, Math.addExact(position, length) - 1L, this.httpClient, this.httpClientSettings.getMaxRetries());
    }

    @Override
    public InputStream readBlob(OperationPurpose purpose, String name) throws IOException {
        return new RetryingHttpInputStream(name, this.getURIForBlob(name), this.httpClient, this.httpClientSettings.getMaxRetries());
    }

    private URI getURIForBlob(String name) throws IOException {
        try {
            return new URL(this.path, name).toURI();
        }
        catch (Exception e) {
            throw new IOException("Unable to get an URI for blob with name [" + name + "]", e);
        }
    }
}

